/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.ie.InternetExplorerDriverLogLevel;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;

public class InternetExplorerDriverService
extends DriverService {
    public static final String IE_DRIVER_NAME = "IEDriverServer";
    public static final String IE_DRIVER_EXE_PROPERTY = "webdriver.ie.driver";
    public static final String IE_DRIVER_EXE_ENVIRONMENT_VARIABLE = "SE_IEDRIVER";
    public static final String IE_DRIVER_LOGFILE_PROPERTY = "webdriver.ie.driver.logfile";
    public static final String IE_DRIVER_LOGLEVEL_PROPERTY = "webdriver.ie.driver.loglevel";
    public static final String IE_DRIVER_HOST_PROPERTY = "webdriver.ie.driver.host";
    public static final String IE_DRIVER_EXTRACT_PATH_PROPERTY = "webdriver.ie.driver.extractpath";
    public static final String IE_DRIVER_SILENT_PROPERTY = "webdriver.ie.driver.silent";

    public InternetExplorerDriverService(@Nullable File executable, int port, @Nullable Duration timeout, @Nullable List<String> args2, @Nullable Map<String, String> environment) throws IOException {
        super(executable, port, timeout, Collections.unmodifiableList(new ArrayList<String>(args2)), Collections.unmodifiableMap(new HashMap<String, String>(environment)));
    }

    @Override
    public String getDriverName() {
        return IE_DRIVER_NAME;
    }

    @Override
    public String getDriverProperty() {
        return IE_DRIVER_EXE_PROPERTY;
    }

    @Override
    public String getDriverEnvironmentVariable() {
        return IE_DRIVER_EXE_ENVIRONMENT_VARIABLE;
    }

    @Override
    public Capabilities getDefaultDriverOptions() {
        return new InternetExplorerOptions();
    }

    public static InternetExplorerDriverService createDefaultService() {
        return (InternetExplorerDriverService)new Builder().build();
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<InternetExplorerDriverService, Builder> {
        private @Nullable InternetExplorerDriverLogLevel logLevel;
        private @Nullable String host = null;
        private @Nullable File extractPath = null;
        private @Nullable Boolean silent = null;

        @Override
        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.IE.is(capabilities)) {
                ++score;
            }
            if (capabilities.getCapability("se:ieOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withLogLevel(@Nullable InternetExplorerDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder withHost(@Nullable String host2) {
            this.host = host2;
            return this;
        }

        public Builder withExtractPath(@Nullable File extractPath) {
            this.extractPath = extractPath;
            return this;
        }

        public Builder withSilent(@Nullable Boolean silent) {
            this.silent = silent;
            return this;
        }

        @Override
        protected void loadSystemProperties() {
            String silentProperty;
            String extractPathProperty;
            String hostProperty;
            String level;
            this.parseLogOutput(InternetExplorerDriverService.IE_DRIVER_LOGFILE_PROPERTY);
            if (this.logLevel == null && (level = System.getProperty(InternetExplorerDriverService.IE_DRIVER_LOGLEVEL_PROPERTY)) != null) {
                this.logLevel = InternetExplorerDriverLogLevel.valueOf(level);
            }
            if (this.host == null && (hostProperty = System.getProperty(InternetExplorerDriverService.IE_DRIVER_HOST_PROPERTY)) != null) {
                this.host = hostProperty;
            }
            if (this.extractPath == null && (extractPathProperty = System.getProperty(InternetExplorerDriverService.IE_DRIVER_EXTRACT_PATH_PROPERTY)) != null) {
                this.extractPath = new File(extractPathProperty);
            }
            if (this.silent == null && (silentProperty = System.getProperty(InternetExplorerDriverService.IE_DRIVER_SILENT_PROPERTY)) != null) {
                this.silent = Boolean.valueOf(silentProperty);
            }
        }

        @Override
        protected List<String> createArgs() {
            ArrayList<String> args2 = new ArrayList<String>();
            args2.add(String.format(Locale.ROOT, "--port=%d", this.getPort()));
            if (this.logLevel != null) {
                args2.add(String.format("--log-level=%s", new Object[]{this.logLevel}));
            }
            if (this.host != null) {
                args2.add(String.format("--host=%s", this.host));
            }
            if (this.extractPath != null) {
                args2.add(String.format("--extract-path=\"%s\"", this.extractPath.getAbsolutePath()));
            }
            if (Boolean.TRUE.equals(this.silent)) {
                args2.add("--silent");
            }
            return Collections.unmodifiableList(args2);
        }

        @Override
        protected InternetExplorerDriverService createDriverService(@Nullable File exe, int port, @Nullable Duration timeout, @Nullable List<String> args2, @Nullable Map<String, String> environment) {
            try {
                return new InternetExplorerDriverService(exe, port, timeout, args2, environment);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

