/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.DefaultNetworkInterfaceProvider;
import org.openqa.selenium.net.NetworkInterface;
import org.openqa.selenium.net.NetworkInterfaceProvider;

public class NetworkUtils {
    private static InetAddress cachedIp4NonLoopbackAddressOfThisMachine;
    private static String cachedIp4NonLoopbackAddressHostName;
    private final NetworkInterfaceProvider networkInterfaceProvider;
    private volatile String hostname;
    private volatile String address;

    NetworkUtils(NetworkInterfaceProvider networkInterfaceProvider) {
        this.networkInterfaceProvider = networkInterfaceProvider;
    }

    public NetworkUtils() {
        this(new DefaultNetworkInterfaceProvider());
    }

    public String getHostname() {
        this.determineHostnameAndAddress();
        return this.hostname;
    }

    public String getHostAddress() {
        this.determineHostnameAndAddress();
        return this.address;
    }

    public String getPrivateLocalAddress() {
        List<InetAddress> addresses = this.getLocalInterfaceAddress();
        if (addresses.isEmpty()) {
            return "127.0.0.1";
        }
        return addresses.get(0).getHostAddress();
    }

    public String getNonLoopbackAddressOfThisMachine() {
        InetAddress ip4NonLoopbackAddressOfThisMachine = this.getIp4NonLoopbackAddressOfThisMachine();
        if (!Objects.equals(cachedIp4NonLoopbackAddressOfThisMachine, ip4NonLoopbackAddressOfThisMachine)) {
            cachedIp4NonLoopbackAddressOfThisMachine = ip4NonLoopbackAddressOfThisMachine;
            cachedIp4NonLoopbackAddressHostName = ip4NonLoopbackAddressOfThisMachine.getHostAddress();
        }
        return cachedIp4NonLoopbackAddressHostName;
    }

    public InetAddress getIp4NonLoopbackAddressOfThisMachine() {
        for (NetworkInterface iface : this.networkInterfaceProvider.getNetworkInterfaces()) {
            InetAddress ip4NonLoopback = iface.getIp4NonLoopBackOnly();
            if (ip4NonLoopback == null) continue;
            return ip4NonLoopback;
        }
        throw new WebDriverException("Could not find a non-loopback ip4 address for this machine");
    }

    public String obtainLoopbackIp4Address() {
        InetAddress netAddress;
        NetworkInterface linuxLoopback;
        NetworkInterface networkInterface = this.getLoopBackAndIp4Only();
        if (networkInterface != null) {
            return networkInterface.getIp4LoopbackOnly().getHostName();
        }
        String ipOfIp4LoopBack = this.getIpOfLoopBackIp4();
        if (ipOfIp4LoopBack != null) {
            return ipOfIp4LoopBack;
        }
        if (Platform.getCurrent().is(Platform.UNIX) && (linuxLoopback = this.networkInterfaceProvider.getLoInterface()) != null && (netAddress = linuxLoopback.getIp4LoopbackOnly()) != null) {
            return netAddress.getHostAddress();
        }
        throw new WebDriverException("Unable to resolve local loopback address, please file an issue with the full message of this error:\n" + NetworkUtils.getNetWorkDiags() + "\n==== End of error message");
    }

    private InetAddress grabFirstNetworkAddress() {
        NetworkInterface firstInterface = this.networkInterfaceProvider.getNetworkInterfaces().iterator().next();
        InetAddress firstAddress = null;
        if (firstInterface != null) {
            firstAddress = firstInterface.getInetAddresses().iterator().next();
        }
        if (firstAddress == null) {
            throw new WebDriverException("Unable to find any network address for localhost");
        }
        return firstAddress;
    }

    public String getIpOfLoopBackIp4() {
        for (NetworkInterface iface : this.networkInterfaceProvider.getNetworkInterfaces()) {
            InetAddress netAddress = iface.getIp4LoopbackOnly();
            if (netAddress == null) continue;
            return netAddress.getHostAddress();
        }
        return null;
    }

    private NetworkInterface getLoopBackAndIp4Only() {
        for (NetworkInterface iface : this.networkInterfaceProvider.getNetworkInterfaces()) {
            if (!iface.isIp4AddressBindingOnly() || !iface.isLoopBack()) continue;
            return iface;
        }
        return null;
    }

    private List<InetAddress> getLocalInterfaceAddress() {
        NetworkInterface linuxLoopback;
        ArrayList<InetAddress> localAddresses = new ArrayList<InetAddress>();
        for (NetworkInterface iface : this.networkInterfaceProvider.getNetworkInterfaces()) {
            for (InetAddress addr : iface.getInetAddresses()) {
                if (!addr.isLoopbackAddress() || NetworkInterface.isIpv6(addr)) continue;
                localAddresses.add(addr);
            }
        }
        if (Platform.getCurrent().is(Platform.UNIX) && (linuxLoopback = this.networkInterfaceProvider.getLoInterface()) != null) {
            for (InetAddress inetAddress : linuxLoopback.getInetAddresses()) {
                if (NetworkInterface.isIpv6(inetAddress)) continue;
                localAddresses.add(inetAddress);
            }
        }
        if (localAddresses.isEmpty()) {
            return Collections.singletonList(this.grabFirstNetworkAddress());
        }
        return localAddresses;
    }

    public static String getNetWorkDiags() {
        StringBuilder result = new StringBuilder();
        DefaultNetworkInterfaceProvider defaultNetworkInterfaceProvider = new DefaultNetworkInterfaceProvider();
        for (NetworkInterface networkInterface : defaultNetworkInterfaceProvider.getNetworkInterfaces()) {
            NetworkUtils.dumpToConsole(result, networkInterface);
        }
        NetworkInterface byName = defaultNetworkInterfaceProvider.getLoInterface();
        if (byName != null) {
            result.append("Loopback interface LO:\n");
            NetworkUtils.dumpToConsole(result, byName);
        }
        return result.toString();
    }

    private static void dumpToConsole(StringBuilder result, NetworkInterface inNetworkInterface) {
        if (inNetworkInterface == null) {
            return;
        }
        result.append(inNetworkInterface.getName());
        result.append("\n");
        NetworkUtils.dumpAddresses(result, inNetworkInterface.getInetAddresses());
    }

    private static void dumpAddresses(StringBuilder result, Iterable<InetAddress> inetAddresses) {
        for (InetAddress address : inetAddresses) {
            result.append("   address.getHostName() = ");
            result.append(address.getHostName());
            result.append("\n");
            result.append("   address.getHostAddress() = ");
            result.append(address.getHostAddress());
            result.append("\n");
            result.append("   address.isLoopbackAddress() = ");
            result.append(address.isLoopbackAddress());
            result.append("\n");
        }
    }

    private synchronized void determineHostnameAndAddress() {
        String host2;
        block31: {
            if (this.hostname != null) {
                return;
            }
            host2 = System.getenv("HOSTNAME");
            if (host2 == null) {
                host2 = System.getenv("COMPUTERNAME");
            }
            if (host2 == null && Platform.getCurrent().is(Platform.MAC)) {
                try {
                    Process process = Runtime.getRuntime().exec("hostname");
                    if (!process.waitFor(2L, TimeUnit.SECONDS)) {
                        process.destroyForcibly();
                        process.waitFor(2L, TimeUnit.SECONDS);
                    }
                    if (process.exitValue() != 0) break block31;
                    try (InputStreamReader isr = new InputStreamReader(process.getInputStream(), Charset.defaultCharset());
                         BufferedReader reader = new BufferedReader(isr);){
                        host2 = reader.readLine();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (host2 == null) {
            try {
                host2 = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                host2 = "localhost";
            }
        }
        this.hostname = host2;
        String address = null;
        if (Platform.getCurrent().is(Platform.MAC)) {
            try {
                for (NetworkInterface iface : this.networkInterfaceProvider.getNetworkInterfaces()) {
                    if (iface.getName().startsWith("en")) {
                        for (InetAddress inetAddress : iface.getInetAddresses()) {
                            try {
                                if (!inetAddress.isReachable(100)) continue;
                                address = inetAddress.getHostAddress();
                                break;
                            }
                            catch (ConnectException connectException) {
                            }
                        }
                    }
                    if (address == null) continue;
                    break;
                }
            }
            catch (Exception isr) {
                // empty catch block
            }
        }
        if (address == null) {
            try {
                address = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                address = "127.0.0.1";
            }
        }
        this.address = address;
    }
}

