/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlTemplate {
    private static final Pattern GROUP_NAME = Pattern.compile("(\\{\\p{Alnum}+\\})");
    private final Function<String, Match> compiled;

    public UrlTemplate(String template) {
        if (template == null || template.isEmpty()) {
            throw new IllegalArgumentException("Template must not be 0 length");
        }
        StringBuilder regex2 = new StringBuilder("^");
        Matcher groupNameMatcher = GROUP_NAME.matcher(template);
        ArrayList<String> groups2 = new ArrayList<String>();
        int lastStart = 0;
        int lastGroup = 0;
        while (groupNameMatcher.find()) {
            int start2 = groupNameMatcher.start(1);
            int end = groupNameMatcher.end(1);
            regex2.append(Pattern.quote(template.substring(lastGroup, start2)));
            regex2.append("([^/]+)");
            groups2.add(template.substring(start2 + 1, end - 1));
            lastStart = start2;
            lastGroup = end;
        }
        if (template.length() > lastGroup) {
            regex2.append(Pattern.quote(template.substring(lastGroup)));
        }
        regex2.append('$');
        List allGroups = List.copyOf(groups2);
        int groupsCount = allGroups.size();
        switch (groupsCount) {
            case 0: {
                this.compiled = matchAgainst -> {
                    if (!template.equals(matchAgainst)) {
                        return null;
                    }
                    return new Match((String)matchAgainst, Collections.emptyMap());
                };
                break;
            }
            case 1: {
                String groupName = template.substring(lastStart + 1, lastGroup - 1);
                String prefix = template.substring(0, lastStart);
                String suffix = template.substring(lastGroup);
                this.compiled = matchAgainst -> {
                    if (matchAgainst.length() <= prefix.length() + suffix.length()) {
                        return null;
                    }
                    if (!matchAgainst.startsWith(prefix)) {
                        return null;
                    }
                    if (!matchAgainst.endsWith(suffix)) {
                        return null;
                    }
                    String groupValue = matchAgainst.substring(prefix.length(), matchAgainst.length() - suffix.length());
                    if (groupValue.indexOf(47) != -1) {
                        return null;
                    }
                    return new Match((String)matchAgainst, Collections.singletonMap(groupName, groupValue));
                };
                break;
            }
            default: {
                Pattern pattern = Pattern.compile(regex2.toString());
                this.compiled = matchAgainst -> {
                    Matcher matcher = pattern.matcher((CharSequence)matchAgainst);
                    if (!matcher.matches()) {
                        return null;
                    }
                    LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                    for (int i = 0; i < groupsCount; ++i) {
                        params.put((String)allGroups.get(i), matcher.group(i + 1));
                    }
                    return new Match((String)matchAgainst, Map.copyOf(params));
                };
            }
        }
    }

    public Match match(String matchAgainst) {
        if (matchAgainst == null) {
            return null;
        }
        return this.compiled.apply(matchAgainst);
    }

    public Match match(String matchAgainst, String prefix) {
        if (matchAgainst == null || prefix == null) {
            return null;
        }
        if (!prefix.isEmpty() && !prefix.equals("/")) {
            matchAgainst = matchAgainst.replaceFirst(prefix, "");
        }
        return this.match(matchAgainst);
    }

    public class Match {
        private final String url;
        private final Map<String, String> parameters;

        private Match(String url2, Map<String, String> parameters) {
            this.url = url2;
            this.parameters = Map.copyOf(parameters);
        }

        public String getUrl() {
            return this.url;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }
    }
}

