/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.jdk;

import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class JdkHttpMessages {
    private final ClientConfig config;
    private static final List<String> IGNORE_HEADERS = List.of("content-length", "connection", "host");

    public JdkHttpMessages(ClientConfig config) {
        this.config = Objects.requireNonNull(config, "Client config");
    }

    public java.net.http.HttpRequest createRequest(HttpRequest req, HttpMethod method, URI rawUri) {
        Object rawUrl = rawUri.toString();
        String queryString = StreamSupport.stream(req.getQueryParameterNames().spliterator(), false).map(name -> StreamSupport.stream(req.getQueryParameters((String)name).spliterator(), false).map(value -> String.format("%s=%s", URLEncoder.encode(name, StandardCharsets.UTF_8), URLEncoder.encode(value, StandardCharsets.UTF_8))).collect(Collectors.joining("&"))).collect(Collectors.joining("&"));
        if (!queryString.isEmpty()) {
            rawUrl = (String)rawUrl + "?" + queryString;
        }
        HttpRequest.Builder builder = java.net.http.HttpRequest.newBuilder().uri(URI.create((String)rawUrl));
        switch (method) {
            case DELETE: {
                builder.DELETE();
                break;
            }
            case GET: {
                builder.GET();
                break;
            }
            case POST: {
                builder.POST(this.notChunkingBodyPublisher(req));
                break;
            }
            case PUT: {
                builder.PUT(this.notChunkingBodyPublisher(req));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported request method %s: %s", new Object[]{req.getMethod(), req}));
            }
        }
        req.forEachHeader((name, value) -> {
            if (IGNORE_HEADERS.contains(name.toLowerCase(Locale.ENGLISH))) {
                return;
            }
            builder.header((String)name, (String)value);
        });
        if (req.getHeader("User-Agent") == null) {
            builder.header("User-Agent", AddSeleniumUserAgent.USER_AGENT);
        }
        builder.timeout(this.config.readTimeout());
        return builder.build();
    }

    private HttpRequest.BodyPublisher notChunkingBodyPublisher(HttpRequest req) {
        Contents.Supplier content = req.getContent();
        if (content.length() > 0) {
            HttpRequest.BodyPublisher chunking = HttpRequest.BodyPublishers.ofInputStream(content);
            return HttpRequest.BodyPublishers.fromPublisher(chunking, content.length());
        }
        return HttpRequest.BodyPublishers.noBody();
    }

    public URI getRawUri(HttpRequest req) {
        String base;
        URI baseUrl = this.config.baseUri();
        String uri2 = req.getUri();
        Object rawUrl = uri2.startsWith("ws://") || uri2.startsWith("wss://") || uri2.startsWith("http://") || uri2.startsWith("https://") ? uri2 : ((base = baseUrl.toString()).endsWith("/") ? base.substring(0, base.length() - 1) + uri2 : base + uri2);
        return URI.create((String)rawUrl);
    }

    public HttpResponse createResponse(java.net.http.HttpResponse<byte[]> response) {
        HttpResponse res = new HttpResponse();
        res.setStatus(response.statusCode());
        response.headers().map().forEach((name, values2) -> values2.stream().filter(Objects::nonNull).forEach(value -> res.addHeader((String)name, (String)value)));
        byte[] responseBody = response.body();
        if (responseBody != null) {
            res.setContent(Contents.bytes(responseBody));
        }
        return res;
    }
}

