/*
 * Decompiled with CFR 0.152.
 */
package zmq.util;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import zmq.ZMQ;
import zmq.util.Clock;
import zmq.util.MultiMap;
import zmq.util.Utils;
import zmq.util.function.Supplier;

public final class Timers {
    private final MultiMap<Long, Timer> timers = new MultiMap();
    private final Supplier<Long> clock;

    public Timers() {
        this(() -> TimeUnit.NANOSECONDS.toMillis(Clock.nowNS()));
    }

    public Timers(Supplier<Long> clock) {
        this.clock = clock;
    }

    private long now() {
        return this.clock.get();
    }

    private boolean insert(Timer timer) {
        return this.timers.insert(this.now() + timer.interval, timer);
    }

    public Timer add(long interval, Handler handler, Object ... args2) {
        if (handler == null) {
            return null;
        }
        Utils.checkArgument(interval > 0L, "Delay of a timer has to be strictly greater than 0");
        Timer timer = new Timer(this, interval, handler, args2);
        boolean rc = this.insert(timer);
        assert (rc);
        return timer;
    }

    @Deprecated
    public boolean setInterval(Timer timer, long interval) {
        assert (timer.parent == this);
        return timer.setInterval(interval);
    }

    @Deprecated
    public boolean reset(Timer timer) {
        assert (timer.parent == this);
        return timer.reset();
    }

    @Deprecated
    public boolean cancel(Timer timer) {
        assert (timer.parent == this);
        return timer.cancel();
    }

    public long timeout() {
        long now = this.now();
        for (Map.Entry<Timer, Long> entry : this.entries()) {
            Timer timer = entry.getKey();
            Long expiration = entry.getValue();
            if (timer.alive) {
                if (expiration - now > 0L) {
                    return expiration - now;
                }
                return 0L;
            }
            this.timers.remove(expiration, timer);
        }
        return -1L;
    }

    public int execute() {
        int executed = 0;
        long now = this.now();
        for (Map.Entry<Timer, Long> entry : this.entries()) {
            Timer timer = entry.getKey();
            Long expiration = entry.getValue();
            if (!timer.alive) {
                this.timers.remove(expiration, timer);
                continue;
            }
            if (expiration - now > 0L) break;
            this.insert(timer);
            timer.handler.time(timer.args);
            ++executed;
        }
        return executed;
    }

    Iterable<Map.Entry<Timer, Long>> entries() {
        return this.timers.entries();
    }

    public int sleepAndExecute() {
        long timeout = this.timeout();
        while (timeout > 0L) {
            ZMQ.msleep(timeout);
            timeout = this.timeout();
        }
        return this.execute();
    }

    public static final class Timer {
        private final Timers parent;
        private long interval;
        private boolean alive = true;
        private final Handler handler;
        private final Object[] args;

        private Timer(Timers parent, long interval, Handler handler, Object ... args2) {
            assert (args2 != null);
            this.parent = parent;
            this.interval = interval;
            this.handler = handler;
            this.args = args2;
        }

        public boolean setInterval(long interval) {
            if (this.alive) {
                this.interval = interval;
                return this.parent.insert(this);
            }
            return false;
        }

        public boolean reset() {
            if (this.alive) {
                return this.parent.insert(this);
            }
            return false;
        }

        public boolean cancel() {
            if (this.alive) {
                this.alive = false;
                return true;
            }
            return false;
        }
    }

    public static interface Handler {
        public void time(Object ... var1);
    }
}

