/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BoundSet;
import org.eclipse.jdt.internal.compiler.lookup.ImplicitNullAnnotationVerifier;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceFailureException;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedGenericMethodBinding
extends ParameterizedMethodBinding
implements Substitution {
    public TypeBinding[] typeArguments;
    protected LookupEnvironment environment;
    public boolean inferredReturnType;
    public boolean wasInferred;
    public boolean isRaw;
    public boolean inferredWithUncheckedConversion;
    public TypeBinding targetType;

    public static MethodBinding computeCompatibleMethod(MethodBinding originalMethod, TypeBinding[] arguments, Scope scope, InvocationSite invocationSite) {
        LookupEnvironment environment = scope.environment();
        if (environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
            ImplicitNullAnnotationVerifier.ensureNullnessIsKnown(originalMethod, scope);
        }
        TypeVariableBinding[] typeVariables = originalMethod.typeVariables;
        TypeBinding[] substitutes = invocationSite.genericTypeArguments();
        if (substitutes != null) {
            if (substitutes.length != typeVariables.length) {
                return new ProblemMethodBinding(originalMethod, originalMethod.selector, substitutes, 11);
            }
        } else {
            return ParameterizedGenericMethodBinding.computeCompatibleMethod18(originalMethod, arguments, scope, invocationSite);
        }
        ParameterizedGenericMethodBinding methodSubstitute = environment.createParameterizedGenericMethod(originalMethod, substitutes);
        ParameterizedGenericMethodBinding substitution = methodSubstitute;
        int i = 0;
        int length = typeVariables.length;
        while (i < length) {
            TypeVariableBinding typeVariable = typeVariables[i];
            TypeBinding substitute = methodSubstitute.typeArguments[i];
            TypeBinding substituteForChecks = substitute instanceof TypeVariableBinding ? substitute : Scope.substitute((Substitution)new LingeringTypeVariableEliminator(typeVariables, null, scope), substitute);
            switch (typeVariable.boundCheck(substitution, substituteForChecks, scope, null)) {
                case MISMATCH: {
                    int argLength = arguments.length;
                    TypeBinding[] augmentedArguments = new TypeBinding[argLength + 2];
                    System.arraycopy(arguments, 0, augmentedArguments, 0, argLength);
                    augmentedArguments[argLength] = substitute;
                    augmentedArguments[argLength + 1] = typeVariable;
                    return new ProblemMethodBinding(methodSubstitute, originalMethod.selector, augmentedArguments, 10);
                }
                case UNCHECKED: {
                    methodSubstitute.tagBits |= 0x100L;
                    break;
                }
            }
            ++i;
        }
        if (invocationSite instanceof Invocation) {
            InferenceContext18.updateInnerDiamonds(methodSubstitute, ((Invocation)invocationSite).arguments());
        }
        return methodSubstitute;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MethodBinding computeCompatibleMethod18(MethodBinding originalMethod, TypeBinding[] arguments, Scope scope, InvocationSite invocationSite) {
        TypeBinding[] typeVariables = originalMethod.typeVariables;
        if (invocationSite.checkingPotentialCompatibility()) {
            return scope.environment().createParameterizedGenericMethod(originalMethod, typeVariables);
        }
        ParameterizedGenericMethodBinding methodSubstitute = null;
        InferenceContext18 infCtx18 = invocationSite.freshInferenceContext(scope);
        if (infCtx18 == null) {
            return originalMethod;
        }
        TypeBinding[] parameters = originalMethod.parameters;
        CompilerOptions compilerOptions = scope.compilerOptions();
        boolean invocationTypeInferred = false;
        boolean requireBoxing = false;
        boolean allArgumentsAreProper = true;
        TypeBinding[] argumentsCopy = new TypeBinding[arguments.length];
        int i = 0;
        int length = arguments.length;
        int parametersLength = parameters.length;
        while (i < length) {
            TypeBinding parameter = i < parametersLength ? parameters[i] : parameters[parametersLength - 1];
            TypeBinding argument = arguments[i];
            allArgumentsAreProper &= argument.isProperType(true);
            if (argument.isPrimitiveType() != parameter.isPrimitiveType()) {
                argumentsCopy[i] = scope.environment().computeBoxingType(argument);
                requireBoxing = true;
            } else {
                argumentsCopy[i] = argument;
            }
            ++i;
        }
        arguments = argumentsCopy;
        LookupEnvironment environment = scope.environment();
        InferenceContext18 previousContext = environment.currentInferenceContext;
        if (previousContext == null) {
            environment.currentInferenceContext = infCtx18;
        }
        try {
            BoundSet provisionalResult = null;
            BoundSet result = null;
            boolean isPolyExpression = invocationSite instanceof Expression && ((Expression)((Object)invocationSite)).isTrulyExpression() && ((Expression)((Object)invocationSite)).isPolyExpression(originalMethod);
            boolean isDiamond = isPolyExpression && originalMethod.isConstructor();
            boolean isInexactVarargsInference = false;
            if (arguments.length == parameters.length) {
                infCtx18.inferenceKind = requireBoxing ? 2 : 1;
                infCtx18.inferInvocationApplicability(originalMethod, arguments, isDiamond);
                result = infCtx18.solve(true);
                boolean bl = isInexactVarargsInference = result != null && originalMethod.isVarargs() && !allArgumentsAreProper;
            }
            if (result == null && originalMethod.isVarargs()) {
                infCtx18 = invocationSite.freshInferenceContext(scope);
                infCtx18.inferenceKind = 3;
                infCtx18.inferInvocationApplicability(originalMethod, arguments, isDiamond);
                result = infCtx18.solve(true);
            }
            if (result == null) {
                return null;
            }
            if (!infCtx18.isResolved(result)) return null;
            infCtx18.stepCompleted = 1;
            TypeBinding expectedType = invocationSite.invocationTargetType();
            boolean hasReturnProblem = false;
            if (expectedType != null || !invocationSite.getExpressionContext().definesTargetType() || !isPolyExpression) {
                provisionalResult = result;
                result = infCtx18.inferInvocationType(expectedType, invocationSite, originalMethod);
                invocationTypeInferred = infCtx18.stepCompleted == 3;
                if (hasReturnProblem |= result == null) {
                    result = provisionalResult;
                }
            }
            if (result == null) return null;
            TypeBinding[] solutions = infCtx18.getSolutions((TypeVariableBinding[])typeVariables, invocationSite, result);
            if (solutions == null) return null;
            methodSubstitute = scope.environment().createParameterizedGenericMethod(originalMethod, solutions, infCtx18.usesUncheckedConversion, hasReturnProblem, expectedType);
            if (invocationSite instanceof Invocation && allArgumentsAreProper && (expectedType == null || expectedType.isProperType(true))) {
                infCtx18.forwardResults(result, (Invocation)invocationSite, methodSubstitute, expectedType);
            }
            try {
                MethodBinding problemMethod;
                if (infCtx18.missingType != null && (expectedType == null || (expectedType.tagBits & 0x80L) == 0L)) {
                    ProblemMethodBinding problemMethod2 = new ProblemMethodBinding(originalMethod, originalMethod.selector, parameters, 32);
                    problemMethod2.missingType = infCtx18.missingType;
                    ProblemMethodBinding problemMethodBinding = problemMethod2;
                    return problemMethodBinding;
                }
                if (hasReturnProblem && (problemMethod = infCtx18.getReturnProblemMethodIfNeeded(expectedType, methodSubstitute)) instanceof ProblemMethodBinding) {
                    MethodBinding methodBinding = problemMethod;
                    return methodBinding;
                }
                if (invocationTypeInferred) {
                    if (compilerOptions.isAnnotationBasedNullAnalysisEnabled) {
                        NullAnnotationMatching.checkForContradictions(methodSubstitute, invocationSite, scope);
                    }
                    if ((problemMethod = methodSubstitute.boundCheck18(scope, arguments, invocationSite)) != null) {
                        MethodBinding methodBinding = problemMethod;
                        return methodBinding;
                    }
                } else {
                    methodSubstitute = new PolyParameterizedGenericMethodBinding(methodSubstitute);
                }
            }
            finally {
                infCtx18.setInexactVarargsInference(isInexactVarargsInference);
                if (!infCtx18.hasPrematureOverloadResolution()) {
                    if (invocationSite instanceof Invocation) {
                        ((Invocation)invocationSite).registerInferenceContext(methodSubstitute, infCtx18);
                    } else if (invocationSite instanceof ReferenceExpression) {
                        ((ReferenceExpression)invocationSite).registerInferenceContext(methodSubstitute, infCtx18);
                    }
                }
            }
            ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = methodSubstitute;
            return parameterizedGenericMethodBinding;
        }
        catch (InferenceFailureException e) {
            scope.problemReporter().genericInferenceError(e.getMessage(), invocationSite);
            return null;
        }
        finally {
            environment.currentInferenceContext = previousContext;
        }
    }

    MethodBinding boundCheck18(Scope scope, TypeBinding[] arguments, InvocationSite site) {
        ParameterizedGenericMethodBinding substitution = this;
        ParameterizedGenericMethodBinding methodSubstitute = this;
        TypeVariableBinding[] originalTypeVariables = this.originalMethod.typeVariables;
        int i = 0;
        int length = originalTypeVariables.length;
        while (i < length) {
            TypeVariableBinding typeVariable = originalTypeVariables[i];
            TypeBinding substitute = methodSubstitute.typeArguments[i];
            ASTNode location = site instanceof ASTNode ? (ASTNode)((Object)site) : null;
            switch (typeVariable.boundCheck(substitution, substitute, scope, location)) {
                case MISMATCH: {
                    int argLength = arguments.length;
                    TypeBinding[] augmentedArguments = new TypeBinding[argLength + 2];
                    System.arraycopy(arguments, 0, augmentedArguments, 0, argLength);
                    augmentedArguments[argLength] = substitute;
                    augmentedArguments[argLength + 1] = typeVariable;
                    return new ProblemMethodBinding(methodSubstitute, this.originalMethod.selector, augmentedArguments, 10);
                }
                case UNCHECKED: {
                    methodSubstitute.tagBits |= 0x100L;
                    break;
                }
            }
            ++i;
        }
        return null;
    }

    public ParameterizedGenericMethodBinding(MethodBinding originalMethod, RawTypeBinding rawType, LookupEnvironment environment) {
        TypeVariableBinding[] originalVariables = originalMethod.typeVariables;
        int length = originalVariables.length;
        TypeBinding[] rawArguments = new TypeBinding[length];
        int i = 0;
        while (i < length) {
            rawArguments[i] = environment.convertToRawType(originalVariables[i].erasure(), false);
            ++i;
        }
        this.isRaw = true;
        this.tagBits = originalMethod.tagBits;
        this.environment = environment;
        this.modifiers = originalMethod.modifiers;
        this.selector = originalMethod.selector;
        this.declaringClass = rawType == null ? originalMethod.declaringClass : rawType;
        this.typeVariables = Binding.NO_TYPE_VARIABLES;
        this.typeArguments = rawArguments;
        this.originalMethod = originalMethod;
        boolean ignoreRawTypeSubstitution = rawType == null || originalMethod.isStatic();
        this.parameters = Scope.substitute((Substitution)this, ignoreRawTypeSubstitution ? originalMethod.parameters : Scope.substitute((Substitution)rawType, originalMethod.parameters));
        this.thrownExceptions = Scope.substitute((Substitution)this, ignoreRawTypeSubstitution ? originalMethod.thrownExceptions : Scope.substitute((Substitution)rawType, originalMethod.thrownExceptions));
        if (this.thrownExceptions == null) {
            this.thrownExceptions = Binding.NO_EXCEPTIONS;
        }
        this.returnType = Scope.substitute((Substitution)this, ignoreRawTypeSubstitution ? originalMethod.returnType : Scope.substitute((Substitution)rawType, originalMethod.returnType));
        this.wasInferred = false;
        this.parameterFlowBits = originalMethod.parameterFlowBits;
        this.defaultNullness = originalMethod.defaultNullness;
    }

    public ParameterizedGenericMethodBinding(MethodBinding originalMethod, TypeBinding[] typeArguments, LookupEnvironment environment, boolean inferredWithUncheckConversion, boolean hasReturnProblem, TypeBinding targetType) {
        block15: {
            int i;
            this.environment = environment;
            this.inferredWithUncheckedConversion = inferredWithUncheckConversion;
            this.targetType = targetType;
            this.modifiers = originalMethod.modifiers;
            this.selector = originalMethod.selector;
            this.declaringClass = originalMethod.declaringClass;
            if (inferredWithUncheckConversion && originalMethod.isConstructor() && this.declaringClass.isParameterizedType()) {
                this.declaringClass = (ReferenceBinding)environment.convertToRawType(this.declaringClass.erasure(), false);
            }
            this.typeVariables = Binding.NO_TYPE_VARIABLES;
            this.typeArguments = typeArguments;
            this.isRaw = false;
            this.tagBits = originalMethod.tagBits;
            this.originalMethod = originalMethod;
            this.parameters = Scope.substitute((Substitution)this, originalMethod.parameters);
            if (inferredWithUncheckConversion) {
                this.returnType = this.getErasure18_5_2(originalMethod.returnType, environment);
                this.thrownExceptions = new ReferenceBinding[originalMethod.thrownExceptions.length];
                i = 0;
                while (i < originalMethod.thrownExceptions.length) {
                    this.thrownExceptions[i] = (ReferenceBinding)this.getErasure18_5_2(originalMethod.thrownExceptions[i], environment);
                    ++i;
                }
            } else {
                this.returnType = Scope.substitute((Substitution)this, originalMethod.returnType);
                this.thrownExceptions = Scope.substitute((Substitution)this, originalMethod.thrownExceptions);
            }
            if (this.thrownExceptions == null) {
                this.thrownExceptions = Binding.NO_EXCEPTIONS;
            }
            if ((this.tagBits & 0x80L) == 0L) {
                if ((this.returnType.tagBits & 0x80L) != 0L) {
                    this.tagBits |= 0x80L;
                } else {
                    i = 0;
                    int max = this.parameters.length;
                    while (i < max) {
                        if ((this.parameters[i].tagBits & 0x80L) != 0L) {
                            this.tagBits |= 0x80L;
                            break block15;
                        }
                        ++i;
                    }
                    i = 0;
                    max = this.thrownExceptions.length;
                    while (i < max) {
                        if ((this.thrownExceptions[i].tagBits & 0x80L) != 0L) {
                            this.tagBits |= 0x80L;
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        this.wasInferred = true;
        this.parameterFlowBits = originalMethod.parameterFlowBits;
        this.defaultNullness = originalMethod.defaultNullness;
        int len = this.parameters.length;
        int i = 0;
        while (i < len) {
            long nullBits;
            if (this.parameters[i] == TypeBinding.NULL && (nullBits = originalMethod.parameters[i].tagBits & 0x180000000000000L) == 0x100000000000000L) {
                if (this.parameterFlowBits == null) {
                    this.parameterFlowBits = new byte[len];
                }
                int n = i;
                this.parameterFlowBits[n] = (byte)(this.parameterFlowBits[n] | PARAM_NONNULL);
            }
            ++i;
        }
    }

    TypeBinding getErasure18_5_2(TypeBinding type, LookupEnvironment env) {
        type = Scope.substitute((Substitution)this, type);
        return env.convertToRawType(type.erasure(), true);
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.originalMethod.computeUniqueKey(false));
        buffer.append('%');
        buffer.append('<');
        if (!this.isRaw) {
            int length = this.typeArguments.length;
            int i = 0;
            while (i < length) {
                TypeBinding typeArgument = this.typeArguments[i];
                buffer.append(typeArgument.computeUniqueKey(false));
                ++i;
            }
        }
        buffer.append('>');
        int resultLength = buffer.length();
        char[] result = new char[resultLength];
        buffer.getChars(0, resultLength, result, 0);
        return result;
    }

    @Override
    public LookupEnvironment environment() {
        return this.environment;
    }

    @Override
    public boolean hasSubstitutedParameters() {
        if (this.wasInferred) {
            return this.originalMethod.hasSubstitutedParameters();
        }
        return super.hasSubstitutedParameters();
    }

    @Override
    public boolean hasSubstitutedReturnType() {
        if (this.inferredReturnType) {
            return this.originalMethod.hasSubstitutedReturnType();
        }
        return super.hasSubstitutedReturnType();
    }

    @Override
    public boolean isParameterizedGeneric() {
        return true;
    }

    @Override
    public boolean isRawSubstitution() {
        return this.isRaw;
    }

    @Override
    public TypeBinding substitute(TypeVariableBinding originalVariable) {
        TypeVariableBinding[] variables = this.originalMethod.typeVariables;
        int length = variables.length;
        if (originalVariable.rank < length && TypeBinding.equalsEquals(variables[originalVariable.rank], originalVariable)) {
            TypeBinding substitute = this.typeArguments[originalVariable.rank];
            return originalVariable.combineTypeAnnotations(substitute);
        }
        return originalVariable;
    }

    @Override
    public MethodBinding genericMethod() {
        if (this.isRaw) {
            return this;
        }
        return this.originalMethod;
    }

    private static class LingeringTypeVariableEliminator
    implements Substitution {
        private final TypeVariableBinding[] variables;
        private final TypeBinding[] substitutes;
        private final Scope scope;

        public LingeringTypeVariableEliminator(TypeVariableBinding[] variables, TypeBinding[] substitutes, Scope scope) {
            this.variables = variables;
            this.substitutes = substitutes;
            this.scope = scope;
        }

        @Override
        public TypeBinding substitute(TypeVariableBinding typeVariable) {
            if (typeVariable.rank >= this.variables.length || TypeBinding.notEquals(this.variables[typeVariable.rank], typeVariable)) {
                return typeVariable;
            }
            if (this.substitutes != null) {
                return Scope.substitute((Substitution)new LingeringTypeVariableEliminator(this.variables, null, this.scope), this.substitutes[typeVariable.rank]);
            }
            ReferenceBinding genericType = (ReferenceBinding)(typeVariable.declaringElement instanceof ReferenceBinding ? typeVariable.declaringElement : null);
            return this.scope.environment().createWildcard(genericType, typeVariable.rank, null, null, 0, typeVariable.getTypeAnnotations());
        }

        @Override
        public LookupEnvironment environment() {
            return this.scope.environment();
        }

        @Override
        public boolean isRawSubstitution() {
            return false;
        }
    }
}

