/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.platform.internal;

import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.model.ProjectEntity;
import com.katalon.platform.api.preference.ApplicationPreference;
import com.katalon.platform.api.preference.PluginPreference;
import com.katalon.platform.api.service.ApplicationManager;
import com.katalon.platform.api.service.PreferenceManager;
import com.katalon.platform.internal.preference.ApplicationPreferenceImp;
import com.katalon.platform.internal.preference.InternalPluginPreferenceImpl;
import com.katalon.platform.internal.preference.PluginPreferenceImpl;
import com.katalon.platform.internal.preference.ScopedPreferenceStore;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceManagerImpl
implements PreferenceManager {
    private Map<String, Map<String, PluginPreference>> pluginPreferences = new HashMap<String, Map<String, PluginPreference>>();
    private Map<String, ApplicationPreference> applicationPreferences = new HashMap<String, ApplicationPreference>();

    @Override
    public PluginPreference getPluginPreference(String projectId, String pluginId) throws ResourceException {
        ProjectEntity projectEntity = ApplicationManager.getInstance().getProjectManager().getCurrentProject();
        if (!projectId.equals(ApplicationManager.getInstance().getProjectManager().getCurrentProject().getId())) {
            throw new ResourceException(String.format("Project %s not found", projectId));
        }
        if (ApplicationManager.getInstance().getPluginManager().getPlugin(pluginId) == null) {
            throw new ResourceException(String.format("Plugin %s not found", pluginId));
        }
        if (this.pluginPreferences.containsKey(projectId)) {
            Map<String, PluginPreference> preferenceLookup = this.pluginPreferences.get(projectId);
            if (preferenceLookup.containsKey(pluginId)) {
                return preferenceLookup.get(pluginId);
            }
            PluginPreferenceImpl pluginPreference = new PluginPreferenceImpl(projectEntity, pluginId);
            preferenceLookup.put(pluginId, pluginPreference);
            return pluginPreference;
        }
        PluginPreferenceImpl pluginPreference = new PluginPreferenceImpl(projectEntity, pluginId);
        HashMap<String, PluginPreferenceImpl> preferenceLookup = new HashMap<String, PluginPreferenceImpl>();
        preferenceLookup.put(pluginId, pluginPreference);
        this.pluginPreferences.put(projectId, preferenceLookup);
        return pluginPreference;
    }

    @Override
    public ApplicationPreference getApplicationPreference(String pluginId) {
        if (this.applicationPreferences.containsKey(pluginId)) {
            return this.applicationPreferences.get(pluginId);
        }
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, pluginId);
        ApplicationPreferenceImp preference = new ApplicationPreferenceImp(pluginId, scopedPreferenceStore);
        this.applicationPreferences.put(pluginId, preference);
        return preference;
    }

    @Override
    public PluginPreference getInternalPluginPreference(String projectId, String internalPluginId) throws ResourceException {
        ProjectEntity projectEntity = ApplicationManager.getInstance().getProjectManager().getCurrentProject();
        if (!projectId.equals(ApplicationManager.getInstance().getProjectManager().getCurrentProject().getId())) {
            throw new ResourceException(String.format("Project %s not found", projectId));
        }
        if (ApplicationManager.getInstance().getPluginManager().getPlugin(internalPluginId) == null) {
            throw new ResourceException(String.format("Plugin %s not found", internalPluginId));
        }
        if (this.pluginPreferences.containsKey(projectId)) {
            Map<String, PluginPreference> preferenceLookup = this.pluginPreferences.get(projectId);
            if (preferenceLookup.containsKey(internalPluginId)) {
                return preferenceLookup.get(internalPluginId);
            }
            PluginPreferenceImpl pluginPreference = new PluginPreferenceImpl(projectEntity, internalPluginId);
            preferenceLookup.put(internalPluginId, pluginPreference);
            return pluginPreference;
        }
        InternalPluginPreferenceImpl pluginPreference = new InternalPluginPreferenceImpl(projectEntity, internalPluginId);
        HashMap<String, InternalPluginPreferenceImpl> preferenceLookup = new HashMap<String, InternalPluginPreferenceImpl>();
        preferenceLookup.put(internalPluginId, pluginPreference);
        this.pluginPreferences.put(projectId, preferenceLookup);
        return pluginPreference;
    }
}

