/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.util.CryptoUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.credentials.UserPasswordCredentials;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.swt.widgets.Display;

public class GitHandler {
    public static void storeGitInfo(String username, String password, boolean isSaveAuthentication) {
        UserProfile userProfile = UserProfileHelper.getCurrentProfile();
        if (isSaveAuthentication) {
            userProfile.setGitUsername(username);
            userProfile.setGitPersonalAccessToken(password);
        }
        userProfile.setSaveAuthentication(isSaveAuthentication);
        UserProfileHelper.saveProfile((UserProfile)userProfile);
    }

    public static UserPasswordCredentials getGitCredentialsFromUserProfile() {
        UserProfile userProfile = UserProfileHelper.getCurrentProfile();
        String username = userProfile.getGitUsername();
        String encryptedPassword = StringUtils.defaultString((String)userProfile.getGitPersonalAccessToken(), (String)"");
        CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)encryptedPassword);
        String personalAccessToken = "";
        try {
            personalAccessToken = CryptoUtil.decode((CryptoUtil.CrytoInfo)cryptoInfo);
        }
        catch (IOException | GeneralSecurityException exception) {}
        return new UserPasswordCredentials(username, personalAccessToken);
    }

    public static void setGitPermission(UserPasswordCredentials credentials, String repoUrl) {
        try {
            SecureStoreUtils.storeCredentials((UserPasswordCredentials)credentials, (URIish)new URIish(repoUrl));
        }
        catch (URISyntaxException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public static UserPasswordCredentials getGitPermissionFromStore(String repoUrl) {
        try {
            return SecureStoreUtils.getCredentials((URIish)new URIish(repoUrl));
        }
        catch (URISyntaxException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    public static ProjectEntity cloneGitProject(String repoUrl, String branchName, File directory, final StringBuilder message) {
        URIish uri;
        UserPasswordCredentials newCredentials;
        UserPasswordCredentials userCredentials = GitHandler.getGitCredentialsFromUserProfile();
        if ((userCredentials.getUser() == null || StringUtils.isBlank((String)userCredentials.getPassword())) && (newCredentials = GitHandler.getGitPermissionFromStore(repoUrl)) != null) {
            userCredentials = newCredentials;
        }
        UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(" ", " ");
        if (userCredentials != null) {
            credentials = new UsernamePasswordCredentialsProvider(StringUtils.defaultIfBlank((String)userCredentials.getUser(), (String)" "), StringUtils.defaultIfBlank((String)userCredentials.getPassword(), (String)" "));
        }
        try {
            uri = new URIish(repoUrl);
            uri = uri.setUser(null);
        }
        catch (URISyntaxException error) {
            message.append(error.getInput());
            LoggerSingleton.logError((Throwable)error);
            return null;
        }
        final CloneOperation cloneOperation = new CloneOperation(uri, true, null, directory, branchName, "origin", GitSettings.getRemoteConnectionTimeout());
        cloneOperation.setCredentialsProvider((CredentialsProvider)credentials);
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        cloneOperation.run(monitor);
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        message.append(e.getCause().getMessage());
                        LoggerSingleton.logError((Throwable)e);
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException error) {
            LoggerSingleton.logError((Throwable)error);
        }
        File projectFile = ProjectController.getInstance().getProjectFile(directory.getPath());
        if (projectFile == null) {
            return null;
        }
        try {
            return ProjectController.getInstance().getProject(projectFile.getPath());
        }
        catch (ControllerException controllerException) {
            return null;
        }
    }
}

