/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.dialog.SwitchVersionsOrEditionsWarningDialog;
import com.kms.katalon.composer.project.settings.ProjectSettingStore;
import com.kms.katalon.composer.project.util.ProjectUtil;
import com.kms.katalon.core.model.KatalonEdition;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.widgets.Shell;

public class SwitchingEditionsOrVersionsHandler {
    private Shell shell;
    private String projectLocation;
    private String projectFolderLocation;

    public SwitchingEditionsOrVersionsHandler(Shell shell, String projectLocation) {
        this.shell = shell;
        this.projectLocation = projectLocation;
    }

    public boolean isOpenProjectAnyway() {
        ProjectSettingStore store;
        block4: {
            try {
                File projectFile = new File(this.projectLocation);
                this.projectFolderLocation = projectFile.getParent();
                store = ProjectSettingStore.getStore(this.projectFolderLocation);
                if (!store.isProjectDifferentVersionsAndEdtionsWarningShown()) break block4;
                return true;
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                return true;
            }
        }
        ProjectEntity project = (ProjectEntity)EntityService.getInstance().getEntityByPath(this.projectLocation);
        if (ApplicationEdition.get() == KatalonEdition.ENTERPRISE ? !ProjectUtil.isCompatibleVersion(project.getModifiedVersion()) : ApplicationEdition.get() == KatalonEdition.FREE && (project.getModifiedEdition() == KatalonEdition.ENTERPRISE || !ProjectUtil.isCompatibleVersion(project.getModifiedVersion()))) {
            return this.showWarningDialog(store);
        }
        return true;
    }

    private boolean showWarningDialog(ProjectSettingStore store) {
        boolean isContinueAnywayButtonPressed;
        SwitchVersionsOrEditionsWarningDialog dialog = new SwitchVersionsOrEditionsWarningDialog(this.shell);
        int returnedCode = dialog.open();
        boolean bl = isContinueAnywayButtonPressed = returnedCode == 0;
        if (isContinueAnywayButtonPressed && dialog.getToggleState()) {
            try {
                store.setProjectDifferentVersionsAndEdtionsWarningShown(true);
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return isContinueAnywayButtonPressed;
    }
}

