/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.menu;

import com.kms.katalon.application.preference.ProjectSettingPreference;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.constants.ImageConstants;
import com.kms.katalon.composer.project.menu.SampleProjectParameterizedCommandBuilder;
import com.kms.katalon.composer.project.sample.SampleLocalProject;
import com.kms.katalon.composer.project.sample.SampleProjectType;
import com.kms.katalon.composer.project.sample.SampleRemoteProject;
import com.kms.katalon.composer.project.sample.SampleRemoteProjectProvider;
import com.kms.katalon.composer.project.template.SampleProjectProvider;
import com.kms.katalon.constants.helper.ConstantsHelper;
import com.kms.katalon.entity.project.ProjectEntity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SampleProjectMenuContribution
implements EventHandler {
    private static List<ProjectEntity> recentProjects = new ArrayList<ProjectEntity>();
    private static final List<String> SAMPLE_LOCAL_PROJECTS = new ArrayList<String>();

    static {
        SAMPLE_LOCAL_PROJECTS.add(SampleProjectProvider.SAMPLE_WEB_UI);
        SAMPLE_LOCAL_PROJECTS.add(SampleProjectProvider.SAMPLE_MOBILE);
        SAMPLE_LOCAL_PROJECTS.add(SampleProjectProvider.SAMPLE_WEB_SERVICE);
    }

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        try {
            menuItems.add((MMenuElement)this.newMenuSeparator());
            List<SampleRemoteProject> remoteProjects = SampleRemoteProjectProvider.getCachedProjects();
            SampleProjectParameterizedCommandBuilder commandBuilder = new SampleProjectParameterizedCommandBuilder();
            if (remoteProjects.size() <= 0) {
                List<SampleLocalProject> localProjects = SampleProjectProvider.getInstance().getSampleProjects();
                for (SampleLocalProject project : localProjects) {
                    MHandledMenuItem newLocalProjectMenuItem = MMenuFactory.INSTANCE.createHandledMenuItem();
                    newLocalProjectMenuItem.setLabel(project.getName());
                    newLocalProjectMenuItem.setContributorURI(ConstantsHelper.getApplicationURI());
                    newLocalProjectMenuItem.setCommand(this.newTempCommand());
                    newLocalProjectMenuItem.setTooltip("");
                    newLocalProjectMenuItem.setIconURI(this.getIconURIForProject(project.getType()));
                    newLocalProjectMenuItem.setWbCommand(commandBuilder.createSampleLocalProjectParameterizedCommand(project));
                    menuItems.add((MMenuElement)newLocalProjectMenuItem);
                }
            } else {
                for (SampleRemoteProject project : remoteProjects) {
                    MHandledMenuItem remoteProjectMenuItem = MMenuFactory.INSTANCE.createHandledMenuItem();
                    remoteProjectMenuItem.setLabel(project.getName());
                    remoteProjectMenuItem.setContributorURI(ConstantsHelper.getApplicationURI());
                    remoteProjectMenuItem.setCommand(this.newTempCommand());
                    remoteProjectMenuItem.setTooltip("");
                    remoteProjectMenuItem.setIconURI(this.getIconURIForProject(project.getType()));
                    remoteProjectMenuItem.setWbCommand(commandBuilder.createRemoteProjectParameterizedCommand(project));
                    menuItems.add((MMenuElement)remoteProjectMenuItem);
                }
            }
            if (!recentProjects.isEmpty()) {
                menuItems.add((MMenuElement)this.newMenuSeparator());
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private MCommand newTempCommand() {
        MCommand command = MCommandsFactory.INSTANCE.createCommand();
        command.setCommandName("Temp");
        return command;
    }

    public String getIconURIForProject(SampleProjectType projectType) {
        switch (projectType) {
            case MOBILE: {
                return ImageConstants.URL_SAMPLE_MOBILE_16.toString();
            }
            case WS: {
                return ImageConstants.URL_SAMPLE_WS_16.toString();
            }
        }
        return ImageConstants.URL_SAMPLE_WEB_16.toString();
    }

    private MMenuSeparator newMenuSeparator() {
        return MMenuFactory.INSTANCE.createMenuSeparator();
    }

    public void handleEvent(Event event) {
        try {
            recentProjects.clear();
            recentProjects = new ProjectSettingPreference().getRecentProjects();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

