/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.controls;

import com.kms.katalon.composer.components.controls.WebviewComponent;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.core.event.EventEmitter;
import com.kms.katalon.core.util.internal.JsonUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

public class FastTreeView<ItemType>
extends WebviewComponent {
    private final Class<ItemType> itemClass;
    protected List<ItemType> pendingItems = Collections.synchronizedList(new ArrayList());
    private boolean dataLoaded = false;
    private final Object dataLoadedLock = new Object();

    public FastTreeView(Composite parent, Class<ItemType> itemClass) {
        this(parent, itemClass, 0);
    }

    public FastTreeView(Composite parent, Class<ItemType> itemClass, int style) {
        super(parent, style);
        this.itemClass = itemClass;
    }

    @Override
    protected void init() {
        super.init();
        this.dataLoaded = false;
    }

    @Override
    protected void handleBrowserLoaded() {
        super.handleBrowserLoaded();
        if (this.isBrowserLoaded()) {
            this.flushPendingItems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushPendingItems() {
        Object[] itemsToSet = null;
        List<ItemType> list = this.pendingItems;
        synchronized (list) {
            if (!this.pendingItems.isEmpty()) {
                itemsToSet = this.pendingItems.toArray((Object[])Array.newInstance(this.itemClass, this.pendingItems.size()));
            }
        }
        if (itemsToSet != null) {
            this.setItems(itemsToSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectPendingItems(ItemType ... items) {
        List<ItemType> list = this.pendingItems;
        synchronized (list) {
            this.pendingItems.addAll(Arrays.asList(items));
        }
    }

    public void setItems(ItemType ... items) {
        if (!this.isBrowserLoaded()) {
            this.collectPendingItems(items);
            return;
        }
        this.executeControllerMethod("setItems", items);
        this.setDataLoaded(true);
    }

    public void appendItems(ItemType ... items) {
        if (!this.isDataLoaded()) {
            this.collectPendingItems(items);
            return;
        }
        this.executeControllerMethod("appendItems", items);
    }

    public void setScrollLockPosition(ScrollLockPosition position) {
        this.executeControllerMethod("setScrollLockPosition", (Object)position);
    }

    public void scrollToTop() {
        this.setScrollLockPosition(ScrollLockPosition.TOP);
    }

    public void scrollToBottom() {
        this.setScrollLockPosition(ScrollLockPosition.BOTTOM);
    }

    public void reset() {
        this.executeControllerMethod("reset");
    }

    public void collapseAll() {
        this.executeControllerMethod("collapseAll");
    }

    public void expandAll() {
        this.executeControllerMethod("expandAll");
    }

    public ItemType getSelectedItem() {
        return null;
    }

    public EventEmitter.EventSubscriber onItemSelected(EventEmitter.CustomEventListener<ItemType> listener) {
        return this.emitter.on((Enum)FastTreeViewEvent.ITEM_SELECTED, rawItem -> listener.call(JsonUtil.fromJson((String)((String)rawItem), this.itemClass)));
    }

    public void setFilterQuery(Object query) {
        this.executeControllerMethod("setFilterQuery", query);
    }

    public void toggleFilterQuery(boolean enabled) {
        this.executeControllerMethod("toggleFilterQuery", enabled);
    }

    public void goToNextFilteredNode() {
        this.executeControllerMethod("gotoNextFilteredNode");
    }

    public void goToPrevFilteredNode() {
        this.executeControllerMethod("gotoPrevFilteredNode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDataLoaded() {
        Object object = this.dataLoadedLock;
        synchronized (object) {
            return this.dataLoaded;
        }
    }

    private synchronized void setDataLoaded(boolean dataLoaded) {
        this.dataLoaded = dataLoaded;
        LoggerSingleton.logInfo("FastTreeView: dataLoaded: " + dataLoaded);
    }

    public static enum FastTreeViewEvent {
        ITEM_SELECTED;

    }

    public static enum ScrollLockPosition {
        TOP,
        BOTTOM;

    }
}

