/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTPRawSender;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SendSSRCInfo;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.RTPPacket;
import com.sun.media.rtp.util.UDPPacketSender;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.media.Buffer;

public class RTPTransmitter {
    RTPRawSender sender;
    SSRCCache cache;

    public RTPTransmitter(SSRCCache cache) {
        this.cache = cache;
    }

    public RTPTransmitter(SSRCCache cache, RTPRawSender sender) {
        this(cache);
        this.setSender(sender);
    }

    public RTPTransmitter(SSRCCache cache, int port, String address) throws UnknownHostException, IOException {
        this(cache, new RTPRawSender(port, address));
    }

    public RTPTransmitter(SSRCCache cache, int port, String address, UDPPacketSender sender) throws UnknownHostException, IOException {
        this(cache, new RTPRawSender(port, address, sender));
    }

    public void setSender(RTPRawSender s2) {
        this.sender = s2;
    }

    public RTPRawSender getSender() {
        return this.sender;
    }

    public void close() {
        if (this.sender != null) {
            this.sender.closeConsumer();
        }
    }

    protected void transmit(RTPPacket p) {
        try {
            this.sender.sendTo(p);
        }
        catch (IOException e2) {
            ++this.cache.sm.transstats.transmit_failed;
        }
    }

    public void TransmitPacket(Buffer b2, SendSSRCInfo info) {
        info.rtptime = info.getTimeStamp(b2);
        info.systime = b2.getHeader() instanceof Long ? (Long)b2.getHeader() : System.currentTimeMillis();
        RTPPacket p = this.MakeRTPPacket(b2, info);
        if (p == null) {
            return;
        }
        this.transmit(p);
        ++info.stats.total_pdu;
        info.stats.total_bytes += b2.getLength();
        ++this.cache.sm.transstats.rtp_sent;
        this.cache.sm.transstats.bytes_sent += b2.getLength();
    }

    protected RTPPacket MakeRTPPacket(Buffer b2, SendSSRCInfo info) {
        byte[] data = (byte[])b2.getData();
        if (data == null) {
            return null;
        }
        Packet p = new Packet();
        p.data = data;
        p.offset = 0;
        p.length = b2.getLength();
        p.received = false;
        RTPPacket rtp = new RTPPacket(p);
        rtp.marker = (b2.getFlags() & 0x800) != 0 ? 1 : 0;
        info.packetsize += b2.getLength();
        rtp.payloadType = info.payloadType;
        rtp.seqnum = (int)info.getSequenceNumber(b2);
        rtp.timestamp = info.rtptime;
        rtp.ssrc = info.ssrc;
        rtp.payloadoffset = b2.getOffset();
        rtp.payloadlength = b2.getLength();
        info.bytesreceived += b2.getLength();
        ++info.maxseq;
        info.lasttimestamp = rtp.timestamp;
        return rtp;
    }
}

