/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.visual;

import com.sun.awt.AWTUtilities;
import edu.umd.cs.piccolo.PCanvas;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JWindow;
import javax.swing.Timer;
import org.sikuli.api.visual.ScreenDisplayable;

public class ScreenOverlayWindow
extends JWindow
implements ScreenDisplayable {
    private final PCanvas canvas = new PCanvas();

    public ScreenOverlayWindow() {
        this.canvas.setBackground(null);
        this.add(this.canvas);
        this.getContentPane().setBackground(null);
        AWTUtilities.setWindowOpaque((Window)this, (boolean)false);
        this.setAlwaysOnTop(true);
    }

    public PCanvas getCanvas() {
        return this.canvas;
    }

    public void show(int duration) {
        this.setVisible(true);
        this.autoClose(duration);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void autoClose(int time) {
        Timer timer = new Timer(time, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ScreenOverlayWindow.this.setVisible(false);
                ScreenOverlayWindow.this.dispose();
            }
        });
        timer.start();
    }

    @Override
    public void displayOnScreen() {
        this.setVisible(true);
    }

    @Override
    public void hideFromScreen() {
        this.setVisible(false);
        this.dispose();
    }
}

