/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.sikuli.core.cv.VisionUtils;
import org.sikuli.core.draw.BlobPainter;
import org.sikuli.core.draw.PiccoloImageRenderer;
import org.sikuli.core.logging.ImageExplainer;
import org.sikuli.core.search.ScoredItem;

public class DiffFinder {
    private static final int threshold = 50;

    opencv_core.IplImage cloneWithoutAlphaChannel(opencv_core.IplImage bgra) {
        opencv_core.IplImage bgr = opencv_core.IplImage.create(bgra.width(), bgra.height(), 8, 3);
        opencv_core.IplImage alpha = opencv_core.IplImage.create(bgra.width(), bgra.height(), 8, 1);
        opencv_core.CvArr[] in = new opencv_core.IplImage[]{bgra};
        opencv_core.CvArr[] out = new opencv_core.IplImage[]{bgr, alpha};
        int[] from_to = new int[]{0, 3, 1, 0, 2, 1, 3, 2};
        opencv_core.cvMixChannels(in, 1, out, 2, from_to, 4);
        return bgr;
    }

    public List<ScoredItem<Rectangle>> diff(BufferedImage beforeImage, BufferedImage afterImage) {
        ImageExplainer logger = ImageExplainer.getExplainer(this.getClass());
        opencv_core.IplImage before = opencv_core.IplImage.createFrom(beforeImage);
        opencv_core.IplImage after = opencv_core.IplImage.createFrom(afterImage);
        if (after.nChannels() == 4) {
            after = this.cloneWithoutAlphaChannel(after);
        }
        if (before.nChannels() == 4) {
            before = this.cloneWithoutAlphaChannel(before);
        }
        logger.step(beforeImage, (Object)"before");
        logger.step(afterImage, (Object)"after");
        opencv_core.IplImage diff = opencv_core.IplImage.createCompatible(before);
        opencv_core.cvAbsDiff(before, after, diff);
        logger.step(diff, (Object)"diff (color)");
        opencv_core.IplImage diffg = opencv_core.IplImage.create(opencv_core.cvGetSize(before), 8, 1);
        opencv_imgproc.cvCvtColor(diff, diffg, 7);
        logger.step(diffg, (Object)"diff (gray)");
        opencv_imgproc.cvThreshold(diffg, diffg, 50.0, 255.0, 0);
        logger.step(diffg, (Object)"thresholded by 50");
        List<opencv_core.CvRect> blobs = VisionUtils.detectBlobs(diffg);
        BufferedImage painted = new BlobPainter(diffg.getBufferedImage(), blobs).render();
        logger.step(painted, (Object)"detected components");
        ArrayList<opencv_core.CvRect> filtered_blobs = new ArrayList<opencv_core.CvRect>();
        for (opencv_core.CvRect cvRect : blobs) {
            if (cvRect.width() <= 5 || cvRect.height() <= 5) continue;
            filtered_blobs.add(cvRect);
        }
        painted = new BlobPainter(diffg.getBufferedImage(), blobs).render();
        logger.step(painted, (Object)"detected components (after filtering out small blobs)");
        final ArrayList<ScoredItem<Rectangle>> returned_list = new ArrayList<ScoredItem<Rectangle>>();
        for (opencv_core.CvRect b2 : filtered_blobs) {
            Rectangle r = new Rectangle(b2.x(), b2.y(), b2.width(), b2.height());
            opencv_core.cvSetImageROI(diffg, b2);
            int numPixels = opencv_core.cvCountNonZero(diffg);
            opencv_core.cvResetImageROI(diffg);
            float score = (float)(1.0 * (double)numPixels / (double)(b2.width() * b2.height()));
            ScoredItem<Rectangle> s2 = new ScoredItem<Rectangle>(r, score);
            returned_list.add(s2);
        }
        PiccoloImageRenderer piccoloImageRenderer = new PiccoloImageRenderer(diffg.getBufferedImage()){

            @Override
            protected void addContent(PLayer layer) {
                for (ScoredItem s2 : returned_list) {
                    Rectangle r = (Rectangle)s2.getItem();
                    PPath l2 = PPath.createRectangle(r.x, r.y, r.width, r.height);
                    l2.setStrokePaint(Color.red.darker());
                    l2.setPaint(null);
                    layer.addChild(l2);
                    PText t = new PText(String.format("%3f", s2.getScore()));
                    t.setTextPaint(Color.yellow);
                    t.setOffset(r.x, r.y);
                    t.setScale(1.2);
                    layer.addChild(t);
                }
            }
        };
        logger.step(piccoloImageRenderer, (Object)"results with scores");
        return returned_list;
    }
}

