/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.math.BigInteger;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Numbers;
import org.assertj.core.util.VisibleForTesting;

public class BigIntegers
extends Numbers<BigInteger> {
    private static final BigIntegers INSTANCE = new BigIntegers();

    public static BigIntegers instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    BigIntegers() {
    }

    public BigIntegers(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected BigInteger zero() {
        return BigInteger.ZERO;
    }

    @Override
    protected BigInteger one() {
        return BigInteger.ONE;
    }

    @Override
    protected BigInteger absDiff(BigInteger actual, BigInteger other) {
        return actual.subtract(other).abs();
    }

    @Override
    protected boolean isGreaterThan(BigInteger value, BigInteger other) {
        return value.subtract(other).compareTo(this.zero()) > 0;
    }
}

