/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.kobiton.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.integration.kobiton.entity.KobitonApiKey;
import com.kms.katalon.integration.kobiton.entity.KobitonApplication;
import com.kms.katalon.integration.kobiton.entity.KobitonApplications;
import com.kms.katalon.integration.kobiton.entity.KobitonDevice;
import com.kms.katalon.integration.kobiton.entity.KobitonJsonDeserializer;
import com.kms.katalon.integration.kobiton.entity.KobitonLoginInfo;
import com.kms.katalon.integration.kobiton.exceptions.KobitonApiException;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.eclipse.service.EclipseNetworkPreferences;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URIBuilder;

public class KobitonApiProvider {
    private static final String HEADER_VALUE_AUTHORIZATION_PREFIX = "Basic ";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String LOGIN_PARAM_PW = "password";
    private static final String LOGIN_PARAM_EMAIL_OR_USERNAME = "emailOrUsername";
    private static final String DATE_FORMAT_ISO_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    private static HttpOptions buildHttpOptions(String base64Token) {
        INetworkPreferences networkPreferences = EclipseNetworkPreferences.getInstance();
        ProxyConfig proxyConfig = networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
        if (Objects.nonNull(base64Token)) {
            headers.put(HEADER_AUTHORIZATION, (CallSite)((Object)(HEADER_VALUE_AUTHORIZATION_PREFIX + base64Token)));
        }
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        return httpOptions;
    }

    public static KobitonLoginInfo login(String serverUrl, String username, String password) throws KobitonApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/v1/users/login").build();
            JsonObject jsonObject = new JsonObject();
            jsonObject.add(LOGIN_PARAM_EMAIL_OR_USERNAME, (JsonElement)new JsonPrimitive(username));
            jsonObject.add(LOGIN_PARAM_PW, (JsonElement)new JsonPrimitive(password));
            HttpResponse response = httpClient.jsonPost(uri, jsonObject.toString(), KobitonApiProvider.buildHttpOptions(null));
            String responseString = response.getBody();
            KobitonApiProvider.checkForApiError(responseString);
            Gson gson = new GsonBuilder().setDateFormat(DATE_FORMAT_ISO_8601).create();
            return (KobitonLoginInfo)gson.fromJson(responseString, KobitonLoginInfo.class);
        }
        catch (Exception ex) {
            throw KobitonApiException.wrap(ex);
        }
    }

    public static boolean testConnection(String serverUrl, String username, String apiKey) throws KobitonApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/v1/apps").build();
            HttpResponse response = httpClient.get(uri, KobitonApiProvider.buildHttpOptions(KobitonApiProvider.buildToken(username, apiKey)));
            String responseString = response.getBody();
            KobitonApiProvider.checkForApiError(responseString);
            if (response.getStatusCode() != 200) {
                throw new KobitonApiException(responseString);
            }
            List<KobitonApplication> apps = ((KobitonApplications)new Gson().fromJson(responseString, KobitonApplications.class)).getApps();
            return apps != null;
        }
        catch (Exception ex) {
            throw KobitonApiException.wrap(ex);
        }
    }

    public static List<KobitonApiKey> getApiKeyList(String serverUrl, String token) throws KobitonApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/v1/users/keys").build();
            HttpResponse response = httpClient.get(uri, KobitonApiProvider.buildHttpOptions(token));
            String responseString = response.getBody();
            KobitonApiProvider.checkForApiError(responseString);
            return (List)new Gson().fromJson(responseString, new TypeToken<List<KobitonApiKey>>(){}.getType());
        }
        catch (Exception ex) {
            throw KobitonApiException.wrap(ex);
        }
    }

    public static List<KobitonDevice> getKobitonFavoriteDevices(String serverUrl, String token) throws KobitonApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/v1/devices").build();
            HttpResponse response = httpClient.get(uri, KobitonApiProvider.buildHttpOptions(token));
            String responseString = response.getBody();
            KobitonApiProvider.checkForApiError(responseString);
            Map allDevices = (Map)new GsonBuilder().registerTypeAdapter(KobitonDevice.class, (Object)new KobitonJsonDeserializer()).create().fromJson(responseString, new TypeToken<Map<String, List<KobitonDevice>>>(){}.getType());
            List onlineAndFavouriteDevices = allDevices.getOrDefault("favoriteDevices", Collections.emptyList()).stream().filter(d -> !d.isHidden() && d.isOnline() && d.isFavorite()).collect(Collectors.toList());
            LinkedHashSet<KobitonDevice> filteredDuplicatedDevices = new LinkedHashSet<KobitonDevice>();
            for (KobitonDevice device : onlineAndFavouriteDevices) {
                filteredDuplicatedDevices.add(device);
            }
            return new ArrayList<KobitonDevice>(filteredDuplicatedDevices);
        }
        catch (Exception ex) {
            throw KobitonApiException.wrap(ex);
        }
    }

    public static List<KobitonApplication> getKobitonApplications(String serverUrl, String token) throws KobitonApiException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/v1/apps").build();
            HttpResponse response = httpClient.get(uri, KobitonApiProvider.buildHttpOptions(token));
            String responseString = response.getBody();
            KobitonApiProvider.checkForApiError(responseString);
            return ((KobitonApplications)new Gson().fromJson(responseString, KobitonApplications.class)).getApps();
        }
        catch (Exception ex) {
            throw KobitonApiException.wrap(ex);
        }
    }

    public static String buildToken(String username, String apiKey) {
        return Base64.basicEncode((String)username, (String)apiKey);
    }

    private static void checkForApiError(String responseString) throws KobitonApiException {
        try {
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
            KobitonApiException apiException = (KobitonApiException)gson.fromJson(responseString, KobitonApiException.class);
            if (apiException.isError()) {
                throw apiException;
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            return;
        }
    }
}

