/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.components;

import com.kms.katalon.composer.components.controls.HelpCompositeForDialog;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.explorer.parts.ExplorerPart;
import com.kms.katalon.composer.mobile.objectspy.actions.IMobileAction;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileAction;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileActionMapping;
import com.kms.katalon.composer.mobile.objectspy.components.KobitonAppComposite;
import com.kms.katalon.composer.mobile.objectspy.components.MobileLocalAppComposite;
import com.kms.katalon.composer.mobile.objectspy.components.TestCloudConfigurationsComposite;
import com.kms.katalon.composer.mobile.objectspy.composites.MobileCapturedObjectsComposite;
import com.kms.katalon.composer.mobile.objectspy.composites.MobileConfigurationsComposite;
import com.kms.katalon.composer.mobile.objectspy.composites.MobileElementPropertiesComposite;
import com.kms.katalon.composer.mobile.objectspy.composites.MobileHighlightComposite;
import com.kms.katalon.composer.mobile.objectspy.dialog.AddElementToObjectRepositoryDialogV2;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumMonitorDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumStreamHandler;
import com.kms.katalon.composer.mobile.objectspy.dialog.ErrorStartMobileApplicationHaveTroubleshootDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileDeviceView;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileElementInspectorDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileInspectorController;
import com.kms.katalon.composer.mobile.objectspy.element.CapturedMobileElementConverterV2;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.TreeMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.composer.mobile.objectspy.interfaces.IMobileInspectorController;
import com.kms.katalon.composer.mobile.objectspy.interfaces.MobileAppComposite;
import com.kms.katalon.composer.mobile.objectspy.preferences.MobileObjectSpyPreferencesHelper;
import com.kms.katalon.composer.mobile.objectspy.util.ElementSelectionHelper;
import com.kms.katalon.composer.mobile.objectspy.util.MobileElementHelper;
import com.kms.katalon.composer.mobile.recorder.components.MobileActionButtonWrapper;
import com.kms.katalon.composer.mobile.recorder.components.RecordActionResult;
import com.kms.katalon.composer.mobile.recorder.composites.ErrorDialogWithLink;
import com.kms.katalon.composer.mobile.recorder.composites.MobileAllObjectsComposite;
import com.kms.katalon.composer.mobile.recorder.composites.MobileRecordedActionsComposite;
import com.kms.katalon.composer.mobile.recorder.constants.MobileRecoderMessagesConstants;
import com.kms.katalon.composer.mobile.recorder.constants.MobileRecorderImageConstants;
import com.kms.katalon.composer.mobile.recorder.exceptions.MobileRecordException;
import com.kms.katalon.composer.mobile.recorder.handlers.RecordActionPerformHandler;
import com.kms.katalon.composer.mobile.recorder.interfaces.IMobileObjectRecordDialog;
import com.kms.katalon.composer.mobile.recorder.interfaces.IRecordActionPerformHandler;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.integration.kobiton.entity.KobitonDevice;
import com.kms.katalon.testcloud.core.model.TestCloudExecutionSessionResponse;
import com.kms.katalon.testcloud.core.model.TestCloudMobileDevice;
import com.kms.katalon.tracking.model.MobileDeviceOption;
import com.kms.katalon.tracking.service.Trackings;
import io.appium.java_client.AppiumDriver;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

@Creatable
public class MobileRecorderDialog
extends AbstractDialog
implements IMobileObjectRecordDialog {
    private MobileRecordedActionsComposite recordedActionsComposite;
    private MobileCapturedObjectsComposite capturedObjectsComposite;
    private MobileHighlightComposite highlightElementComposite;
    private MobileElementPropertiesComposite propertiesComposite;
    private MobileAllObjectsComposite allObjectsComposite;
    @Inject
    private MobileAppComposite mobileComposite;
    @Inject
    private IRecordActionPerformHandler actionPerformHanlder;
    private FolderTreeEntity targetFolderEntity;
    private ToolItem btnStart;
    private ToolItem btnCapture;
    private ToolItem btnStop;
    private MobileDeviceView deviceView;
    private TreeMobileElement appRootElement;
    private TreeMobileElement focusingElement;
    private MobileInspectorController inspectorController = new MobileInspectorController();
    private MobileObjectSpyPreferencesHelper preferencesHelper = new MobileObjectSpyPreferencesHelper();
    private Composite container;
    private RecordActionResult recordActionResult;
    private boolean okPressed = false;

    @Override
    public RecordActionResult getRecordActionResult() {
        return this.recordActionResult;
    }

    @Inject
    public MobileRecorderDialog() {
        super(Display.getCurrent().getActiveShell());
    }

    public MobileRecorderDialog(Shell parentShell, MobileAppComposite appComposite) {
        super(parentShell);
        this.mobileComposite = appComposite;
        this.actionPerformHanlder = new RecordActionPerformHandler(this);
    }

    public void create() {
        super.create();
        this.validateToEnableStartButton();
        this.updateActionButtonsVisibility(null);
        this.getButton(0).setEnabled(false);
    }

    protected Point getInitialSize() {
        return new Point(1100, 800);
    }

    @Override
    public Shell getShell() {
        return super.getShell();
    }

    protected int getShellStyle() {
        return 3312;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(MobileRecoderMessagesConstants.DLG_TITLE_MOBILE_RECORDER);
    }

    public boolean close() {
        this.stopObjectInspectorAction();
        try {
            this.preferencesHelper.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        if (this.okPressed) {
            Trackings.trackCloseMobileRecordByOk((String)this.getDeviceTypeString(), (int)this.getRecordedActions().size());
        } else {
            Trackings.trackCloseMobileRecordByCancel((String)this.getDeviceTypeString());
        }
        boolean result = super.close();
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle displayBounds = this.getShell().getMonitor().getBounds();
        return new Point(this.calculateDialogStartX(displayBounds, initialSize), this.calculateDialogStartY(displayBounds, initialSize));
    }

    private int calculateDialogStartX(Rectangle displayBounds, Point dialogSize) {
        int dialogsWidth = dialogSize.x + 400;
        int startX = (displayBounds.width - dialogsWidth) / 2 + displayBounds.x;
        return Math.max(startX, 0);
    }

    private int calculateDialogStartY(Rectangle displayBounds, Point dialogSize) {
        int startY = displayBounds.height - dialogSize.y;
        return Math.max(startY, 0) / 2;
    }

    protected Control createDialogContainer(Composite parent) {
        this.container = (Composite)ComponentBuilder.gridContainer((Composite)parent).margin(0).background(ColorUtil.getCompositeBackgroundColorForDialog()).build();
        SashForm sashForm = this.createMainSashForm(this.container);
        this.populateSashForm(sashForm);
        sashForm.setWeights(new int[]{4, 4, 4});
        return this.container;
    }

    protected Control createButtonBar(Composite parent) {
        Control[] children;
        Control buttonBar = super.createButtonBar(parent);
        Control[] controlArray = children = ((Composite)buttonBar).getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof HelpCompositeForDialog) {
                Composite helpComposite = (Composite)child;
                helpComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
                GridLayout layout = (GridLayout)helpComposite.getLayout();
                layout.marginBottom = 0;
                layout.marginRight = 0;
                helpComposite.getParent().layout(true, true);
                break;
            }
            ++n2;
        }
        return buttonBar;
    }

    protected void setInput() {
        UISynchronizeService.asyncExec(() -> {
            try {
                try {
                    this.mobileComposite.setInput();
                }
                catch (InvocationTargetException exception) {
                    Throwable targetException = exception.getTargetException();
                    LoggerSingleton.logError((Throwable)targetException);
                    MultiStatusErrorDialog.showErrorDialog((Throwable)targetException, (String)"Error", (String)targetException.getClass().getSimpleName());
                    this.validateToEnableStartButton();
                }
                catch (InterruptedException interruptedException) {
                    this.validateToEnableStartButton();
                }
            }
            finally {
                this.validateToEnableStartButton();
            }
        });
    }

    protected boolean hasDocumentation() {
        return true;
    }

    protected String getDocumentationUrl() {
        return MobileRecoderMessagesConstants.URL_DOCUMENTATION_MOBILE_RECORD;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, GlobalMessageConstants.DIA_SAVE_RECORDING, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.recordActionResult = new RecordActionResult(this.recordedActionsComposite.getStepView().getWrapper(), this.capturedObjectsComposite.getCapturedElements());
        Shell shell = this.getShell();
        try {
            if (!this.saveTestObject(shell, this.recordActionResult, this.getCurrentMobileDriverType())) {
                return;
            }
            this.okPressed = true;
            super.okPressed();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)shell, (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
        }
    }

    private boolean saveTestObject(Shell activeShell, RecordActionResult recordResult, MobileDriverType driverType) throws Exception {
        if (recordResult.getScript().getBlock().getAstChildren().isEmpty()) {
            return false;
        }
        if (!recordResult.getMobileElements().isEmpty()) {
            AddElementToObjectRepositoryDialogV2 objectRepositoryDialog = new AddElementToObjectRepositoryDialogV2(activeShell, recordResult.getMobileElements(), true);
            if (objectRepositoryDialog.open() != 0) {
                return false;
            }
            AddElementToObjectRepositoryDialogV2.AddToObjectRepositoryDialogResult addObjectResult = objectRepositoryDialog.getDialogResult();
            FolderTreeEntity selectedTreeFolder = addObjectResult.getSelectedParentFolder();
            FolderEntity folder = this.getFolder(selectedTreeFolder);
            CapturedMobileElementConverterV2 converter = new CapturedMobileElementConverterV2();
            MobileElementHelper helper = new MobileElementHelper();
            ArrayList<WebElementTreeEntity> selectedTreeEntities = new ArrayList<WebElementTreeEntity>();
            for (CapturedMobileElement capturedElement : addObjectResult.getAllSelectedElement()) {
                try {
                    if (capturedElement.isConflicted()) {
                        helper.addConflictedMobileElement(capturedElement, addObjectResult, selectedTreeEntities);
                        continue;
                    }
                    MobileElementEntity mobileElement = converter.convert(capturedElement, folder);
                    ObjectRepositoryController.getInstance().updateTestObject((WebElementEntity)mobileElement);
                    capturedElement.setScriptId(mobileElement.getIdForDisplay());
                    selectedTreeEntities.add(new WebElementTreeEntity((WebElementEntity)mobileElement, (ITreeEntity)selectedTreeFolder));
                }
                catch (Exception e) {
                    MouseAdapter mouseAdapter = this.initMouseAdapter();
                    String message = this.enhanceErrorMessage(e);
                    new ErrorDialogWithLink(activeShell, message, "<a>Learn more</a>", mouseAdapter).open();
                    LoggerSingleton.logError((Throwable)e);
                    return false;
                }
            }
            ExplorerPart.getInstance().setSelectedItems(selectedTreeEntities.toArray());
        }
        return true;
    }

    FolderEntity getFolder(FolderTreeEntity selectedTreeFolder) {
        FolderEntity folder = null;
        try {
            folder = selectedTreeFolder.getObject();
        }
        catch (Exception exception) {}
        return folder;
    }

    private MouseAdapter initMouseAdapter() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Program.launch((String)MobileRecoderMessagesConstants.LBL_DOC_TROUBLESHOOT_UNABLE_TO_SAVE_TEST_STEPS_MOBILE);
            }
        };
        return mouseAdapter;
    }

    private String enhanceErrorMessage(Exception e) {
        if (e instanceof FilePathTooLongException || e.getCause() instanceof FilePathTooLongException) {
            return MobileRecoderMessagesConstants.MSG_ERR_FILE_PATH_TOO_LONG;
        }
        return MobileRecoderMessagesConstants.MSG_ERR_CANNOT_GENERATE_TEST_STEPS;
    }

    private List<AstTreeTableNode> getRecordedActions() {
        return this.recordedActionsComposite.getRecordedActions();
    }

    public FolderTreeEntity getTargetFolderEntity() {
        return this.targetFolderEntity;
    }

    protected SashForm createMainSashForm(Composite container) {
        SashForm sashForm = (SashForm)ComponentBuilder.sashForm((Composite)container).fillLayout().sashWidth(3).background(ColorUtil.getCompositeBackgroundColorForSashform()).build();
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        return sashForm;
    }

    protected void populateSashForm(SashForm sashForm) {
        this.createLeftPaneComposite(sashForm);
        this.createMiddlePaneComposite(sashForm);
        this.deviceView = new MobileDeviceView((MobileElementInspectorDialog)this);
        this.deviceView.createControls((Composite)sashForm);
    }

    private void createLeftPaneComposite(SashForm sashForm) {
        Composite contentComposite = (Composite)ComponentBuilder.gridContainer((Composite)sashForm).margin(0).build();
        this.addStartStopToolbar(contentComposite);
        this.createSettingComposite(contentComposite);
        this.createActionsAndCapturedObjectsCompostite(contentComposite);
    }

    private void addStartStopToolbar(Composite contentComposite) {
        Composite toolbarComposite = (Composite)ComponentBuilder.gridContainer((Composite)contentComposite).build();
        toolbarComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ComponentBuilder.emptyCell((Composite)toolbarComposite);
        ToolBar contentToolbar = (ToolBar)ComponentBuilder.toolbar((Composite)toolbarComposite, (int)0x820000).foreground(ColorUtil.getToolBarForegroundColor()).build();
        contentToolbar.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnCapture = new ToolItem(contentToolbar, 0);
        this.btnCapture.setImage(MobileRecorderImageConstants.IMG_24_CAPTURE);
        this.btnCapture.setDisabledImage(MobileRecorderImageConstants.IMG_24_CAPTURE_DISABLED);
        this.btnCapture.setText(MobileRecoderMessagesConstants.BTN_CAPTURE_OBJECT);
        this.btnCapture.setToolTipText(MobileRecoderMessagesConstants.BTN_TOOLTIP_CAPTURE_OBJECT);
        this.btnCapture.setEnabled(false);
        this.btnStart = new ToolItem(contentToolbar, 0);
        this.btnStart.setImage(MobileRecorderImageConstants.IMG_24_START_DEVICE);
        this.btnStart.setDisabledImage(MobileRecorderImageConstants.IMG_24_START_DEVICE_DISABLED);
        this.btnStart.setText(MobileRecoderMessagesConstants.BTN_START);
        this.btnStart.setToolTipText(MobileRecoderMessagesConstants.BTN_TOOLTIP_START);
        this.btnStart.setEnabled(false);
        this.btnStop = new ToolItem(contentToolbar, 0);
        this.btnStop.setImage(MobileRecorderImageConstants.IMG_24_STOP_DEVICE);
        this.btnStop.setDisabledImage(MobileRecorderImageConstants.IMG_24_STOP_DEVICE_DISABLED);
        this.btnStop.setText(GlobalMessageConstants.STOP);
        this.btnStop.setToolTipText(GlobalMessageConstants.STOP);
        this.btnStop.setEnabled(false);
    }

    private void createSettingComposite(Composite parent) {
        new MobileConfigurationsComposite((Dialog)this, parent, this.mobileComposite);
    }

    private void createActionsAndCapturedObjectsCompostite(Composite parent) {
        CTabFolder leftBottomTabFolder = (CTabFolder)ComponentBuilder.tabFolder((Composite)parent).build();
        leftBottomTabFolder.setLayoutData((Object)new GridData(1808));
        this.createRecordedActionComposite((Composite)leftBottomTabFolder);
        CTabItem recordedActionTabItem = new CTabItem(leftBottomTabFolder, 0);
        recordedActionTabItem.setText("Recorded Actions");
        recordedActionTabItem.setControl((Control)this.recordedActionsComposite);
        SashForm capturedObjectsSashForm = (SashForm)ComponentBuilder.sashForm((Composite)leftBottomTabFolder, (int)512).fillLayout().build();
        capturedObjectsSashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createCapturedObjectsAndPropertiesComposite((Composite)capturedObjectsSashForm);
        capturedObjectsSashForm.setWeights(new int[]{4, 6, 2});
        CTabItem capturedObjectsTabItem = new CTabItem(leftBottomTabFolder, 0);
        capturedObjectsTabItem.setText("Captured Objects");
        capturedObjectsTabItem.setControl((Control)capturedObjectsSashForm);
        leftBottomTabFolder.setSelection(recordedActionTabItem);
        this.recordedActionsComposite.getStepView().setCapturedElementsTableViewer(this.capturedObjectsComposite.getCapturedObjectsTableViewer());
    }

    private void createRecordedActionComposite(Composite parent) {
        this.recordedActionsComposite = new MobileRecordedActionsComposite((Dialog)this, parent);
    }

    private void createCapturedObjectsAndPropertiesComposite(Composite parent) {
        this.createCapturedObjectsComposite(parent);
        this.createPropertiesComposite(parent);
        this.createHighlightElementComposite(parent);
    }

    private void createCapturedObjectsComposite(Composite parent) {
        this.capturedObjectsComposite = new MobileCapturedObjectsComposite((MobileElementInspectorDialog)this, parent);
    }

    private void createPropertiesComposite(Composite parent) {
        this.propertiesComposite = new MobileElementPropertiesComposite((MobileElementInspectorDialog)this, parent);
    }

    private void createHighlightElementComposite(Composite parent) {
        this.highlightElementComposite = new MobileHighlightComposite((MobileElementInspectorDialog)this);
        this.highlightElementComposite.createComposite(parent);
    }

    private void createMiddlePaneComposite(SashForm sashForm) {
        Composite middlePane = (Composite)ComponentBuilder.gridContainer((Composite)sashForm).margin(0).build();
        SashForm hSashForm = (SashForm)ComponentBuilder.sashForm((Composite)middlePane, (int)512).build();
        hSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createActionListComposite(hSashForm);
        this.createAllObjectsComposite((Composite)hSashForm);
        hSashForm.setWeights(new int[]{3, 7});
    }

    private void createActionListComposite(SashForm sashForm) {
        this.actionPerformHanlder.setParentDialog(this);
        this.actionPerformHanlder.renderActionButtons(sashForm, this.callbackActionButtonListenerFunction());
    }

    public RecordActionPerformHandler.ActionButtonListener callbackActionButtonListenerFunction() {
        return (action, buttonsComposite) -> new MobileActionButtonWrapper(buttonsComposite, action, event -> this.onActionChosen(action, this.allObjectsComposite.getSelectedElement()));
    }

    public void onActionChosen(MobileAction action, TreeMobileElement selectedElement) {
        try {
            if (selectedElement == null && (selectedElement = this.allObjectsComposite.getSelectedElement()) == null && (action.hasElement() || action == MobileAction.CaptureObject)) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Cannot find chosen Element", (String)"Something went wrong while choosing element to add action");
                return;
            }
            MobileActionMapping actionMapping = this.performAction(action, selectedElement);
            if (actionMapping == null) {
                return;
            }
            this.recordedActionsComposite.getStepView().addNode(actionMapping);
            ArrayList<CapturedMobileElement> mobileElements = new ArrayList<CapturedMobileElement>();
            CapturedMobileElement targetElement = actionMapping.getTargetElement();
            if (targetElement != null) {
                mobileElements.add(targetElement);
                this.capturedObjectsComposite.getCapturedObjectsTableViewer().addMobileElements(mobileElements);
                this.capturedObjectsComposite.setSelection(targetElement);
            }
        }
        catch (MobileRecordException | StepFailedException | ClassNotFoundException | InterruptedException | InvocationTargetException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((String)("Unable to perform action: " + action.getReadableName()), (String)e.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }

    private void createAllObjectsComposite(Composite parent) {
        this.allObjectsComposite = new MobileAllObjectsComposite(this, parent);
    }

    @Override
    public MobileTestObject convertMobileElementToTestObject(CapturedMobileElement targetElement, MobileDriverType driverType) {
        if (targetElement == null) {
            return null;
        }
        MobileTestObject mobileTestObject = targetElement.toMobileTestObject();
        return mobileTestObject;
    }

    private MobileActionMapping performAction(final MobileAction action, final TreeMobileElement treeElement) throws MobileRecordException {
        MobileActionMapping mobileActionMapping;
        block7: {
            final ProgressMonitorDialogWithThread progressDlg = new ProgressMonitorDialogWithThread(this.getShell()){

                public void cancelPressed() {
                    super.cancelPressed();
                    this.finishedRun();
                    this.getProgressMonitor().done();
                }
            };
            final AtomicBoolean isCancelled = new AtomicBoolean(false);
            mobileActionMapping = MobileActionMapping.newEmpty();
            IRunnableWithProgress processToRun = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MobileRecoderMessagesConstants.MSG_TASK_EXECUTING_COMMAND, -1);
                    progressDlg.runAndWait((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            CapturedMobileElement targetElement = null;
                            if (action.hasElement() || action == MobileAction.CaptureObject) {
                                targetElement = MobileRecorderDialog.this.captureMobileElement(treeElement);
                            }
                            CapturedMobileElement element = targetElement;
                            UISynchronizeService.asyncExec(() -> {
                                MobileDriverType mobileDriverType = MobileRecorderDialog.this.getCurrentMobileDriverType();
                                AppiumDriver driver = (this).MobileRecorderDialog.this.inspectorController.getDriver();
                                MobileTestObject testObject = MobileRecorderDialog.this.convertMobileElementToTestObject(element, mobileDriverType);
                                if ((this).MobileRecorderDialog.this.actionPerformHanlder != null) {
                                    try {
                                        (this).MobileRecorderDialog.this.actionPerformHanlder.performAction(MobileRecorderDialog.this.getShell(), (TestObject)testObject, action, element, mobileActionMapping, driver);
                                        Thread.sleep(500L);
                                    }
                                    catch (Exception e) {
                                        if (e instanceof CancellationException) {
                                            isCancelled.set(true);
                                        }
                                        LoggerSingleton.logError((Throwable)e);
                                    }
                                }
                            });
                            isCancelled.set(false);
                            return null;
                        }
                    });
                    MobileRecorderDialog.this.checkMonitorCanceled(monitor);
                    monitor.done();
                }
            };
            progressDlg.run(true, false, processToRun);
            if (!isCancelled.get()) break block7;
            return null;
        }
        try {
            this.captureObjectAction();
            this.setSelectedElement(null);
            this.allObjectsComposite.clearAllSelections();
            return mobileActionMapping;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ExecutionException) {
                ExecutionException executionException = (ExecutionException)e.getTargetException();
                Throwable cause = executionException.getCause();
                if (cause instanceof StepFailedException) {
                    throw (StepFailedException)cause;
                }
                if (cause instanceof CancellationException) {
                    return null;
                }
                throw new MobileRecordException(cause);
            }
            throw new MobileRecordException(e.getTargetException());
        }
        catch (Exception e) {
            throw new MobileRecordException(e);
        }
    }

    @Override
    public MobileDriverType getCurrentMobileDriverType() {
        return this.mobileComposite.getSelectedDriverType();
    }

    public void refreshButtonsState() {
        this.validateToEnableStartButton();
        this.updateActionButtonsVisibility((MobileElement)this.propertiesComposite.getEditingElement());
    }

    public void updateDeviceNames() {
        UISynchronizeService.asyncExec(() -> {
            try {
                try {
                    this.mobileComposite.loadDevices();
                }
                catch (InvocationTargetException exception) {
                    Throwable targetException = exception.getTargetException();
                    LoggerSingleton.logError((Throwable)targetException);
                    MultiStatusErrorDialog.showErrorDialog((Throwable)targetException, (String)"Error", (String)targetException.getClass().getSimpleName());
                    this.validateToEnableStartButton();
                }
                catch (InterruptedException interruptedException) {
                    this.validateToEnableStartButton();
                }
            }
            finally {
                this.validateToEnableStartButton();
            }
        });
    }

    private void startObjectInspectorAction() {
        this.btnStart.setEnabled(false);
        this.deviceView.setDisposed(false);
        AppiumMonitorDialog progressDlg = new AppiumMonitorDialog(this.getShell()){

            public void cancelPressed() {
                super.cancelPressed();
                this.finishedRun();
                this.getProgressMonitor().done();
                MobileRecorderDialog.this.btnStart.setEnabled(true);
                MobileRecorderDialog.this.btnStop.setEnabled(false);
                MobileRecorderDialog.this.btnCapture.setEnabled(false);
            }
        };
        this.inspectorController.setStreamHandler((AppiumStreamHandler)progressDlg);
        try {
            if (!this.mobileComposite.startApp((IMobileInspectorController)this.inspectorController, progressDlg)) {
                this.btnStart.setEnabled(true);
                return;
            }
            try {
                this.captureObjectAction();
                this.btnCapture.setEnabled(true);
                this.btnStop.setEnabled(true);
                this.getButton(0).setEnabled(true);
                this.setSelectedElement(null);
                this.recordedActionsComposite.getStepView().addNode(this.mobileComposite.buildStartAppActionMapping());
                this.sendRecordMobileTrackingEvent();
            }
            catch (ClassNotFoundException | InterruptedException | InvocationTargetException ex) {
                if (ex instanceof InvocationTargetException) {
                    LoggerSingleton.logError((Throwable)ex);
                    Throwable targetException = ((InvocationTargetException)ex).getTargetException();
                    String message = targetException instanceof ExecutionException ? targetException.getCause().getMessage() : targetException.getMessage();
                    boolean runIOSDevice = this.mobileComposite.getSelectedDriverType() == MobileDriverType.IOS_DRIVER;
                    UISynchronizeService.syncExec(() -> {
                        ErrorStartMobileApplicationHaveTroubleshootDialog dialog = new ErrorStartMobileApplicationHaveTroubleshootDialog("Unable to start application", message, ExceptionsUtil.getStackTraceForThrowable((Throwable)targetException), runIOSDevice);
                        dialog.open();
                    });
                }
                this.btnStart.setEnabled(true);
                this.btnStop.setEnabled(false);
                this.btnCapture.setEnabled(false);
            }
        }
        finally {
            this.inspectorController.setStreamHandler(null);
        }
    }

    private void sendRecordMobileTrackingEvent() {
        String appiumVersion = this.inspectorController.getAppiumVersion();
        String platformVersion = null;
        String deviceName = null;
        MobileDeviceOption mobileDeviceOption = null;
        if (this.mobileComposite instanceof KobitonAppComposite) {
            KobitonDevice kobitonDevice = ((KobitonAppComposite)this.mobileComposite).getSelectedKobitonDevice();
            if (kobitonDevice.getCapabilities() != null) {
                platformVersion = kobitonDevice.getCapabilities().getPlatformVersion();
                deviceName = kobitonDevice.getCapabilities().getDeviceName();
            }
            mobileDeviceOption = this.mobileComposite.getMobileDeviceOption();
        } else if (this.mobileComposite instanceof MobileLocalAppComposite) {
            MobileDeviceInfo localDevice = ((MobileLocalAppComposite)this.mobileComposite).getSelectedMobileDeviceInfo();
            platformVersion = localDevice.getDeviceOSVersion();
            deviceName = localDevice.getDeviceName();
        } else if (this.mobileComposite instanceof TestCloudConfigurationsComposite) {
            TestCloudMobileDevice testCloudDevice = ((TestCloudConfigurationsComposite)this.mobileComposite).getSelectedDevice();
            platformVersion = testCloudDevice.getOsVersion();
            deviceName = testCloudDevice.getName();
            mobileDeviceOption = this.mobileComposite.getMobileDeviceOption();
        }
        String remoteServer = Objects.nonNull(mobileDeviceOption) ? mobileDeviceOption.toString() : "";
        Trackings.trackMobileRecord((String)this.getDeviceTypeString(), (String)appiumVersion, (String)deviceName, (String)platformVersion, (String)remoteServer);
    }

    public String getAppName() {
        return this.mobileComposite.getAppName();
    }

    private void captureObjectAction() {
        final ProgressMonitorDialogWithThread dialog = new ProgressMonitorDialogWithThread(this.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(MobileRecoderMessagesConstants.MSG_TASK_CAPTURING_OBJECTS, -1);
                TreeMobileElement newAppRootElement = (TreeMobileElement)dialog.runAndWait((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        TreeMobileElement appRootElement = (this).MobileRecorderDialog.this.inspectorController.getMobileObjectRoot();
                        return appRootElement;
                    }
                });
                MobileRecorderDialog.this.checkMonitorCanceled(monitor);
                this.refreshTreeElements(dialog, newAppRootElement);
                String imgPath = this.captureImage();
                MobileRecorderDialog.this.checkMonitorCanceled(monitor);
                this.refreshDeviceView(imgPath, newAppRootElement);
                MobileRecorderDialog.this.appRootElement = newAppRootElement;
                monitor.done();
            }

            private void refreshTreeElements(ProgressMonitorDialogWithThread dialog2, final TreeMobileElement newAppRootElement) {
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TreeViewer allElementTreeViewer = (this).MobileRecorderDialog.this.allObjectsComposite.getAllElementTreeViewer();
                        if (newAppRootElement != null) {
                            allElementTreeViewer.setInput((Object)new Object[]{newAppRootElement});
                        } else {
                            allElementTreeViewer.setInput((Object)new Object[0]);
                        }
                        allElementTreeViewer.refresh();
                        allElementTreeViewer.expandAll();
                    }
                });
            }

            private void refreshDeviceView(String imgPath, TreeMobileElement newAppRootElement) {
                File imgFile = new File(imgPath);
                if (imgFile.exists()) {
                    MobileRecorderDialog.this.deviceView.refreshDialog(imgFile, (MobileElement)newAppRootElement);
                    this.refreshDeviceName();
                }
            }

            private void refreshDeviceName() {
                UISynchronizeService.syncExec(() -> {
                    String executionSessionId;
                    TestCloudExecutionSessionResponse executionSessionResponse;
                    Map capabilities;
                    Map katalonOptions;
                    TestCloudMobileDevice testCloudDevice;
                    if (MobileRecorderDialog.this.mobileComposite instanceof TestCloudConfigurationsComposite && (testCloudDevice = ((TestCloudConfigurationsComposite)MobileRecorderDialog.this.mobileComposite).getSelectedDevice()) != null && (katalonOptions = (Map)(capabilities = MobileRecorderDialog.this.inspectorController.getDriver().getCapabilities().asMap()).get("katalon:options")) != null && (executionSessionResponse = ((TestCloudConfigurationsComposite)MobileRecorderDialog.this.mobileComposite).getExecutionSession(executionSessionId = (String)katalonOptions.get("executionSessionId"))) != null && executionSessionResponse.getExecutionEnv() != null && executionSessionResponse.getExecutionEnv().get("deviceName") != null && executionSessionResponse.getExecutionEnv().get("platformVersion") != null) {
                        String deviceName = String.format("%s v%s", executionSessionResponse.getExecutionEnv().get("deviceName").toString(), executionSessionResponse.getExecutionEnv().get("platformVersion").toString());
                        MobileRecorderDialog.this.deviceView.refreshDeviceName(deviceName);
                    }
                });
            }

            private String captureImage() throws InvocationTargetException {
                try {
                    return MobileRecorderDialog.this.inspectorController.captureScreenshot();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            try {
                this.btnCapture.setEnabled(false);
                dialog.run(true, false, runnable);
            }
            catch (InterruptedException interruptedException) {
                this.btnCapture.setEnabled(true);
            }
            catch (InvocationTargetException e) {
                LoggerSingleton.logError((Throwable)e);
                Throwable exception = e.getTargetException();
                MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)MobileRecoderMessagesConstants.MSG_ERR_CANNOT_CAPTURE_OBJECTS, (String)exception.getClass().getSimpleName());
                this.btnCapture.setEnabled(true);
            }
        }
        finally {
            this.btnCapture.setEnabled(true);
        }
    }

    private void checkMonitorCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException(MobileRecoderMessagesConstants.MSG_ERR_OPERATION_CANCELLED);
        }
    }

    private void stopObjectInspectorAction() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (MobileRecorderDialog.this.inspectorController.getDriver() != null) {
                    MobileRecorderDialog.this.inspectorController.closeApp();
                }
            }
        });
        thread.start();
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            this.btnStart.setEnabled(true);
            this.btnStop.setEnabled(false);
            this.btnCapture.setEnabled(false);
            this.updateActionButtonsVisibility(null);
            this.allObjectsComposite.clearAllElements();
            try {
                this.recordedActionsComposite.getStepView().refreshTree();
            }
            catch (InterruptedException | InvocationTargetException exeception) {
                LoggerSingleton.logError((Throwable)exeception);
            }
        }
        if (this.deviceView != null) {
            this.deviceView.setDisposed(true);
        }
        try {
            this.addAdditionalActions();
        }
        catch (ClassNotFoundException | InterruptedException | InvocationTargetException exception) {
            if (exception instanceof InterruptedException) {
                return;
            }
            LoggerSingleton.logError((Throwable)exception);
            Throwable targetException = ((InvocationTargetException)exception).getTargetException();
            String message = targetException instanceof ExecutionException ? targetException.getCause().getMessage() : targetException.getMessage();
            UISynchronizeService.syncExec(() -> MultiStatusErrorDialog.showErrorDialog((String)"Unable to close application", (String)message, (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)targetException)));
        }
    }

    private void addAdditionalActions() throws ClassNotFoundException, InvocationTargetException, InterruptedException {
        int numRecordedActions = this.recordedActionsComposite.getRecordedActions().size();
        if (numRecordedActions <= 0) {
            return;
        }
        AstTreeTableNode lastRecordAction = this.recordedActionsComposite.getRecordedActions().get(numRecordedActions - 1);
        ExpressionStatementWrapper lastExpressionWrapper = (ExpressionStatementWrapper)lastRecordAction.getASTObject();
        MethodCallExpressionWrapper lastMethodCallExpression = (MethodCallExpressionWrapper)lastExpressionWrapper.getExpression();
        if (((ConstantExpressionWrapper)lastMethodCallExpression.getMethod()).getValue().equals(MobileAction.CloseApplication.getMappedKeywordMethod())) {
            return;
        }
        this.recordedActionsComposite.getStepView().addNode(new MobileActionMapping((IMobileAction)MobileAction.CloseApplication, null));
    }

    private void validateToEnableStartButton() {
        this.btnStart.setEnabled(this.mobileComposite.isAbleToStart());
    }

    private boolean validateAppSetting() {
        return this.mobileComposite.validateSetting();
    }

    public void highlightElement(MobileElement selectedElement) {
        if (selectedElement == null || this.deviceView == null || this.deviceView.isDisposed()) {
            return;
        }
        this.deviceView.highlightElement(selectedElement);
    }

    public void highlightElementRects(List<Rectangle> rects) {
        this.deviceView.highlightRects(rects);
    }

    public void setSelectedElementByLocation(int x, int y) {
        if (this.appRootElement == null) {
            return;
        }
        TreeMobileElement foundElement = new ElementSelectionHelper().findTopMostElementByLocation(this.appRootElement, x, y);
        if (foundElement == null) {
            return;
        }
        this.setSelectedElement((MobileElement)foundElement);
    }

    public MobileObjectSpyPreferencesHelper getPreferencesHelper() {
        return this.preferencesHelper;
    }

    public void setSelectedElement(final MobileElement element) {
        this.highlightElement(element);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MobileRecorderDialog.this.getShell().setFocus();
                MobileRecorderDialog.this.allObjectsComposite.focusToElementsTree();
                if (element instanceof TreeMobileElement) {
                    TreeMobileElement treeElement = (TreeMobileElement)element;
                    MobileRecorderDialog.this.allObjectsComposite.setSelection(treeElement);
                } else if (element instanceof CapturedMobileElement) {
                    CapturedMobileElement capElement = (CapturedMobileElement)element;
                    MobileRecorderDialog.this.allObjectsComposite.setSelection(capElement.getLink());
                }
            }
        });
        this.updateActionButtonsVisibility(element);
    }

    public void updateSelectedElement(CapturedMobileElement element) {
        this.capturedObjectsComposite.refresh((Object)element, true);
        TreeMobileElement treeElement = element.getLink();
        if (treeElement != null) {
            this.allObjectsComposite.getAllElementTreeViewer().refresh((Object)treeElement);
            this.allObjectsComposite.getAllElementTreeViewer().setSelection((ISelection)new StructuredSelection((Object)treeElement));
        }
    }

    public void handleCapturedObjectsTableSelectionChange() {
    }

    public void setEdittingElement(CapturedMobileElement element) {
        this.propertiesComposite.setEditingElement(element);
        this.highlightElementComposite.setEditingElement(element);
    }

    public void addCapturedElement(CapturedMobileElement element) {
        this.capturedObjectsComposite.addElement(element);
        this.propertiesComposite.focusAndEditCapturedElementName();
    }

    public boolean isAddedCapturedElement(CapturedMobileElement element) {
        return this.capturedObjectsComposite.containsElement(element);
    }

    public void removeCapturedElement(CapturedMobileElement element) {
        this.capturedObjectsComposite.removeElement(element);
        if (element == this.propertiesComposite.getEditingElement()) {
            this.propertiesComposite.setEditingElement(null);
            this.highlightElementComposite.setEditingElement(null);
        }
    }

    public void focusAndEditCapturedElementName() {
        this.propertiesComposite.focusAndEditCapturedElementName();
    }

    public void removeSelectedCapturedElements(CapturedMobileElement[] elements) {
        this.capturedObjectsComposite.removeElements(Arrays.asList(elements));
        this.propertiesComposite.setEditingElement(null);
        this.highlightElementComposite.setEditingElement(null);
    }

    public void verifyCapturedElementsStates(CapturedMobileElement[] elements) {
    }

    public MobileInspectorController getInspectorController() {
        return this.inspectorController;
    }

    public CapturedMobileElement captureMobileElement(TreeMobileElement treeElement) {
        if (treeElement == null) {
            return null;
        }
        return treeElement.newCapturedElement(this.inspectorController.getDriver(), this.capturedObjectsComposite.getHashCapturedElements());
    }

    private String getDeviceTypeString() {
        MobileDriverType deviceType = this.mobileComposite.getSelectedDriverType();
        return deviceType != null ? deviceType.toString() : null;
    }

    protected void registerControlModifyListeners() {
        this.btnCapture.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileRecorderDialog.this.captureObjectAction();
            }
        });
        this.btnStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MobileRecorderDialog.this.validateAppSetting()) {
                    MobileRecorderDialog.this.startObjectInspectorAction();
                    MobileRecorderDialog.this.updateActionButtonsVisibility((MobileElement)MobileRecorderDialog.this.propertiesComposite.getEditingElement());
                }
            }
        });
        this.btnStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileRecorderDialog.this.stopObjectInspectorAction();
            }
        });
    }

    private void updateActionButtonsVisibility(MobileElement capturedElement) {
        this.actionPerformHanlder.updateActionButtonsVisibility(capturedElement, this.getCurrentMobileDriverType(), this.inspectorController.getDriver());
    }

    @Override
    public int open() {
        String appiumVersion = this.inspectorController.getAppiumVersion();
        MobileDeviceOption mobileDeviceOption = this.mobileComposite.getMobileDeviceOption();
        String deviceOption = Objects.nonNull(mobileDeviceOption) ? mobileDeviceOption.toString() : "";
        Trackings.trackOpenMobileRecord((String)this.getDeviceTypeString(), (String)appiumVersion, (String)deviceOption);
        return super.open();
    }

    public CapturedMobileElement captureMobileElement(int x, int y) {
        if (this.appRootElement == null) {
            return null;
        }
        if (this.focusingElement != null) {
            return this.captureMobileElement(this.focusingElement);
        }
        TreeMobileElement foundElement = new ElementSelectionHelper().findTopMostElementByLocation(this.appRootElement, x, y);
        return this.captureMobileElement(foundElement);
    }

    @Inject
    @Optional
    private void subscribeTestCloudStartRecordSpy(@UIEventTopic(value="TESTCLOUD/CANCEL_START_TESTCLOUD_RECORD_SPY") Map data) {
        this.btnStart.setEnabled(true);
        this.btnStop.setEnabled(false);
        this.btnCapture.setEnabled(false);
    }

    @Inject
    @Optional
    private void subscribeChangeTestCloudDevicePlatform(@UIEventTopic(value="TESTCLOUD/REFRESH_START_BUTTON_STATE") Map data) {
        this.validateToEnableStartButton();
    }

    @Override
    public MobileAppComposite getMobileAppComposite() {
        return this.mobileComposite;
    }
}

