/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.mobile.objectspy.components.MobileLocalAppComposite;
import com.kms.katalon.composer.mobile.objectspy.interfaces.MobileAppComposite;
import com.kms.katalon.composer.mobile.recorder.components.MobileRecorderDialog;
import com.kms.katalon.composer.mobile.recorder.handlers.OpenRecorderHandler;
import com.kms.katalon.composer.mobile.util.MobileUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenAndroidRecorderHandler
extends OpenRecorderHandler {
    private MobileRecorderDialog recorderDialog;
    private Shell activeShell;
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void registerEvent() {
        this.eventBroker.subscribe("OBJECT_SPY/MOBILE", new EventHandler(){

            public void handleEvent(Event event) {
                if (!OpenAndroidRecorderHandler.this.canExecute()) {
                    return;
                }
                OpenAndroidRecorderHandler.this.execute(Display.getCurrent().getActiveShell());
            }
        });
    }

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell activeShell) {
        MobileUtil.detectAppiumAndNodeJs((Shell)activeShell);
        this.openRecorderDialog(activeShell);
    }

    private boolean openRecorderDialog(Shell activeShell) {
        block4: {
            try {
                if (this.activeShell == null) {
                    this.activeShell = activeShell;
                }
                Shell dialogShell = DialogUtil.createDialogShell((Shell)activeShell);
                this.recorderDialog = new MobileRecorderDialog(dialogShell, (MobileAppComposite)new MobileLocalAppComposite(MobileDriverType.ANDROID_DRIVER));
                if (this.recorderDialog.open() == 0) break block4;
                return false;
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                MessageDialog.openError((Shell)activeShell, (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
                return false;
            }
        }
        this.saveToTestCase(activeShell, this.recorderDialog.getRecordActionResult());
        return true;
    }
}

