/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.mobile.objectspy.components.KobitonAppComposite;
import com.kms.katalon.composer.mobile.objectspy.interfaces.MobileAppComposite;
import com.kms.katalon.composer.mobile.recorder.components.MobileRecorderDialog;
import com.kms.katalon.composer.mobile.recorder.handlers.OpenRecorderHandler;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class OpenKobitonRecoderHandler
extends OpenRecorderHandler {
    private MobileRecorderDialog recorderDialog;
    private Shell activeShell;
    @Inject
    private IEventBroker eventBroker;

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell activeShell) {
        this.openRecorderDialog(activeShell);
    }

    private boolean openRecorderDialog(Shell activeShell) {
        block8: {
            block6: {
                block7: {
                    try {
                        boolean isIntegrationEnabled;
                        if (this.activeShell == null) {
                            this.activeShell = activeShell;
                        }
                        if (isIntegrationEnabled = KobitonPreferencesProvider.isKobitonIntegrationEnabled()) break block6;
                        boolean confirmToConfigureKobiton = MessageDialog.openConfirm((Shell)activeShell, (String)GlobalStringConstants.INFO, (String)"Kobiton integration has not been enabled yet. Would you like to enable now?");
                        if (confirmToConfigureKobiton) break block7;
                        return false;
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                        MessageDialog.openError((Shell)activeShell, (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
                        return false;
                    }
                }
                this.eventBroker.post("KATALON/PREFERENCES", (Object)"com.kms.katalon.composer.preferences.GeneralPreferencePage/com.kms.katalon.composer.integration.kobiton.preferences");
                return false;
            }
            Shell dialogShell = DialogUtil.createDialogShell((Shell)activeShell);
            this.recorderDialog = new MobileRecorderDialog(dialogShell, (MobileAppComposite)new KobitonAppComposite());
            if (this.recorderDialog.open() == 0) break block8;
            return false;
        }
        this.saveToTestCase(activeShell, this.recorderDialog.getRecordActionResult());
        return true;
    }
}

