/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.mitm.tools;

import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import net.lightbody.bmp.mitm.CertificateAndKey;
import net.lightbody.bmp.mitm.CertificateInfo;
import net.lightbody.bmp.mitm.exception.ImportException;
import net.lightbody.bmp.mitm.exception.KeyStoreAccessException;
import net.lightbody.bmp.mitm.tools.BouncyCastleSecurityProviderTool;
import net.lightbody.bmp.mitm.tools.SecurityProviderTool;
import net.lightbody.bmp.mitm.util.KeyStoreUtil;

public class DefaultSecurityProviderTool
implements SecurityProviderTool {
    private final SecurityProviderTool bouncyCastle = new BouncyCastleSecurityProviderTool();

    @Override
    public CertificateAndKey createCARootCertificate(CertificateInfo certificateInfo, KeyPair keyPair, String messageDigest) {
        return this.bouncyCastle.createCARootCertificate(certificateInfo, keyPair, messageDigest);
    }

    @Override
    public CertificateAndKey createServerCertificate(CertificateInfo certificateInfo, X509Certificate caRootCertificate, PrivateKey caPrivateKey, KeyPair serverKeyPair, String messageDigest) {
        return this.bouncyCastle.createServerCertificate(certificateInfo, caRootCertificate, caPrivateKey, serverKeyPair, messageDigest);
    }

    @Override
    public KeyStore createServerKeyStore(String keyStoreType, CertificateAndKey serverCertificateAndKey, X509Certificate rootCertificate, String privateKeyAlias, String password) {
        if (password == null) {
            throw new IllegalArgumentException("KeyStore password cannot be null");
        }
        if (privateKeyAlias == null) {
            throw new IllegalArgumentException("Private key alias cannot be null");
        }
        KeyStore impersonatedCertificateKeyStore = KeyStoreUtil.createEmptyKeyStore(keyStoreType, null);
        Certificate[] chain = new Certificate[]{serverCertificateAndKey.getCertificate(), rootCertificate};
        try {
            impersonatedCertificateKeyStore.setKeyEntry(privateKeyAlias, serverCertificateAndKey.getPrivateKey(), password.toCharArray(), chain);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreAccessException("Error storing impersonated certificate and private key in KeyStore", e);
        }
        return impersonatedCertificateKeyStore;
    }

    @Override
    public KeyStore createRootCertificateKeyStore(String keyStoreType, CertificateAndKey rootCertificateAndKey, String privateKeyAlias, String password) {
        return KeyStoreUtil.createRootCertificateKeyStore(keyStoreType, rootCertificateAndKey.getCertificate(), privateKeyAlias, rootCertificateAndKey.getPrivateKey(), password, null);
    }

    @Override
    public String encodePrivateKeyAsPem(PrivateKey privateKey, String passwordForPrivateKey, String encryptionAlgorithm) {
        return this.bouncyCastle.encodePrivateKeyAsPem(privateKey, passwordForPrivateKey, encryptionAlgorithm);
    }

    @Override
    public String encodeCertificateAsPem(Certificate certificate) {
        return this.bouncyCastle.encodeCertificateAsPem(certificate);
    }

    @Override
    public PrivateKey decodePemEncodedPrivateKey(Reader privateKeyReader, String password) {
        return this.bouncyCastle.decodePemEncodedPrivateKey(privateKeyReader, password);
    }

    @Override
    public X509Certificate decodePemEncodedCertificate(Reader certificateReader) {
        Certificate certificate;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (ByteArrayInputStream certificateAsStream = new ByteArrayInputStream(CharStreams.toString((Readable)certificateReader).getBytes(StandardCharsets.US_ASCII));){
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                certificate = certificateFactory.generateCertificate(certificateAsStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CertificateException e) {
            throw new ImportException("Unable to read PEM-encoded X509Certificate", e);
        }
        if (!(certificate instanceof X509Certificate)) {
            throw new ImportException("Attempted to import non-X.509 certificate as X.509 certificate");
        }
        return (X509Certificate)certificate;
    }

    @Override
    public KeyStore loadKeyStore(File file, String keyStoreType, String password) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(keyStoreType);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreAccessException("Unable to get KeyStore instance of type: " + keyStoreType, e);
        }
        try {
            Throwable e = null;
            Object var6_10 = null;
            try (FileInputStream keystoreAsStream = new FileInputStream(file);){
                keyStore.load(keystoreAsStream, password.toCharArray());
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new ImportException("Unable to read KeyStore from file: " + file.getName(), e);
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new ImportException("Error while reading KeyStore", e);
        }
        return keyStore;
    }

    @Override
    public void saveKeyStore(File file, KeyStore keyStore, String keystorePassword) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                keyStore.store(fos, keystorePassword.toCharArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreAccessException("Unable to save KeyStore to file: " + file.getName(), e);
        }
    }

    @Override
    public KeyManager[] getKeyManagers(KeyStore keyStore, String keyStorePassword) {
        return KeyStoreUtil.getKeyManagers(keyStore, keyStorePassword, null, null);
    }
}

