/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.providers;

import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.testsuite.providers.TestCaseTableViewer;
import com.kms.katalon.controller.FilterController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class TestCaseTableViewerFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element == null || !(element instanceof TestSuiteTestCaseLink)) {
            return false;
        }
        TestSuiteTestCaseLink testCaseLink = (TestSuiteTestCaseLink)element;
        TestCaseTableViewer tableViewer = (TestCaseTableViewer)viewer;
        return this.filter(tableViewer.getSearchedString(), testCaseLink);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean filter(String searchedString, TestSuiteTestCaseLink testCaseLink) {
        if (searchedString == null) return true;
        if (searchedString.isEmpty()) {
            return true;
        }
        String contentString = searchedString.trim();
        String testCaseId = testCaseLink.getTestCaseId();
        if (testCaseId.contains(searchedString)) {
            return true;
        }
        try {
            TestCaseEntity testCaseEntity = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseId);
            if (testCaseEntity == null) {
                return false;
            }
            Map tagMap = EntityViewerFilter.parseSearchedString((String[])this.getSearchTags(), (String)contentString);
            if (tagMap != null && !tagMap.isEmpty()) {
                return FilterController.getInstance().isMatched((FileEntity)testCaseEntity, contentString);
            }
            String[] stringArray = TestCaseTreeEntity.SEARCH_TAGS;
            int n = TestCaseTreeEntity.SEARCH_TAGS.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String tag = stringArray[n2];
                String entityValue = this.getEntityValueBySearchTag(tag, testCaseEntity).toLowerCase();
                if (entityValue != null && entityValue.toLowerCase().contains(contentString)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String[] getSearchTags() {
        List searchTags = FilterController.getInstance().getDefaultKeywords();
        return searchTags.toArray(new String[searchTags.size()]);
    }

    private String getEntityValueBySearchTag(String searchTag, TestCaseEntity testCase) throws Exception {
        switch (searchTag) {
            case "id": {
                return testCase.getIdForDisplay();
            }
            case "name": {
                return testCase.getName();
            }
            case "description": {
                return testCase.getDescription();
            }
            case "tag": {
                return testCase.getTag();
            }
        }
        return "";
    }
}

