/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.dialog;

import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PostFailMigrationDialog
extends Dialog {
    private Runnable revertHandler;
    private Runnable keepChangesHandler;
    private String failReason;

    public PostFailMigrationDialog(Shell parentShell, String failReason) {
        super(parentShell);
        this.failReason = failReason;
    }

    public void setRevertHandler(Runnable handler) {
        this.revertHandler = handler;
    }

    public void setKeepChangesHandler(Runnable handler) {
        this.keepChangesHandler = handler;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Migration Incomplete");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        ComponentUtil.setMargin((Composite)container, (int)10, (int)10);
        ComponentBuilder.label((Composite)container, (int)64).text(String.format("\u26a0\ufe0f Your project could not be fully migrated to Studio 10.x due to unexpected issues.\nFail reason:\n%s\n\nYou can choose to keep the current changes\nOr revert the project back to its original version\n", this.failReason)).fill().build();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button revertButton = this.createButton(parent, 0, "Revert", false);
        revertButton.addListener(13, e -> {
            if (this.revertHandler != null) {
                this.revertHandler.run();
            }
            this.close();
        });
        Button keepButton = this.createButton(parent, 1, "Keep changes", true);
        keepButton.addListener(13, e -> {
            if (this.keepChangesHandler != null) {
                this.keepChangesHandler.run();
            }
            this.close();
        });
    }
}

