/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.model;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.Result;

public class MigrationEntry {
    private Path filePath;
    private SourceFileSyntaxType sourceFileSyntaxType;
    private String diffContent;
    private Result rawResult;
    private String errorMessage;
    private Status status;

    public MigrationEntry(Path path, SourceFileSyntaxType syntaxType, String diffContent) {
        this.filePath = path;
        this.sourceFileSyntaxType = syntaxType;
        this.diffContent = diffContent;
    }

    public static MigrationEntry unchanged(Path path, SourceFileSyntaxType syntaxType) {
        MigrationEntry entry = new MigrationEntry(path, syntaxType, null);
        entry.setStatus(Status.UNCHANGED);
        return entry;
    }

    public static MigrationEntry changed(Path path, SourceFileSyntaxType syntaxType, Result rawResult) {
        MigrationEntry entry = new MigrationEntry(path, syntaxType, rawResult != null ? rawResult.diff() : null);
        entry.setStatus(Status.CHANGED);
        entry.setRawResult(rawResult);
        return entry;
    }

    public static MigrationEntry error(Path path, SourceFileSyntaxType syntaxType, String errorMessage) {
        MigrationEntry entry = new MigrationEntry(path, syntaxType, null);
        entry.setStatus(Status.ERROR);
        entry.setErrorMessage(errorMessage);
        return entry;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public void setFilePath(Path filePath) {
        this.filePath = filePath;
    }

    public String getDiffContent() {
        return this.diffContent;
    }

    public void setDiffContent(String diffContent) {
        this.diffContent = diffContent;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Result getRawResult() {
        return this.rawResult;
    }

    public void setRawResult(Result rawResult) {
        this.rawResult = rawResult;
    }

    public boolean isNewlyAdded() {
        return this.status == Status.CHANGED && this.rawResult != null && this.rawResult.getBefore() == null;
    }

    public List<String> getModifiedByRecipeNames() {
        if (this.rawResult == null) {
            return List.of();
        }
        return this.rawResult.getRecipeDescriptorsThatMadeChanges().stream().map(rd -> rd.getInstanceName()).collect(Collectors.toList());
    }

    public SourceFileSyntaxType getSourceFileSyntaxType() {
        return this.sourceFileSyntaxType;
    }

    public void setSourceFileSyntaxType(SourceFileSyntaxType sourceFileSyntaxType) {
        this.sourceFileSyntaxType = sourceFileSyntaxType;
    }

    public static enum SourceFileSyntaxType {
        GROOVY_AST,
        GROOVY_NON_AST,
        JSON_PROPERTIES;

    }

    public static enum Status {
        UNCHANGED,
        CHANGED,
        ERROR;

    }
}

