/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.model;

import com.kms.katalon.migration.model.MigrationAttempt;
import java.util.Optional;

public class ProgressUpdate {
    private final UpdateType type;
    private final Optional<ProgressInfo> progressInfo;
    private final Optional<String> logMessage;
    private final Optional<String> modifiedFile;
    private final Optional<MigrationAttempt.Status> migrationStatus;

    private ProgressUpdate(UpdateType type, Optional<ProgressInfo> progressInfo, Optional<String> logMessage, Optional<String> modifiedFile, Optional<MigrationAttempt.Status> migrationStatus) {
        this.type = type;
        this.progressInfo = progressInfo;
        this.logMessage = logMessage;
        this.modifiedFile = modifiedFile;
        this.migrationStatus = migrationStatus;
    }

    public static ProgressUpdate percentChanged(ProgressInfo progressInfo) {
        return new ProgressUpdate(UpdateType.PERCENT_CHANGED, Optional.of(progressInfo), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static ProgressUpdate logAppended(String logMessage) {
        return new ProgressUpdate(UpdateType.LOG_APPENDED, Optional.empty(), Optional.of(logMessage), Optional.empty(), Optional.empty());
    }

    public static ProgressUpdate modifiedFileAppended(String modifiedFile) {
        return new ProgressUpdate(UpdateType.MODIFIED_FILE_APPENDED, Optional.empty(), Optional.empty(), Optional.of(modifiedFile), Optional.empty());
    }

    public static ProgressUpdate migrationStatusChanged(MigrationAttempt.Status status) {
        return new ProgressUpdate(UpdateType.MIGRATION_STATUS_CHANGED, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(status));
    }

    public UpdateType getType() {
        return this.type;
    }

    public Optional<ProgressInfo> getProgressInfo() {
        return this.progressInfo;
    }

    public Optional<String> getLogMessage() {
        return this.logMessage;
    }

    public Optional<String> getModifiedFile() {
        return this.modifiedFile;
    }

    public Optional<MigrationAttempt.Status> getMigrationStatus() {
        return this.migrationStatus;
    }

    public static class ProgressInfo {
        private int nFilesProcessed;
        private int nTotalFiles;

        public ProgressInfo(int nTotalFiles) {
            this.nTotalFiles = Math.max(nTotalFiles, 1);
            this.nFilesProcessed = 0;
        }

        public ProgressInfo increaseFilesProcessed() {
            if (this.nFilesProcessed < this.nTotalFiles) {
                ++this.nFilesProcessed;
            }
            return this;
        }

        public double getPercent() {
            return (double)this.nFilesProcessed / (double)Math.max(this.nTotalFiles, 1);
        }

        public int getnFilesProcessed() {
            return this.nFilesProcessed;
        }

        public int getnTotalFiles() {
            return this.nTotalFiles;
        }
    }

    public static enum UpdateType {
        PERCENT_CHANGED,
        LOG_APPENDED,
        MODIFIED_FILE_APPENDED,
        MIGRATION_STATUS_CHANGED;

    }
}

