/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import com.kms.katalon.migration.model.MigrationAttempt;
import com.kms.katalon.migration.model.ProgressUpdate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationAttemptLoggerFactory {
    public static final MigrationAttemptLoggerFactory singleton = new MigrationAttemptLoggerFactory();
    private final Map<String, Logger> loggerCache = new ConcurrentHashMap<String, Logger>();
    private final Map<String, Consumer<ProgressUpdate>> uiProgressConsumer = new ConcurrentHashMap<String, Consumer<ProgressUpdate>>();

    public static MigrationAttemptLoggerFactory getInstance() {
        return singleton;
    }

    public Logger getOrCreateLogger(MigrationAttempt attempt) {
        String loggerName = "MigrationAttempt-" + attempt.getAttemptId();
        return this.loggerCache.computeIfAbsent(loggerName, name -> {
            Logger logger = LoggerFactory.getLogger((String)name);
            this.configureLogger(logger, (String)name, attempt.getLogFilePath().toString());
            return logger;
        });
    }

    private void configureLogger(Logger logger, String loggerName, String logFilePath) {
        if (logger instanceof ch.qos.logback.classic.Logger) {
            ch.qos.logback.classic.Logger classicLogger = (ch.qos.logback.classic.Logger)logger;
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext((Context)classicLogger.getLoggerContext());
            encoder.setPattern("%d{yyyy-MM-dd HH:mm:ss} %-5level %logger{36} - %msg%n");
            encoder.start();
            FileAppender fileAppender = new FileAppender();
            fileAppender.setContext((Context)classicLogger.getLoggerContext());
            fileAppender.setName("FILE-" + loggerName);
            fileAppender.setFile(logFilePath);
            fileAppender.setEncoder((Encoder)encoder);
            fileAppender.start();
            classicLogger.detachAndStopAllAppenders();
            classicLogger.addAppender((Appender)fileAppender);
            classicLogger.setAdditive(false);
        }
    }

    public void attachUILogConsumer(Logger logger, final Consumer<ProgressUpdate> progressConsumer) {
        if (this.uiProgressConsumer.containsKey(logger.getName()) && this.uiProgressConsumer.get(logger.getName()) == progressConsumer) {
            return;
        }
        if (logger instanceof ch.qos.logback.classic.Logger) {
            ch.qos.logback.classic.Logger classicLogger = (ch.qos.logback.classic.Logger)logger;
            AppenderBase<ILoggingEvent> customerAppender = new AppenderBase<ILoggingEvent>(){

                protected void append(ILoggingEvent eventObject) {
                    progressConsumer.accept(ProgressUpdate.logAppended(eventObject.getFormattedMessage()));
                }
            };
            customerAppender.setContext((Context)classicLogger.getLoggerContext());
            customerAppender.setName("UI-" + logger.getName());
            customerAppender.start();
            classicLogger.addAppender((Appender)customerAppender);
            this.uiProgressConsumer.put(logger.getName(), progressConsumer);
        }
    }

    public void detachUILogConsumer(Logger logger) {
        if (logger instanceof ch.qos.logback.classic.Logger) {
            ch.qos.logback.classic.Logger classicLogger = (ch.qos.logback.classic.Logger)logger;
            classicLogger.iteratorForAppenders().forEachRemaining(appender -> {
                if (appender.getName().startsWith("UI-")) {
                    classicLogger.detachAppender(appender);
                    appender.stop();
                }
            });
            this.uiProgressConsumer.remove(logger.getName());
        }
    }

    public void muteOpenRewriteLogger() {
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"org.openrewrite")).setLevel(Level.OFF);
    }
}

