/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service;

import com.kms.katalon.migration.model.MigrationAttempt;
import com.kms.katalon.migration.model.MigrationEntry;
import com.kms.katalon.migration.model.MigrationPlan;
import com.kms.katalon.migration.model.ProblemMarkerInfo;
import com.kms.katalon.migration.model.ProgressUpdate;
import com.kms.katalon.migration.service.GroovyErrorAnalyzer;
import com.kms.katalon.migration.service.MigrationAttemptLoggerFactory;
import com.kms.katalon.tracking.service.Trackings;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Recipe;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.internal.InMemoryLargeSourceSet;
import org.openrewrite.text.PlainText;
import org.slf4j.Logger;

public class MigrationService {
    public void dryRun(MigrationAttempt attempt, Consumer<ProgressUpdate> progressCallback) {
        SourceFile sourceFile;
        java.nio.file.Path relativeSourcePath;
        Logger logger = MigrationAttemptLoggerFactory.getInstance().getOrCreateLogger(attempt);
        this.attachUILogConsumer(progressCallback, logger);
        java.nio.file.Path projectDir = java.nio.file.Path.of(attempt.getProjectRootPath(), new String[0]);
        List<java.nio.file.Path> groovySourcePaths = this.scanGroovyFiles(projectDir, logger);
        if (groovySourcePaths == null) {
            logger.info("No source files found. Stopping migration.");
            return;
        }
        List<java.nio.file.Path> jsonPropertiesPaths = this.scanJsonPropertiesFiles(projectDir, logger);
        if (jsonPropertiesPaths == null) {
            jsonPropertiesPaths = List.of();
        }
        Boolean hasCucumberFiles = this.checkIfProjectHasCucumberFiles(projectDir, logger);
        logger.info("Collecting compilation problems before migration...");
        List<ProblemMarkerInfo> problems = this.compileAndCollectResult(attempt.getProjectNameId());
        this.writeProblemMarkersToFile(problems, attempt.getBeforeMigrationCompileResultPath().toString());
        attempt.updateProblemStatsBeforeMigration(problems);
        MigrationPlan migrationPlan = attempt.getMigrationPlan();
        Recipe groovyAstRecipe = migrationPlan.getGroovyAstRecipe();
        Recipe groovyNonAstRecipe = migrationPlan.getGroovyNonAstRecipe();
        Recipe scanningRecipe = migrationPlan.getScanningRecipe();
        Recipe jsonPropertiesRecipe = migrationPlan.getJsonPropertiesRecipe();
        List classpathEntries = List.of();
        GroovyParser groovyParser = GroovyParser.builder().logCompilationWarningsAndErrors(true).classpath(classpathEntries).build();
        ProgressUpdate.ProgressInfo progressInfo = new ProgressUpdate.ProgressInfo(groovySourcePaths.size() + jsonPropertiesPaths.size());
        ArrayList<SourceFile> parsedGroovySourceFiles = new ArrayList<SourceFile>();
        ArrayList<String> nonAstRelativePaths = new ArrayList<String>();
        logger.info("Starting scanning files...\n");
        for (java.nio.file.Path sourcePath : groovySourcePaths) {
            if (attempt.isCancelled()) {
                logger.info("Migration was cancelled by user. Skipping remaining files.");
                break;
            }
            relativeSourcePath = projectDir.relativize(sourcePath);
            InMemoryExecutionContext parseCtx = new InMemoryExecutionContext();
            try {
                InMemoryExecutionContext ctx;
                sourceFile = groovyParser.parse(List.of(sourcePath), projectDir, (ExecutionContext)parseCtx).findFirst().orElse(null);
                if (sourceFile == null) continue;
                GroovyErrorAnalyzer.ParseErrorDetails parseError = GroovyErrorAnalyzer.extractErrorInfo(sourceFile);
                if (parseError != null) {
                    logger.info(String.valueOf(relativeSourcePath) + " (non-AST). Error: " + String.valueOf(parseError));
                    nonAstRelativePaths.add(relativeSourcePath.toString());
                    try {
                        ctx = new InMemoryExecutionContext();
                        PlainText plainSourceFile = PlainText.builder().sourcePath(sourcePath).text(Files.readString(sourcePath)).build();
                        List results = groovyNonAstRecipe.run((LargeSourceSet)new InMemoryLargeSourceSet(List.of(plainSourceFile)), (ExecutionContext)ctx).getChangeset().getAllResults();
                        boolean hasChange = false;
                        for (Result result : results) {
                            if (!this.hasChanges(result)) continue;
                            hasChange = true;
                            MigrationEntry entry = attempt.addEntry(MigrationEntry.changed(sourcePath, MigrationEntry.SourceFileSyntaxType.GROOVY_NON_AST, result));
                            this.printChangedEntry(entry, logger);
                            this.updateModifiedFileAppended(relativeSourcePath.toString(), progressCallback);
                            break;
                        }
                        if (!hasChange) {
                            attempt.addEntry(MigrationEntry.unchanged(sourcePath, MigrationEntry.SourceFileSyntaxType.GROOVY_NON_AST));
                        }
                        if (attempt.isCancelled()) continue;
                        this.updateProgressPercent(progressInfo.increaseFilesProcessed(), progressCallback);
                    }
                    catch (Throwable t) {
                        logger.error(String.valueOf(relativeSourcePath) + ": got error - " + t.getMessage(), t);
                        attempt.addEntry(MigrationEntry.error(sourcePath, MigrationEntry.SourceFileSyntaxType.GROOVY_NON_AST, String.valueOf(parseError) + " | non-ast fallback failed: " + t.getMessage()));
                    }
                    continue;
                }
                logger.info(String.valueOf(relativeSourcePath) + " (AST)");
                parsedGroovySourceFiles.add(sourceFile);
                ctx = new InMemoryExecutionContext();
                List results = groovyAstRecipe.run((LargeSourceSet)new InMemoryLargeSourceSet(List.of(sourceFile)), (ExecutionContext)ctx).getChangeset().getAllResults();
                boolean hasChange = false;
                for (Result result : results) {
                    if (!this.hasChanges(result)) continue;
                    hasChange = true;
                    MigrationEntry entry = attempt.addEntry(MigrationEntry.changed(sourcePath, MigrationEntry.SourceFileSyntaxType.GROOVY_AST, result));
                    this.printChangedEntry(entry, logger);
                    this.updateModifiedFileAppended(relativeSourcePath.toString(), progressCallback);
                    break;
                }
                if (!hasChange) {
                    attempt.addEntry(MigrationEntry.unchanged(sourcePath, MigrationEntry.SourceFileSyntaxType.GROOVY_AST));
                }
                if (attempt.isCancelled()) continue;
                this.updateProgressPercent(progressInfo.increaseFilesProcessed(), progressCallback);
            }
            catch (Throwable t) {
                logger.info(String.valueOf(relativeSourcePath) + ": got error - " + t.getMessage());
                attempt.addEntry(MigrationEntry.error(sourcePath, MigrationEntry.SourceFileSyntaxType.GROOVY_AST, t.getMessage()));
            }
        }
        if (scanningRecipe != null && !parsedGroovySourceFiles.isEmpty() && !attempt.isCancelled()) {
            try {
                InMemoryExecutionContext ctx = new InMemoryExecutionContext();
                ctx.putMessage("PROJECT_HAS_CUCUMBER_FILES", (Object)hasCucumberFiles);
                List results = scanningRecipe.run((LargeSourceSet)new InMemoryLargeSourceSet(parsedGroovySourceFiles), (ExecutionContext)ctx).getChangeset().getAllResults();
                for (Result result : results) {
                    if (!this.hasChanges(result)) continue;
                    java.nio.file.Path sourcePath = projectDir.resolve(result.getAfter().getSourcePath());
                    MigrationEntry entry = attempt.addEntry(MigrationEntry.changed(sourcePath, MigrationEntry.SourceFileSyntaxType.GROOVY_AST, result));
                    this.printChangedEntry(entry, logger);
                    this.updateModifiedFileAppended(sourcePath.toString(), progressCallback);
                }
                if (!attempt.isCancelled()) {
                    this.updateProgressPercent(progressInfo.increaseFilesProcessed(), progressCallback);
                }
            }
            catch (Throwable t) {
                logger.error("Failed to run scanning recipe: " + t.getMessage());
            }
        }
        for (java.nio.file.Path sourcePath : jsonPropertiesPaths) {
            if (attempt.isCancelled()) {
                logger.info("Migration was cancelled by user. Skipping remaining files.");
                break;
            }
            relativeSourcePath = projectDir.relativize(sourcePath);
            try {
                InMemoryExecutionContext ctx = new InMemoryExecutionContext();
                sourceFile = PlainText.builder().sourcePath(sourcePath).text(Files.readString(sourcePath)).build();
                if (sourceFile == null) continue;
                List results = jsonPropertiesRecipe.run((LargeSourceSet)new InMemoryLargeSourceSet(List.of(sourceFile)), (ExecutionContext)ctx).getChangeset().getAllResults();
                boolean hasChange = false;
                for (Result result : results) {
                    if (!this.hasChanges(result)) continue;
                    hasChange = true;
                    MigrationEntry entry = attempt.addEntry(MigrationEntry.changed(sourcePath, MigrationEntry.SourceFileSyntaxType.JSON_PROPERTIES, result));
                    this.printChangedEntry(entry, logger);
                    this.updateModifiedFileAppended(relativeSourcePath.toString(), progressCallback);
                    break;
                }
                if (!hasChange) {
                    attempt.addEntry(MigrationEntry.unchanged(sourcePath, MigrationEntry.SourceFileSyntaxType.JSON_PROPERTIES));
                }
                if (attempt.isCancelled()) continue;
                this.updateProgressPercent(progressInfo.increaseFilesProcessed(), progressCallback);
            }
            catch (Throwable t) {
                logger.info(String.valueOf(relativeSourcePath) + ": got error - " + t.getMessage());
                attempt.addEntry(MigrationEntry.error(sourcePath, MigrationEntry.SourceFileSyntaxType.JSON_PROPERTIES, t.getMessage()));
            }
        }
        attempt.calculateStats();
        if (attempt.changeAndSaveStatus(MigrationAttempt.Status.DRY_RUN_COMPLETED)) {
            logger.info("\nDry run completed\n");
        }
        this.printNonAstFiles(nonAstRelativePaths, logger);
        MigrationAttemptLoggerFactory.getInstance().detachUILogConsumer(logger);
    }

    public void apply(MigrationAttempt attempt, Consumer<ProgressUpdate> progressCallback) {
        Logger logger = MigrationAttemptLoggerFactory.getInstance().getOrCreateLogger(attempt);
        this.attachUILogConsumer(progressCallback, logger);
        if (!attempt.canApply()) {
            logger.info("Cannot apply changes. Current status: " + String.valueOf((Object)attempt.getStatus()));
            return;
        }
        attempt.changeAndSaveStatus(MigrationAttempt.Status.APPLYING);
        java.nio.file.Path projectDir = java.nio.file.Path.of(attempt.getProjectRootPath(), new String[0]);
        String diffOutputFilePath = attempt.getDiffFilePath().toString();
        boolean applyFailed = false;
        Object applyFailedReason = "";
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (BufferedWriter diffWriter = new BufferedWriter(new FileWriter(diffOutputFilePath, true));){
                for (MigrationEntry entry : attempt.getEntries()) {
                    if (entry.getStatus() != MigrationEntry.Status.CHANGED || entry.getRawResult() == null) continue;
                    try {
                        SourceFile sourceFile = entry.getRawResult().getAfter();
                        java.nio.file.Path sourceFilePath = projectDir.resolve(sourceFile.getSourcePath());
                        java.nio.file.Path relativeSourcePath = projectDir.relativize(sourceFilePath);
                        try {
                            this.backupFileIfNecessary(sourceFilePath, projectDir, attempt.getBackupPath());
                        }
                        catch (Exception e) {
                            applyFailed = true;
                            applyFailedReason = "Failed to backup original file: " + String.valueOf(relativeSourcePath) + ". Error: " + e.getMessage();
                            logger.error((String)applyFailedReason, (Throwable)e);
                            break;
                        }
                        String afterContent = sourceFile.printAll();
                        this.writeFileAtomically(sourceFilePath, afterContent);
                        this.refreshEclipseResources(sourceFilePath);
                        if (entry.isNewlyAdded()) {
                            logger.info("Created new file: " + String.valueOf(relativeSourcePath));
                        } else {
                            logger.info("Applied changes to: " + String.valueOf(relativeSourcePath));
                        }
                        this.safelyAppendDiff(diffWriter, entry);
                    }
                    catch (Exception e) {
                        logger.error("Failed to apply changes to: " + String.valueOf(entry.getFilePath()) + ". Error: " + e.getMessage());
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error("Failed to open diff file for writing: " + diffOutputFilePath + ". Error: " + e.getMessage());
        }
        if (!applyFailed) {
            if (attempt.changeAndSaveStatus(MigrationAttempt.Status.APPLIED)) {
                progressCallback.accept(ProgressUpdate.migrationStatusChanged(MigrationAttempt.Status.APPLIED));
                logger.info("Collecting compilation problems after migration...");
                List<ProblemMarkerInfo> problems = this.compileAndCollectResult(attempt.getProjectNameId());
                this.writeProblemMarkersToFile(problems, attempt.getAfterMigrationCompileResultPath().toString());
                attempt.updateProblemStatsAfterMigration(problems);
                this.printMigrationStats(attempt, logger);
                MigrationAttempt.Stats stats = attempt.getStats();
                if (stats != null) {
                    Trackings.trackAutoMigrateCompleted((boolean)true, stats.toTrackingProps());
                }
            }
        } else if (attempt.changeAndSaveStatus(MigrationAttempt.Status.APPLY_FAILED)) {
            attempt.setErrorMessage((String)applyFailedReason);
            progressCallback.accept(ProgressUpdate.migrationStatusChanged(MigrationAttempt.Status.APPLY_FAILED));
            MigrationAttempt.Stats stats = attempt.getStats();
            if (stats != null) {
                Trackings.trackAutoMigrateCompleted((boolean)false, stats.toTrackingProps());
            }
        }
        logger.info("Log files and diff files are saved in: " + String.valueOf(attempt.getMigrationAttemptDirPath()));
        logger.info("Please send those files to Katalon support team for further assistance.");
        MigrationAttemptLoggerFactory.getInstance().detachUILogConsumer(logger);
    }

    public void revert(MigrationAttempt attempt, Consumer<ProgressUpdate> progressCallback) {
        Logger logger = MigrationAttemptLoggerFactory.getInstance().getOrCreateLogger(attempt);
        this.attachUILogConsumer(progressCallback, logger);
        if (!attempt.canRevert()) {
            logger.info("Cannot revert changes. Current status: " + String.valueOf((Object)attempt.getStatus()));
            return;
        }
        logger.info("\nReverting changes for project: " + attempt.getProjectRootPath() + "\n");
        java.nio.file.Path projectDir = java.nio.file.Path.of(attempt.getProjectRootPath(), new String[0]);
        java.nio.file.Path backupDir = attempt.getBackupPath();
        try {
            List backupFilePaths = Files.walk(backupDir, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).collect(Collectors.toList());
            for (java.nio.file.Path backupFilePath : backupFilePaths) {
                java.nio.file.Path relativePath = backupDir.relativize(backupFilePath);
                java.nio.file.Path originalFilePath = projectDir.resolve(relativePath);
                Files.createDirectories(originalFilePath.getParent(), new FileAttribute[0]);
                Files.copy(backupFilePath, originalFilePath, StandardCopyOption.REPLACE_EXISTING);
                this.refreshEclipseResources(originalFilePath);
                logger.info("Restored file from backup: " + String.valueOf(relativePath));
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            logger.info("No changed files to revert");
            return;
        }
        catch (Throwable t) {
            logger.error("Failed to revert changes from backup. Error: " + t.getMessage());
            return;
        }
        if (attempt.changeAndSaveStatus(MigrationAttempt.Status.REVERTED)) {
            logger.info("\nRevert completed\n");
            progressCallback.accept(ProgressUpdate.migrationStatusChanged(MigrationAttempt.Status.REVERTED));
            MigrationAttempt.Stats stats = attempt.getStats();
            if (stats != null) {
                Trackings.trackAutoMigrateReverted((int)stats.getTotalFileChanges());
            }
        }
        MigrationAttemptLoggerFactory.getInstance().detachUILogConsumer(logger);
    }

    public void cancel(MigrationAttempt attempt, Consumer<ProgressUpdate> progressCallback) {
        if (attempt.isCancelled()) {
            return;
        }
        if (attempt.changeAndSaveStatus(MigrationAttempt.Status.CANCELLED)) {
            progressCallback.accept(ProgressUpdate.migrationStatusChanged(MigrationAttempt.Status.CANCELLED));
            MigrationAttempt.Stats stats = attempt.getStats();
            if (stats != null) {
                Trackings.trackAutoMigrateCancelled(stats.toTrackingProps());
            }
        }
    }

    private void printChangedEntry(MigrationEntry entry, Logger logger) {
        logger.info("Recipes applied \u2705");
        try {
            for (String recipeName : entry.getModifiedByRecipeNames()) {
                logger.info("- " + recipeName);
            }
        }
        catch (Exception e) {
            logger.error("Failed to get recipe list: " + e.getMessage(), (Throwable)e);
        }
        logger.info("");
    }

    private void printNonAstFiles(List<String> nonAstRelativePaths, Logger logger) {
        if (nonAstRelativePaths.isEmpty()) {
            return;
        }
        logger.info("\n==== Files with parse errors (non-AST) ====");
        for (String path : nonAstRelativePaths) {
            logger.info(path);
        }
        logger.info("===========================================\n");
    }

    private void printMigrationStats(MigrationAttempt attempt, Logger logger) {
        MigrationAttempt.Stats stats = attempt.getStats();
        if (stats == null) {
            logger.info("No migration stats available.");
            return;
        }
        logger.info("\n==== Migration Stats ====");
        logger.info("Groovy (AST) files: " + stats.getNumGroovyAstFiles());
        logger.info("Groovy (non-AST) files: " + stats.getNumGroovyNonAstFiles());
        logger.info("JSON properties files: " + stats.getNumJsonPropertiesFiles());
        logger.info("Groovy (AST) file changes: " + stats.getNumGroovyAstFileChanges());
        logger.info("Groovy (non-AST) file changes: " + stats.getNumGroovyNonAstFileChanges());
        logger.info("JSON properties file changes: " + stats.getNumJsonPropertiesFileChanges());
        logger.info("Problems before migration: ERROR=" + stats.getNumProblemsErrorBefore() + ", WARNING=" + stats.getNumProblemsWarningBefore());
        logger.info("Problems after migration: ERROR=" + stats.getNumProblemsErrorAfter() + ", WARNING=" + stats.getNumProblemsWarningAfter());
        logger.info("=========================\n");
    }

    private void backupFileIfNecessary(java.nio.file.Path originalFilePath, java.nio.file.Path projectRoot, java.nio.file.Path backupDir) throws IOException {
        if (!Files.exists(originalFilePath, new LinkOption[0])) {
            return;
        }
        java.nio.file.Path relativePath = projectRoot.relativize(originalFilePath);
        java.nio.file.Path backupPath = backupDir.resolve(relativePath);
        Files.createDirectories(backupPath.getParent(), new FileAttribute[0]);
        Files.copy(originalFilePath, backupPath, StandardCopyOption.REPLACE_EXISTING);
    }

    private void safelyAppendDiff(BufferedWriter writer, MigrationEntry entry) {
        if (writer == null || entry == null) {
            return;
        }
        String diff = entry.getDiffContent();
        if (diff == null || diff.isEmpty()) {
            return;
        }
        try {
            writer.write(diff);
            writer.write("\n\n");
        }
        catch (Exception exception) {}
    }

    private void writeFileAtomically(java.nio.file.Path filePath, String content) throws IOException {
        java.nio.file.Path tempFilePath = filePath.resolveSibling(filePath.getFileName().toString() + ".tmp");
        try {
            Files.writeString(tempFilePath, (CharSequence)content, new OpenOption[0]);
            Files.move(tempFilePath, filePath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tempFilePath);
        }
    }

    private void refreshEclipseResources(java.nio.file.Path filePath) {
        try {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filePath.toString()));
            if (file != null && file.exists()) {
                file.refreshLocal(0, null);
                if (file.getParent() != null) {
                    file.getParent().refreshLocal(0, null);
                }
            }
        }
        catch (Exception exception) {}
    }

    private boolean hasChanges(Result result) {
        if (result == null) {
            return false;
        }
        if (result.getBefore() == null && result.getAfter() == null) {
            return false;
        }
        if (result.getBefore() == null && result.getAfter() != null) {
            return true;
        }
        if (result.getBefore() != null && result.getAfter() == null) {
            return true;
        }
        return !result.getBefore().printAll().equals(result.getAfter().printAll());
    }

    private void attachUILogConsumer(Consumer<ProgressUpdate> progressCallback, Logger logger) {
        if (progressCallback != null) {
            MigrationAttemptLoggerFactory.getInstance().attachUILogConsumer(logger, progressCallback);
        }
    }

    private List<java.nio.file.Path> scanGroovyFiles(java.nio.file.Path projectDir, Logger logger) {
        try {
            List<java.nio.file.Path> sourcePaths = Files.find(projectDir, 999, (p, bfa) -> bfa.isRegularFile() && p.getFileName().toString().endsWith(".groovy"), new FileVisitOption[0]).collect(Collectors.toList());
            logger.info("Found " + sourcePaths.size() + " groovy source files in project: " + String.valueOf(projectDir) + "\n");
            return sourcePaths;
        }
        catch (IOException e) {
            logger.error("Failed to scan files in project: " + String.valueOf(projectDir) + ". Error: " + e.getMessage());
            return null;
        }
    }

    private List<java.nio.file.Path> scanJsonPropertiesFiles(java.nio.file.Path projectDir, Logger logger) {
        java.nio.file.Path settingsDir = projectDir.resolve("settings").resolve("internal");
        try {
            List<java.nio.file.Path> sourcePaths = Files.find(settingsDir, 999, (p, bfa) -> bfa.isRegularFile() && p.getFileName().toString().endsWith(".properties"), new FileVisitOption[0]).collect(Collectors.toList());
            logger.info("Found " + sourcePaths.size() + " properties files in project settings/internal: " + String.valueOf(projectDir) + "\n");
            return sourcePaths;
        }
        catch (IOException e) {
            logger.error("Failed to scan files in project: " + String.valueOf(projectDir) + ". Error: " + e.getMessage());
            return null;
        }
    }

    private Boolean checkIfProjectHasCucumberFiles(java.nio.file.Path projectDir, Logger logger) {
        try {
            boolean hasCucumberFiles = Files.find(projectDir, 999, (p, bfa) -> bfa.isRegularFile() && p.getFileName().toString().endsWith(".feature"), new FileVisitOption[0]).findFirst().isPresent();
            logger.info(hasCucumberFiles ? "Project has BDD cucumber files\n" : "Project does not have BDD cucumber files\n");
            return hasCucumberFiles;
        }
        catch (Exception e) {
            logger.error("Failed to detect if project has cucumber files or not: " + String.valueOf(projectDir) + ". Error: " + e.getMessage());
            return false;
        }
    }

    private void updateProgressPercent(ProgressUpdate.ProgressInfo progressInfo, Consumer<ProgressUpdate> progressCallback) {
        if (progressCallback != null) {
            progressCallback.accept(ProgressUpdate.percentChanged(progressInfo));
        }
    }

    private void updateModifiedFileAppended(String filePath, Consumer<ProgressUpdate> progressCallback) {
        if (progressCallback != null) {
            progressCallback.accept(ProgressUpdate.modifiedFileAppended(filePath));
        }
    }

    private List<ProblemMarkerInfo> compileAndCollectResult(String projectNameId) {
        ArrayList<ProblemMarkerInfo> markerInfos = new ArrayList<ProblemMarkerInfo>();
        try {
            IMarker[] markers;
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectNameId);
            project.refreshLocal(2, null);
            project.build(6, null);
            IMarker[] iMarkerArray = markers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                int severity = marker.getAttribute("severity", -1);
                String severityStr = switch (severity) {
                    case 2 -> "ERROR";
                    case 1 -> "WARNING";
                    default -> "INFO";
                };
                String message = marker.getAttribute("message", "");
                int lineNumber = marker.getAttribute("lineNumber", -1);
                String filePath = marker.getResource().getFullPath().toString();
                markerInfos.add(new ProblemMarkerInfo(message, lineNumber, filePath, severityStr));
                ++n2;
            }
        }
        catch (Exception exception) {}
        return markerInfos;
    }

    private void writeProblemMarkersToFile(List<ProblemMarkerInfo> markerInfos, String outputFilePath) {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFilePath));){
                for (ProblemMarkerInfo markerInfo : markerInfos) {
                    writer.write(markerInfo.toString());
                    writer.newLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }
}

