/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service.recipes.ks9to10;

import com.kms.katalon.migration.service.AstRecipeHelper;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;

public class AddInteractsWithApps
extends Recipe {
    public String getDisplayName() {
        return "Add InteractsWithApps cast appium driver";
    }

    public String getDescription() {
        return "Migrates AppiumDriver.activateApp() and terminateApp() calls to use InteractsWithApps interface casting";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GroovyIsoVisitor<ExecutionContext>(){
            private final Map<String, JavaTemplate> templates = Map.of("activateApp", JavaTemplate.builder((String)"((InteractsWithApps) #{}).activateApp(#{any()})").build(), "terminateApp", JavaTemplate.builder((String)"((InteractsWithApps) #{}).terminateApp(#{any()})").build());

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation methodCall = super.visitMethodInvocation(method, (Object)ctx);
                JavaTemplate template = this.templates.get(methodCall.getSimpleName());
                if (template != null) {
                    String varName = AstRecipeHelper.getVariableName(methodCall);
                    if (varName == null || methodCall.getArguments().isEmpty()) {
                        return methodCall;
                    }
                    if (this.alreadyCastedToInteractsWithApps((J)methodCall.getSelect())) {
                        return methodCall;
                    }
                    if (AstRecipeHelper.isMethodSelectAppiumDriver(methodCall)) {
                        this.doAfterVisit((TreeVisitor)new AddImport("io.appium.java_client.InteractsWithApps", null, false));
                        return (J.MethodInvocation)template.apply(this.getCursor(), methodCall.getCoordinates().replace(), new Object[]{varName, methodCall.getArguments().get(0)});
                    }
                }
                return methodCall;
            }

            private boolean alreadyCastedToInteractsWithApps(J j) {
                J.TypeCast typeCast;
                J.Parentheses paren;
                J j2;
                return j instanceof J.Parentheses && (j2 = (paren = (J.Parentheses)j).getTree()) instanceof J.TypeCast && (typeCast = (J.TypeCast)j2).getClazz().getType() != null && typeCast.getClazz().getType().toString().contains("InteractsWithApps");
            }
        };
    }
}

