/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service.recipes.ks9to10.touchaction;

import com.kms.katalon.migration.service.AstRecipeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class TouchActionHelper {
    public static ActionStep parseActionStep(J.MethodInvocation mi) {
        J.MethodInvocation waitOptionsCall;
        J.MethodInvocation pointCall;
        Expression expression;
        ActionType type;
        String methodName;
        switch (methodName = mi.getSimpleName()) {
            case "press": {
                ActionType actionType = ActionType.PRESS;
                break;
            }
            case "moveTo": {
                ActionType actionType = ActionType.MOVE_TO;
                break;
            }
            case "tap": {
                ActionType actionType = ActionType.TAP;
                break;
            }
            case "longPress": {
                ActionType actionType = ActionType.LONG_PRESS;
                break;
            }
            case "waitAction": {
                ActionType actionType = ActionType.WAIT_ACTION;
                break;
            }
            case "release": {
                ActionType actionType = ActionType.RELEASE;
                break;
            }
            default: {
                ActionType actionType = type = null;
            }
        }
        if (type == null) {
            return null;
        }
        if ((type == ActionType.PRESS || type == ActionType.MOVE_TO || type == ActionType.TAP || type == ActionType.LONG_PRESS) && mi.getArguments().size() >= 1 && (expression = (Expression)mi.getArguments().get(0)) instanceof J.MethodInvocation && "point".equals((pointCall = (J.MethodInvocation)expression).getSimpleName()) && pointCall.getArguments().size() == 2) {
            Expression x = (Expression)pointCall.getArguments().get(0);
            Expression y = (Expression)pointCall.getArguments().get(1);
            Expression duration = null;
            if (type == ActionType.LONG_PRESS && mi.getArguments().size() == 2) {
                J.MethodInvocation durationOfMillisCall;
                Expression durationArg = (Expression)mi.getArguments().get(1);
                duration = durationArg instanceof J.MethodInvocation && "ofMillis".equals((durationOfMillisCall = (J.MethodInvocation)durationArg).getSimpleName()) && durationOfMillisCall.getArguments().size() == 1 ? (Expression)durationOfMillisCall.getArguments().get(0) : durationArg;
            }
            return new ActionStep(type, x, y, duration);
        }
        if (type == ActionType.WAIT_ACTION && mi.getArguments().size() == 1 && (expression = (Expression)mi.getArguments().get(0)) instanceof J.MethodInvocation && "waitOptions".equals((waitOptionsCall = (J.MethodInvocation)expression).getSimpleName()) && waitOptionsCall.getArguments().size() == 1) {
            J.MethodInvocation durationOfMillisCall;
            Expression duration = null;
            Expression durationArg = (Expression)waitOptionsCall.getArguments().get(0);
            duration = durationArg instanceof J.MethodInvocation && "ofMillis".equals((durationOfMillisCall = (J.MethodInvocation)durationArg).getSimpleName()) && durationOfMillisCall.getArguments().size() == 1 ? (Expression)durationOfMillisCall.getArguments().get(0) : durationArg;
            return new ActionStep(type, null, null, duration);
        }
        if (type == ActionType.RELEASE && AstRecipeHelper.hasNoRealArguments(mi.getArguments())) {
            return new ActionStep(type, null, null, null);
        }
        return null;
    }

    public static ChainParseResult parseActionChainFromPerformCall(J.MethodInvocation performCall, J containingAstNode, ExecutionContext ctx) {
        ChainParseResult result = new ChainParseResult();
        Expression currentSelect = performCall.getSelect();
        J.NewClass touchActionNewClass = null;
        while (currentSelect != null) {
            J.VariableDeclarations.NamedVariable declaration;
            J.Identifier identifier;
            if (currentSelect instanceof J.MethodInvocation) {
                J.MethodInvocation mi = (J.MethodInvocation)currentSelect;
                ActionStep step = TouchActionHelper.parseActionStep(mi);
                if (step != null) {
                    result.actionSteps.add(step);
                }
                currentSelect = mi.getSelect();
                continue;
            }
            if (currentSelect instanceof J.NewClass) {
                J.NewClass nc = (J.NewClass)currentSelect;
                if (!AstRecipeHelper.isNewClassEqual(nc, "TouchAction") || nc.getArguments().size() != 1) break;
                Expression driverArg = (Expression)nc.getArguments().get(0);
                result.driverVar = AstRecipeHelper.buildStringFromExpression(driverArg);
                touchActionNewClass = nc;
                break;
            }
            if (!(currentSelect instanceof J.Identifier) || !AstRecipeHelper.doesVariableTypeContain(identifier = (J.Identifier)currentSelect, "TouchAction") || (declaration = TouchActionHelper.findVariableDeclaration(identifier.getSimpleName(), containingAstNode, ctx)) == null || declaration.getInitializer() == null) break;
            currentSelect = declaration.getInitializer();
        }
        result.valid = touchActionNewClass != null;
        Collections.reverse(result.actionSteps);
        return result;
    }

    public static ChainParseResult parseActionChainFromActionVar(String actionVar, J container, ExecutionContext ctx) {
        List list;
        J.NewClass nc;
        ChainParseResult result = new ChainParseResult();
        result.actionVar = actionVar;
        J.VariableDeclarations.NamedVariable decl = TouchActionHelper.findVariableDeclaration(actionVar, container, ctx);
        if (decl == null) {
            result.valid = false;
            return result;
        }
        result.driverVar = null;
        ArrayList<ActionStep> actionStepsPhase1 = new ArrayList<ActionStep>();
        Expression initializer = decl.getInitializer();
        while (initializer instanceof J.MethodInvocation) {
            J.MethodInvocation mi = (J.MethodInvocation)initializer;
            ActionStep step = TouchActionHelper.parseActionStep(mi);
            if (step != null) {
                actionStepsPhase1.add(step);
            }
            initializer = mi.getSelect();
        }
        if (initializer instanceof J.NewClass && AstRecipeHelper.isNewClassEqual(nc = (J.NewClass)initializer, "TouchAction") && nc.getArguments().size() == 1) {
            Expression driverArg = (Expression)nc.getArguments().get(0);
            result.driverVar = AstRecipeHelper.buildStringFromExpression(driverArg);
        }
        ArrayList<ActionStep> steps = new ArrayList<ActionStep>();
        Collections.reverse(actionStepsPhase1);
        steps.addAll(actionStepsPhase1);
        if (container instanceof G.CompilationUnit) {
            G.CompilationUnit cu = (G.CompilationUnit)container;
            list = cu.getStatements();
        } else if (container instanceof J.Block) {
            J.Block block = (J.Block)container;
            list = block.getStatements();
        } else {
            list = List.of();
        }
        List statements = list;
        for (Statement st : statements) {
            J.Identifier id;
            if (!(st instanceof J.MethodInvocation)) continue;
            J.MethodInvocation mi = (J.MethodInvocation)st;
            ArrayList<J.MethodInvocation> chain = new ArrayList<J.MethodInvocation>();
            J.MethodInvocation current = mi;
            Expression select = current.getSelect();
            chain.add(current);
            while (select instanceof J.MethodInvocation) {
                J.MethodInvocation nextMi = (J.MethodInvocation)select;
                chain.add(nextMi);
                current = nextMi;
                select = current.getSelect();
            }
            if (!(select instanceof J.Identifier) || !actionVar.equals((id = (J.Identifier)select).getSimpleName())) continue;
            Collections.reverse(chain);
            for (J.MethodInvocation stepMi : chain) {
                ActionStep step = TouchActionHelper.parseActionStep(stepMi);
                if (step == null) continue;
                steps.add(step);
            }
        }
        result.actionSteps = steps;
        result.valid = decl != null && !steps.isEmpty();
        return result;
    }

    private static String buildDurationOfMillis(List<String> accumulatedDurations) {
        if (accumulatedDurations.isEmpty()) {
            return "0";
        }
        return String.join((CharSequence)" + ", accumulatedDurations);
    }

    public static String buildSequenceStatement(String fingerVarName, String sequenceVarName, List<ActionStep> actionSteps) {
        StringBuilder setup = new StringBuilder("\n");
        setup.append(String.format("PointerInput %s = new PointerInput(PointerInput.Kind.TOUCH, \"finger\");\n", fingerVarName));
        setup.append(String.format("Sequence %s = new Sequence(%s, 2);\n", sequenceVarName, fingerVarName));
        ArrayList<String> accumulatedDurations = new ArrayList<String>();
        for (ActionStep step : actionSteps) {
            switch (step.type) {
                case PRESS: {
                    setup.append(String.format("%s.addAction(%s.createPointerMove(Duration.ofMillis(%s), PointerInput.Origin.viewport(), %s, %s));\n", sequenceVarName, fingerVarName, TouchActionHelper.buildDurationOfMillis(accumulatedDurations), step.x, step.y));
                    accumulatedDurations.clear();
                    setup.append(String.format("%s.addAction(%s.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));\n", sequenceVarName, fingerVarName));
                    break;
                }
                case WAIT_ACTION: {
                    if (step.duration == null) break;
                    accumulatedDurations.add(step.duration.toString());
                    break;
                }
                case MOVE_TO: {
                    setup.append(String.format("%s.addAction(%s.createPointerMove(Duration.ofMillis(%s), PointerInput.Origin.viewport(), %s, %s));\n", sequenceVarName, fingerVarName, TouchActionHelper.buildDurationOfMillis(accumulatedDurations), step.x, step.y));
                    accumulatedDurations.clear();
                    break;
                }
                case RELEASE: {
                    if (accumulatedDurations.size() > 0) {
                        setup.append(String.format("%s.addAction(new Pause(%s, Duration.ofMillis(%s)));\n", sequenceVarName, fingerVarName, TouchActionHelper.buildDurationOfMillis(accumulatedDurations)));
                    }
                    accumulatedDurations.clear();
                    setup.append(String.format("%s.addAction(%s.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));\n", sequenceVarName, fingerVarName));
                    break;
                }
                case LONG_PRESS: {
                    setup.append(String.format("%s.addAction(%s.createPointerMove(Duration.ofMillis(%s), PointerInput.Origin.viewport(), %s, %s));\n", sequenceVarName, fingerVarName, TouchActionHelper.buildDurationOfMillis(accumulatedDurations), step.x, step.y));
                    accumulatedDurations.clear();
                    setup.append(String.format("%s.addAction(%s.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));\n", sequenceVarName, fingerVarName));
                    String longPressDuration = step.duration != null ? step.duration.toString() : "1000";
                    setup.append(String.format("%s.addAction(new Pause(%s, Duration.ofMillis(%s)));\n", sequenceVarName, fingerVarName, longPressDuration));
                    setup.append(String.format("%s.addAction(%s.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));\n", sequenceVarName, fingerVarName));
                    break;
                }
                case TAP: {
                    setup.append(String.format("%s.addAction(%s.createPointerMove(Duration.ofMillis(%s), PointerInput.Origin.viewport(), %s, %s));\n", sequenceVarName, fingerVarName, TouchActionHelper.buildDurationOfMillis(accumulatedDurations), step.x, step.y));
                    accumulatedDurations.clear();
                    setup.append(String.format("%s.addAction(%s.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));\n", sequenceVarName, fingerVarName));
                    setup.append(String.format("%s.addAction(new Pause(%s, Duration.ofMillis(50L)));\n", sequenceVarName, fingerVarName));
                    setup.append(String.format("%s.addAction(%s.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));\n", sequenceVarName, fingerVarName));
                }
            }
        }
        return setup.toString();
    }

    public static G.CompilationUnit adjustImports(G.CompilationUnit visitedCu) {
        Set<String> required = Set.of("org.openqa.selenium.interactions.PointerInput", "org.openqa.selenium.interactions.Sequence", "org.openqa.selenium.interactions.Pause", "java.time.Duration", "java.util.Arrays");
        Set<String> toRemove = Set.of("io.appium.java_client.MultiTouchAction", "io.appium.java_client.TouchAction", "io.appium.java_client.touch.WaitOptions", "io.appium.java_client.touch.offset.PointOption");
        return AstRecipeHelper.updateImports(visitedCu, required, toRemove);
    }

    private static J.VariableDeclarations.NamedVariable findVariableDeclaration(final String variableName, J astNode, ExecutionContext ctx) {
        final J.VariableDeclarations.NamedVariable[] declaration = new J.VariableDeclarations.NamedVariable[1];
        new GroovyVisitor<ExecutionContext>(){

            public J visitVariable(J.VariableDeclarations.NamedVariable namedVariable, ExecutionContext ec) {
                if (namedVariable.getSimpleName().equals(variableName) && namedVariable.getVariableType() != null && namedVariable.getVariableType().toString().contains("TouchAction")) {
                    declaration[0] = namedVariable;
                    return namedVariable;
                }
                return super.visitVariable(namedVariable, (Object)ec);
            }
        }.visit((Tree)astNode, (Object)ctx);
        return declaration[0];
    }

    public static class ActionStep {
        ActionType type;
        Expression x;
        Expression y;
        Expression duration;

        ActionStep(ActionType type, Expression x, Expression y, Expression duration) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.duration = duration;
        }
    }

    public static enum ActionType {
        PRESS,
        MOVE_TO,
        WAIT_ACTION,
        RELEASE,
        LONG_PRESS,
        TAP;

    }

    public static class ChainParseResult {
        boolean valid;
        String driverVar;
        String actionVar;
        List<ActionStep> actionSteps = new ArrayList<ActionStep>();
    }
}

