/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.keyword;

import com.kms.katalon.core.annotation.Keyword;
import com.kms.katalon.custom.keyword.KeywordParameter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public class KeywordMethod {
    private static final String CLASS_FILE_EXTENSION = ".class";
    private String name;
    private KeywordParameter[] parameters;
    private Class<?> returnType = Void.TYPE;
    private Keyword keywordAnnotation;

    public KeywordMethod(Method method) {
        this.name = method.getName();
        this.keywordAnnotation = method.getAnnotation(Keyword.class);
        this.returnType = method.getReturnType();
        this.getParameterNameAndType(method);
    }

    private void getParameterNameAndType(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        InputStream is = clazz.getClassLoader().getResourceAsStream(Type.getType(clazz).getInternalName() + CLASS_FILE_EXTENSION);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = null;
        try {
            classReader = new ClassReader(is);
        }
        catch (IOException iOException) {}
        if (classReader == null) {
            return;
        }
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode node : classNode.methods) {
            if (!node.name.equals(method.getName()) || !Type.getMethodDescriptor((Method)method).equals(node.desc)) continue;
            this.parameters = new KeywordParameter[method.getParameterTypes().length];
            List localVariables = node.localVariables;
            Collections.sort(localVariables, new Comparator<LocalVariableNode>(){

                @Override
                public int compare(LocalVariableNode arg0, LocalVariableNode arg1) {
                    if (arg0 != null && arg1 != null) {
                        return arg0.index - arg1.index;
                    }
                    return 0;
                }
            });
            int i = 0;
            while (i < method.getParameterTypes().length) {
                LocalVariableNode localVariableNode = (LocalVariableNode)localVariables.get(i);
                this.parameters[i] = new KeywordParameter(localVariableNode.name, method.getParameterTypes()[i].isPrimitive() ? ClassUtils.primitiveToWrapper(method.getParameterTypes()[i]) : method.getParameterTypes()[i]);
                ++i;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public KeywordParameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(KeywordParameter[] paramters) {
        this.parameters = paramters;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public Keyword getKeywordAnnotation() {
        return this.keywordAnnotation;
    }

    public void setKeywordAnnotation(Keyword keywordAnnotation) {
        this.keywordAnnotation = keywordAnnotation;
    }

    public boolean checkParametersAssignable(String[] paramTypes) {
        int i = 0;
        while (i < this.getParameters().length) {
            if (!Object.class.getName().equals(paramTypes[i]) && !this.getParameters()[i].isClassAssignable(paramTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

