/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.application;

import com.katalon.capability.constant.DriverType;
import com.katalon.capability.exception.MismatchCapabilityTypeException;
import com.katalon.recorder.core.constant.KeywordPlatform;
import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.core.constant.RecordingConnectionStatus;
import com.katalon.recorder.core.constant.WebRecorderEngineType;
import com.katalon.recorder.core.domain.exception.TestCaseException;
import com.katalon.recorder.core.domain.manager.ITestCaseManager;
import com.katalon.recorder.core.domain.model.BuiltinKeywordRef;
import com.katalon.recorder.core.domain.model.IKeywordDefinition;
import com.katalon.recorder.core.domain.model.IKeywordRef;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.IVariable;
import com.katalon.recorder.core.domain.model.KeywordDefinition;
import com.katalon.recorder.core.domain.model.KeywordStep;
import com.katalon.recorder.web.application.IWebRecorderSessionContext;
import com.katalon.recorder.web.application.event.IWebViewUpdateEventBus;
import com.katalon.recorder.web.application.event.WebViewModelAddStepEvent;
import com.katalon.recorder.web.application.event.WebViewModelUpdateCapturedObjectsEvent;
import com.katalon.recorder.web.application.event.WebViewModelUpdateLastStepEvent;
import com.katalon.recorder.web.application.event.WebViewModelUpdateRecordingConnectionsEvent;
import com.katalon.recorder.web.application.event.WebViewModelUpdateRecordingStatusEvent;
import com.katalon.recorder.web.application.event.WebViewModelUpdateStepsEvent;
import com.katalon.recorder.web.application.event.WebViewModelUpdateVariablesEvent;
import com.katalon.recorder.web.application.event.WebViewRunningLogsUpdateRunningStatusEvent;
import com.katalon.recorder.web.application.event.WebViewShowErrorDialogEvent;
import com.katalon.recorder.web.application.event.WebViewShowHighlightElementInfoEvent;
import com.katalon.recorder.web.application.event.WebViewShowTakeScreenshotElementInfoEvent;
import com.katalon.recorder.web.application.event.WebViewUpdateEvent;
import com.katalon.recorder.web.constant.StepAddingBehavior;
import com.katalon.recorder.web.constant.WebRecorderEngine;
import com.katalon.recorder.web.constant.WebRecorderEngineMessageType;
import com.katalon.recorder.web.constant.WebRecordingStatus;
import com.katalon.recorder.web.domain.event.IWebDriverConnectionEventBus;
import com.katalon.recorder.web.domain.event.IWebRecordingConnectionEventBus;
import com.katalon.recorder.web.domain.event.WebDriverOpenConnectionExceptionEvent;
import com.katalon.recorder.web.domain.event.WebRecordingConnectionClosedEvent;
import com.katalon.recorder.web.domain.event.WebRecordingConnectionErrorOccurredEvent;
import com.katalon.recorder.web.domain.event.WebRecordingConnectionOpenedEvent;
import com.katalon.recorder.web.domain.event.WebRecordingMessageReceivedEvent;
import com.katalon.recorder.web.domain.exception.ExtensionNotFoundException;
import com.katalon.recorder.web.domain.exception.LoadExtensionFileException;
import com.katalon.recorder.web.domain.exception.UnsupportedDriverTypeException;
import com.katalon.recorder.web.domain.exception.WebDriverCreationException;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionClosedException;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionMessageParsingException;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionNotFoundException;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionSendMessageException;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionStatusMismatchException;
import com.katalon.recorder.web.domain.exception.WebRecordingNoTestObjectException;
import com.katalon.recorder.web.domain.exception.WebRecordingRunStepsException;
import com.katalon.recorder.web.domain.exception.WriteRecordingRequestException;
import com.katalon.recorder.web.domain.manager.IWebCapturedObjectManager;
import com.katalon.recorder.web.domain.manager.IWebCapturedStepManager;
import com.katalon.recorder.web.domain.manager.IWebDriverManager;
import com.katalon.recorder.web.domain.manager.IWebRecorderEngineManager;
import com.katalon.recorder.web.domain.manager.IWebRecorderSettingManager;
import com.katalon.recorder.web.domain.manager.IWebRecordingConnectionManager;
import com.katalon.recorder.web.domain.manager.IWebRecordingRequestManager;
import com.katalon.recorder.web.domain.manager.IWebRecordingSessionManager;
import com.katalon.recorder.web.domain.model.HeartbeatInfo;
import com.katalon.recorder.web.domain.model.HighlightElementInfo;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.katalon.recorder.web.domain.model.IWebDriverConnection;
import com.katalon.recorder.web.domain.model.IWebRecorderSetting;
import com.katalon.recorder.web.domain.model.IWebRecordingConnection;
import com.katalon.recorder.web.domain.model.IWebRecordingConnectionMetadata;
import com.katalon.recorder.web.domain.model.IWebRecordingSession;
import com.katalon.recorder.web.domain.model.IWebTestDesignSetting;
import com.katalon.recorder.web.domain.model.TakeScreenshotObjectInfo;
import com.katalon.recorder.web.domain.model.WebRecordingConnection;
import com.katalon.recorder.web.domain.model.WebRecordingConnectionMetadata;
import com.katalon.recorder.web.domain.model.WebRecordingRequest;
import com.katalon.recorder.web.domain.model.WebRecordingSession;
import com.katalon.recorder.web.presentation.dto.PlayOption;
import com.kms.katalon.core.webui.common.RunningStatus;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.objectspy.util.Win32Helper;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.semver4j.Semver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class WebRecorderSessionContext
implements IWebRecorderSessionContext {
    private static final Logger logger = LoggerFactory.getLogger(WebRecorderSessionContext.class);
    private static final String ENGINE_COMPATIBLE_VERSION = "1.0.12";
    private static final String DEFAULT_STARTUP_TAB_NAME = "data:,";
    public static final int VERIFY_HIGHLIGHT_BY_EXTENSION = -1;
    public static final int TAKE_SCREENSHOT_BY_EXTENSION = -1;
    public static final String OPEN_BROWSER_KEYWORD = "openBrowser";
    private final IWebRecordingSession recordingSession = new WebRecordingSession();
    private final IWebRecordingRequestManager webRecordingRequestManager;
    private final IWebRecorderSettingManager webRecorderSettingManager;
    private final IWebRecordingConnectionManager webRecordingConnectionManager;
    private final CompositeDisposable compositeDisposable = new CompositeDisposable();
    private final IWebRecordingConnectionEventBus webRecordingConnectionEventBus;
    private final IWebViewUpdateEventBus webViewUpdateEventBus;
    private final IWebDriverManager webDriverManager;
    private final ITestCaseManager testCaseManager;
    private final IWebCapturedObjectManager capturedObjectManager;
    private final IWebDriverConnectionEventBus webDriverConnectionEventBus;
    private final IWebRecorderEngineManager webRecorderEngineManager;
    private final IWebCapturedStepManager capturedStepManager;
    private final IWebRecordingSessionManager webRecordingSessionManager;

    @Inject
    public WebRecorderSessionContext(IWebRecordingRequestManager webRecordingRequestManager, IWebRecorderSettingManager webRecorderSettingManager, IWebRecordingConnectionManager webRecordingConnectionManager, IWebRecordingConnectionEventBus webRecordingConnectionEventBus, IWebViewUpdateEventBus webViewUpdateEventBus, IWebDriverManager webDriverManager, ITestCaseManager testCaseManager, IWebCapturedObjectManager webTestObjectManager, IWebRecorderEngineManager webRecorderEngineManager, IWebDriverConnectionEventBus webDriverConnectionEventBus, IWebCapturedStepManager capturedStepManager, IWebRecordingSessionManager webRecordingSessionManager) {
        this.capturedObjectManager = webTestObjectManager;
        this.webDriverConnectionEventBus = webDriverConnectionEventBus;
        this.webRecordingRequestManager = webRecordingRequestManager;
        this.webRecorderSettingManager = webRecorderSettingManager;
        this.webRecordingConnectionManager = webRecordingConnectionManager;
        this.webRecordingConnectionEventBus = webRecordingConnectionEventBus;
        this.webViewUpdateEventBus = webViewUpdateEventBus;
        this.webDriverManager = webDriverManager;
        this.testCaseManager = testCaseManager;
        this.webRecorderEngineManager = webRecorderEngineManager;
        this.capturedStepManager = capturedStepManager;
        this.webRecordingSessionManager = webRecordingSessionManager;
    }

    public IWebRecordingSession getRecordingSession() {
        return this.recordingSession;
    }

    public void init(String testCaseId) {
        WebRecordingRequest lastRecordingRequest = this.webRecordingRequestManager.getLastRecordingRequest();
        if (lastRecordingRequest != null) {
            lastRecordingRequest.setTestCaseId(testCaseId);
            this.recordingSession.setRecordingRequest(lastRecordingRequest);
        } else {
            WebRecordingRequest initialRequest = new WebRecordingRequest(testCaseId, DriverType.CHROME_DRIVER, Boolean.valueOf(false), "", "", "");
            this.recordingSession.setRecordingRequest(initialRequest);
        }
        this.loadTestCaseContent(testCaseId);
        IWebRecorderSetting webRecorderSetting = this.webRecorderSettingManager.getWebRecorderSetting();
        this.recordingSession.setRecorderSetting(webRecorderSetting);
        try {
            IWebTestDesignSetting webTestDesignSetting = this.webRecorderSettingManager.getWebTestDesignSetting();
            this.recordingSession.setTestDesignSetting(webTestDesignSetting);
        }
        catch (IOException e) {
            logger.error("Exception when fetching web test design setting", (Throwable)e);
        }
        try {
            this.webRecordingConnectionManager.openForConnection(webRecorderSetting);
        }
        catch (Exception e) {
            logger.error("Exception when opening web recording connection", (Throwable)e);
            this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewShowErrorDialogEvent("%s%s%s".formatted("Cannot open connection for web recorder. Please check your configuration and try again.", System.lineSeparator(), e.getMessage())));
        }
        this.subscribeWebRecordingConnectionEvents();
        this.subscribeWebDriverEvents();
    }

    public void close() throws WriteRecordingRequestException {
        this.webRecordingRequestManager.saveLastRecordingRequest(this.recordingSession.getRecordingRequest());
        this.webRecordingConnectionManager.close(this.recordingSession.getRecordingConnections());
        this.webRecordingConnectionManager.closeForConnection();
        this.webDriverManager.close();
        this.compositeDisposable.dispose();
        logger.info("WebRecorderSessionContext closed");
    }

    public void switchRecordingConnection(String recordingConnectionId) throws WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        this.activateRecordingConnection(recordingConnectionId);
    }

    public void pauseRecording(String recordingConnectionId) throws WebRecordingConnectionNotFoundException, WebRecordingConnectionStatusMismatchException, WebRecordingConnectionClosedException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        try {
            IWebRecordingConnection currentActiveRecordingConnection = this.recordingSession.getActiveConnection();
            if (!Strings.CS.equals(currentActiveRecordingConnection.getRecordingConnectionId(), recordingConnectionId)) {
                throw new WebRecordingConnectionNotFoundException("Cannot pause recording connection. The connection is not active.");
            }
            if (!RecordingConnectionStatus.RECORDING.equals((Object)currentActiveRecordingConnection.getStatus())) {
                throw new WebRecordingConnectionStatusMismatchException("Cannot pause recording connection. The connection is not in recording status.");
            }
            this.webRecordingConnectionManager.pauseRecording(currentActiveRecordingConnection);
        }
        finally {
            this.emitUpdateRecordingConnectionEventToView();
        }
    }

    public void resumeRecording(String recordingConnectionId) throws WebRecordingConnectionNotFoundException, WebRecordingConnectionStatusMismatchException, WebRecordingConnectionClosedException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        try {
            IWebRecordingConnection currentActiveRecordingConnection = this.recordingSession.getActiveConnection();
            if (!Strings.CS.equals(currentActiveRecordingConnection.getRecordingConnectionId(), recordingConnectionId)) {
                throw new WebRecordingConnectionNotFoundException("Cannot resume recording connection. The connection is not active.");
            }
            if (!RecordingConnectionStatus.PAUSED.equals((Object)currentActiveRecordingConnection.getStatus())) {
                throw new WebRecordingConnectionStatusMismatchException("Cannot resume recording connection. The connection is not in recording status.");
            }
            this.webRecordingConnectionManager.startRecording(currentActiveRecordingConnection);
            currentActiveRecordingConnection.setStatus(RecordingConnectionStatus.RECORDING);
        }
        finally {
            this.emitUpdateRecordingConnectionEventToView();
        }
    }

    public void backToConfiguration() {
        try {
            this.recordingSession.setRecordingStatus(WebRecordingStatus.CONFIGURING);
        }
        finally {
            this.emitUpdateRecordingStatusEventToView();
        }
    }

    public Integer verifyAndHighlightTestObject(String capturedObjectId, LocatorType locatorType) throws WebRecordingConnectionNotFoundException, WebRecordingNoTestObjectException, WebRecordingConnectionClosedException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        IWebCapturedObject capturedObject = this.recordingSession.getCapturedObject(capturedObjectId);
        IWebRecordingConnection activeConnection = this.recordingSession.getActiveConnection();
        if (activeConnection == null) {
            throw new WebRecordingConnectionNotFoundException("No active recording connection to verify and highlight object.");
        }
        if (capturedObject == null) {
            throw new WebRecordingNoTestObjectException("Cannot find test object to verify and highlight. Captured object id: %s".formatted(capturedObjectId));
        }
        if (StringUtils.isBlank((CharSequence)capturedObject.getLocator(locatorType))) {
            return 0;
        }
        if (activeConnection.isBuiltInEngine()) {
            IWebDriverConnection webDriverConnection = this.recordingSession.getWebDriverConnection(activeConnection.getMetadata().getDriverType());
            Integer found = this.webDriverManager.verifyAndHighlightTestObject(webDriverConnection, capturedObject, locatorType);
            return found == null ? 0 : (found > 0 ? found : 0);
        }
        this.webRecordingConnectionManager.verifyAndHighlightObject(activeConnection, capturedObject, locatorType);
        return -1;
    }

    public Integer takeScreenshot(String capturedObjectId, LocatorType locatorType) throws WebRecordingConnectionNotFoundException, WebRecordingNoTestObjectException, WebRecordingConnectionClosedException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        IWebCapturedObject capturedObject = this.recordingSession.getCapturedObject(capturedObjectId);
        IWebRecordingConnection activeConnection = this.recordingSession.getActiveConnection();
        if (activeConnection == null) {
            throw new WebRecordingConnectionNotFoundException("No active recording connection to take screenshot object.");
        }
        if (capturedObject == null) {
            throw new WebRecordingNoTestObjectException("Cannot find test object to take screenshot. Captured object id: %s".formatted(capturedObjectId));
        }
        if (StringUtils.isBlank((CharSequence)capturedObject.getLocator(capturedObject.getLocatorType()))) {
            this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewShowTakeScreenshotElementInfoEvent(Boolean.valueOf(false), "Default locator is empty!"));
        }
        if (activeConnection.isBuiltInEngine()) {
            IWebDriverConnection webDriverConnection = this.recordingSession.getWebDriverConnection(activeConnection.getMetadata().getDriverType());
            Integer found = this.webDriverManager.takeScreenshot(webDriverConnection, capturedObject, locatorType);
            return found == null ? 0 : (found > 0 ? found : 0);
        }
        this.webRecordingConnectionManager.takeScreenshot(activeConnection, capturedObject, locatorType);
        return -1;
    }

    public void setDefaultLocatorForCapturedObject(String capturedObjectId, LocatorType locatorType) {
        IWebCapturedObject capturedObject = this.recordingSession.getCapturedObject(capturedObjectId);
        if (capturedObject == null) {
            logger.error("Cannot find test object to set default locator | capturedObjectId = {}", (Object)capturedObjectId);
            return;
        }
        capturedObject.setLocatorType(locatorType);
    }

    private void activateRecordingConnection(String recordingConnectionId) throws WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        try {
            IWebRecordingConnection currentRecordingConnection;
            IWebRecordingConnection found = this.recordingSession.getRecordingConnection(recordingConnectionId);
            if (found == null) {
                this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewShowErrorDialogEvent("Your selected connection is not available. Please try another one."));
            }
            if ((currentRecordingConnection = this.recordingSession.getActiveConnection()) != null) {
                this.webRecordingConnectionManager.stopRecording(currentRecordingConnection);
                currentRecordingConnection.setStatus(RecordingConnectionStatus.CONNECTED);
            }
            this.webRecordingConnectionManager.startRecording(found);
            this.recordingSession.setRecordingStatus(WebRecordingStatus.RECORDING);
        }
        finally {
            this.emitUpdateRecordingStatusEventToView();
            this.emitUpdateRecordingConnectionEventToView();
        }
    }

    public void startNewBrowserRecordingSession(WebRecordingRequest request) throws WebRecordingConnectionClosedException, WebRecordingConnectionMessageParsingException, WebRecordingConnectionSendMessageException, UnsupportedDriverTypeException, WebRecordingConnectionNotFoundException, ExtensionNotFoundException, LoadExtensionFileException, WebDriverCreationException {
        DriverType driverType = request.getDriverType();
        String profile = Optional.ofNullable(this.getRecordingSession().getRecorderSetting()).map(IWebRecorderSetting::getChromeProfile).orElse(null);
        String startupUrl = request.getStartupUrl();
        this.recordingSession.setRecordingRequest(request);
        this.recordingSession.setRecordingStatus(WebRecordingStatus.STARTING);
        this.emitUpdateRecordingStatusEventToView();
        IWebRecordingConnection currentRecordingConnection = this.recordingSession.getActiveConnection();
        if (currentRecordingConnection != null) {
            this.webRecordingConnectionManager.stopRecording(currentRecordingConnection);
        }
        IWebDriverConnection webDriverConnection = this.webDriverManager.startWebDriver(driverType, Boolean.TRUE.equals(request.getWithProfile()) ? profile : null, null, startupUrl);
        this.recordingSession.addWebDriverConnection(webDriverConnection);
        this.emitUpdateRecordingConnectionEventToView();
        this.addOpenBrowserStep();
    }

    private void addOpenBrowserStep() {
        IStep openBrowser = this.capturedStepManager.createKeywordStep(KeywordPlatform.WEB, OPEN_BROWSER_KEYWORD, Integer.valueOf(1));
        openBrowser.setArguments(Arrays.asList(""));
        this.addStep(openBrowser);
    }

    public void startActiveBrowserRecordingSession(WebRecordingRequest request) throws WebRecordingConnectionNotFoundException, WebRecordingConnectionClosedException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        this.recordingSession.setRecordingRequest(request);
        String recordingConnectionId = request.getRecordingConnectionId();
        this.activateRecordingConnection(recordingConnectionId);
        if (this.recordingSession.getSteps().stream().map(IStep::getKeywordDefinition).map(IKeywordDefinition::getKeywordRef).map(IKeywordRef::getName).noneMatch(OPEN_BROWSER_KEYWORD::equals)) {
            KeywordStep step = new KeywordStep();
            KeywordDefinition keywordDefinition = new KeywordDefinition();
            BuiltinKeywordRef keywordRef = new BuiltinKeywordRef();
            keywordRef.setPlatform(KeywordPlatform.WEB);
            keywordRef.setName(OPEN_BROWSER_KEYWORD);
            keywordDefinition.setKeywordRef((IKeywordRef)keywordRef);
            step.setKeywordDefinition((IKeywordDefinition)keywordDefinition);
            this.addStep((IStep)step);
        }
    }

    public void startCustomBrowserRecordingSession(WebRecordingRequest request) throws WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException, ExtensionNotFoundException, LoadExtensionFileException, UnsupportedDriverTypeException, WebDriverCreationException, MismatchCapabilityTypeException {
        String customCapabilityName = request.getCustomCapabilityName();
        String[] split = customCapabilityName.split(" - ", 2);
        DriverType driverType = DriverType.fromDisplayName((String)split[0]);
        this.recordingSession.setRecordingRequest(request);
        this.recordingSession.setRecordingStatus(WebRecordingStatus.STARTING);
        this.emitUpdateRecordingStatusEventToView();
        IWebRecordingConnection currentRecordingConnection = this.recordingSession.getActiveConnection();
        if (currentRecordingConnection != null) {
            this.webRecordingConnectionManager.stopRecording(currentRecordingConnection);
            currentRecordingConnection.setStatus(RecordingConnectionStatus.CONNECTED);
        }
        IWebDriverConnection webDriverConnection = this.webDriverManager.startWebDriver(driverType, null, split[1], request.getStartupUrl());
        this.recordingSession.addWebDriverConnection(webDriverConnection);
        this.emitUpdateRecordingConnectionEventToView();
        this.addOpenBrowserStep();
    }

    public void loadTestCaseContent(String testCaseId) {
        if (StringUtils.isBlank((CharSequence)testCaseId)) {
            return;
        }
        try {
            this.loadSteps(testCaseId);
        }
        catch (Exception e) {
            logger.error("Exception when loading test step from test case | testCaseId = {}", (Object)testCaseId, (Object)e);
            this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewShowErrorDialogEvent("%s%s%s".formatted("Cannot load test case to continue recording. Please check your test case and try again.", System.lineSeparator(), e.getMessage())));
        }
        try {
            List testObjects = this.capturedObjectManager.fetchTestObjectFromTestCase(testCaseId);
            this.recordingSession.setCapturedObjects(testObjects);
        }
        catch (Exception e) {
            logger.error("Exception when loading test object from test case | testCaseId = {}", (Object)testCaseId, (Object)e);
            this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewShowErrorDialogEvent("%s%s%s".formatted("Cannot load test objects from test case. Please check your test case and try again.", System.lineSeparator(), e.getMessage())));
        }
        try {
            this.loadVariables(testCaseId);
        }
        catch (Exception e) {
            logger.error("Exception when loading variables from test case | testCaseId = {}", (Object)testCaseId, (Object)e);
            this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewShowErrorDialogEvent("%s%s%s".formatted("Cannot load variables from test case. Please check your test case and try again.", System.lineSeparator(), e.getMessage())));
        }
    }

    public void updateSteps(List<IStep> steps) {
        this.recordingSession.setSteps(steps);
        this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewModelUpdateStepsEvent(steps));
    }

    public void updateVariables(List<IVariable> variables) {
        this.recordingSession.setVariables(variables);
        this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewModelUpdateVariablesEvent(variables));
    }

    public Boolean save() throws Exception {
        return this.webRecordingSessionManager.save(this.recordingSession);
    }

    public void executeSteps(PlayOption playOption, List<Integer> stepIndices) throws ExtensionNotFoundException, LoadExtensionFileException, UnsupportedDriverTypeException, WebRecordingRunStepsException, WebDriverCreationException, WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        WebRecorderEngineType engineType = Optional.ofNullable(this.recordingSession.getActiveConnection()).map(IWebRecordingConnection::getMetadata).map(IWebRecordingConnectionMetadata::getEngineType).orElse(null);
        List<IStep> selectedStepsToPlay = this.getSelectedStepsToPlay(playOption, stepIndices);
        if (WebRecorderEngineType.BUILT_IN == engineType) {
            this.webRecordingConnectionManager.pauseRecording(this.recordingSession.getActiveConnection());
        }
        this.webDriverManager.runScript(this.recordingSession, selectedStepsToPlay, this.webRecordingConnectionManager);
    }

    public void stopExecutingSteps() throws WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        this.webDriverManager.stopRunningSteps();
        this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewRunningLogsUpdateRunningStatusEvent(RunningStatus.STOP));
        WebRecorderEngineType engineType = Optional.ofNullable(this.recordingSession.getActiveConnection()).map(IWebRecordingConnection::getMetadata).map(IWebRecordingConnectionMetadata::getEngineType).orElse(null);
        if (WebRecorderEngineType.BUILT_IN == engineType) {
            this.webRecordingConnectionManager.startRecording(this.getRecordingSession().getActiveConnection());
        }
    }

    public void updateRecorderEngineSetting(boolean smartLocatorCaptureEnabledResult) throws WebRecordingConnectionClosedException, WebRecordingConnectionMessageParsingException, WebRecordingConnectionSendMessageException, WebRecordingConnectionNotFoundException {
        IWebRecordingConnection activeConnection = this.recordingSession.getActiveConnection();
        if (activeConnection == null) {
            logger.warn("No active connection to update recorder engine setting");
            return;
        }
        this.webRecordingConnectionManager.updateRecorderEngineSetting(activeConnection, smartLocatorCaptureEnabledResult);
    }

    private List<IStep> getSelectedStepsToPlay(PlayOption playOption, List<Integer> selectedStepsIndex) {
        List allSteps = this.recordingSession.getSteps();
        switch (playOption) {
            case RUN_ALL_STEPS: {
                return allSteps;
            }
            case RUN_FROM_STEP: {
                Integer fromStepIndex = selectedStepsIndex.get(0);
                return allSteps.subList(fromStepIndex, allSteps.size());
            }
            case RUN_SELECTED_STEPS: {
                ArrayList<IStep> selectedSteps = new ArrayList<IStep>();
                for (Integer index : selectedStepsIndex) {
                    selectedSteps.add((IStep)allSteps.get(index));
                }
                return selectedSteps;
            }
        }
        return null;
    }

    private void loadSteps(String testCaseId) throws TestCaseException {
        Map nodeWrapperMap = this.testCaseManager.getAstNodeWrapperAdaptersFrom(testCaseId);
        if (nodeWrapperMap.isEmpty()) {
            return;
        }
        this.recordingSession.setContinuedTestCaseNodeWrapperMap(nodeWrapperMap);
        List steps = this.testCaseManager.deserializeNodeWrapperList(new ArrayList(nodeWrapperMap.values()));
        if (steps != null) {
            this.recordingSession.setSteps(steps);
        }
    }

    private void loadVariables(String testCaseId) throws TestCaseException {
        this.recordingSession.setVariables(this.testCaseManager.getVariablesFromTestCase(testCaseId));
    }

    private void subscribeWebRecordingConnectionEvents() {
        this.compositeDisposable.add(this.webRecordingConnectionEventBus.getObservableToSubscribe(WebRecordingConnectionOpenedEvent.class).subscribe(this::handleWebRecordingConnectionOpenEvent));
        this.compositeDisposable.add(this.webRecordingConnectionEventBus.getObservableToSubscribe(WebRecordingConnectionClosedEvent.class).subscribe(event -> this.handleWebRecordingConnectionClosedEvent(event.getRecordingConnectionId())));
        this.compositeDisposable.add(this.webRecordingConnectionEventBus.getObservableToSubscribe(WebRecordingConnectionErrorOccurredEvent.class).subscribe(event -> {
            logger.info("WebRecordingConnectionErrorOccurredEvent | sessionId = {} | error = {}", (Object)event.getRecordingConnectionId(), (Object)event.getError().getMessage());
            this.handleWebRecordingConnectionClosedEvent(event.getRecordingConnectionId());
        }));
        this.compositeDisposable.add(this.webRecordingConnectionEventBus.getObservableToSubscribe(WebRecordingMessageReceivedEvent.class).subscribe(this::handleWebRecordingConnectionMessageReceivedEvent));
    }

    private void handleWebRecordingConnectionMessageReceivedEvent(WebRecordingMessageReceivedEvent event) {
        WebRecorderEngineMessageType eventType = event.getType();
        IWebRecordingConnection activeConnection = this.recordingSession.getActiveConnection();
        if (WebRecorderEngineMessageType.HEART_BEAT == eventType) {
            this.handleHeartbeatMessage(event);
            return;
        }
        if (activeConnection == null || RecordingConnectionStatus.RECORDING != activeConnection.getStatus()) {
            logger.warn("No active connection to handle message | sessionId = {} | type = {} | data = {}", new Object[]{event.getRecordingConnectionId(), eventType, event.getData()});
            return;
        }
        if (!Strings.CS.equals(activeConnection.getRecordingConnectionId(), event.getRecordingConnectionId())) {
            logger.warn("Not active connection to handle message | sessionId = {} | type = {} | data = {}", new Object[]{event.getRecordingConnectionId(), eventType, event.getData()});
            return;
        }
        switch (eventType) {
            case CAPTURE_ELEMENT: {
                break;
            }
            case CAPTURE_ACTION: {
                this.handleRecorderEngineCaptureActionMessage(event.getData());
                break;
            }
            case ELEMENT_MAP: {
                break;
            }
            case HIGHLIGHT_ELEMENT_INFO: {
                this.handleRecorderEngineHighlightElementInfoMessage(event.getData());
                break;
            }
            case SCREENSHOT_OBJECT_INFO: {
                this.handleRecorderEngineTakeScreenshotObjectInfoMessage(event.getData());
                break;
            }
            default: {
                logger.warn("Unknown message type received from recording connection | sessionId = {} | type = {} | data = {}", new Object[]{event.getRecordingConnectionId(), eventType, event.getData()});
            }
        }
    }

    private void handleHeartbeatMessage(WebRecordingMessageReceivedEvent event) {
        String recordingConnectionId = event.getRecordingConnectionId();
        String data = event.getData();
        try {
            HeartbeatInfo heartbeatInfo = this.webRecorderEngineManager.parseHeartbeatInfoFromMessage(data);
            String pageTitle = heartbeatInfo.getPageTitle();
            IWebRecordingConnection recordingConnection = this.recordingSession.getRecordingConnection(recordingConnectionId);
            if (recordingConnection == null) {
                logger.warn("No recording connection found to handle heart beat message | sessionId = {} | data = {}", (Object)recordingConnectionId, (Object)data);
                return;
            }
            try {
                WebRecorderEngineType engineType = recordingConnection.getMetadata().getEngineType();
                DriverType driverType = recordingConnection.getMetadata().getDriverType();
                pageTitle = StringUtils.isNotBlank((CharSequence)pageTitle) ? pageTitle : "%s (%s)".formatted(driverType.getDisplayName(), engineType.name().toLowerCase());
                recordingConnection.getMetadata().setPageTitle(pageTitle);
            }
            catch (Exception e) {
                logger.error("Exception when handling recorder engine heart beat message | data = {}", (Object)data, (Object)e);
            }
        }
        finally {
            this.emitUpdateRecordingConnectionEventToView();
        }
    }

    private void handleRecorderEngineTakeScreenshotObjectInfoMessage(String data) {
        try {
            TakeScreenshotObjectInfo takeScreenshotObjectInfo = this.webRecorderEngineManager.parseTakeScreenshotObjectInfoFromMessage(data);
            IWebCapturedObject capturedObject = this.recordingSession.getCapturedObject(takeScreenshotObjectInfo.getCapturedObjectId());
            Boolean result = this.capturedObjectManager.handleTakeScreenshotObjectInfo(capturedObject, takeScreenshotObjectInfo);
            this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewShowTakeScreenshotElementInfoEvent(result, null));
            this.emitUpdateCapturedObjectsEventToView();
        }
        catch (Exception e) {
            logger.error("Exception when handling recorder engine take screenshot object info message | data = {}", (Object)data, (Object)e);
            this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewShowTakeScreenshotElementInfoEvent(Boolean.valueOf(false), null));
        }
    }

    private void handleRecorderEngineHighlightElementInfoMessage(String data) {
        try {
            HighlightElementInfo highlightElementInfo = this.webRecorderEngineManager.parseHighlightElementInfoFromMessage(data);
            this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewShowHighlightElementInfoEvent(highlightElementInfo, null));
        }
        catch (Exception e) {
            logger.error("Exception when handling recorder engine highlight element info message | data = {}", (Object)data, (Object)e);
            this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewShowHighlightElementInfoEvent(null, e));
        }
    }

    private void handleRecorderEngineCaptureActionMessage(String actionJsonData) {
        try {
            List currentCapturedPages = this.recordingSession.getCapturedObjects();
            IWebCapturedObject capturedObject = this.webRecorderEngineManager.parseCapturedObjectsFromCapturedAction(currentCapturedPages, actionJsonData);
            this.emitUpdateCapturedObjectsEventToView();
            IStep capturedStep = this.webRecorderEngineManager.parseStepFromCapturedAction(actionJsonData, capturedObject);
            StepAddingBehavior behavior = this.capturedStepManager.handleAddingCapturedStep(this.recordingSession, capturedStep);
            if (Objects.requireNonNull(behavior) == StepAddingBehavior.UPDATE_LAST_STEP) {
                this.updateLastStep(capturedStep);
            } else {
                this.addStep(capturedStep);
            }
        }
        catch (Exception e) {
            logger.error("Exception when handling recorder engine capture action message | actionJsonData = {}", (Object)actionJsonData, (Object)e);
            this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewShowErrorDialogEvent("%s%s%s".formatted("Error occurred when capturing action from recorder engine.", System.lineSeparator(), e.getMessage())));
        }
    }

    private void emitUpdateCapturedObjectsEventToView() {
        this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewModelUpdateCapturedObjectsEvent(this.recordingSession.getCapturedObjects()));
    }

    private void addStep(IStep newStep) {
        this.recordingSession.addStep(newStep);
        this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewModelAddStepEvent(newStep));
    }

    private void updateLastStep(IStep updatedStep) {
        this.recordingSession.updateLastStep(updatedStep);
        this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewModelUpdateLastStepEvent(updatedStep));
    }

    private void handleWebRecordingConnectionClosedEvent(String connectionId) {
        IWebRecordingConnection oldConnection = this.recordingSession.removeConnection(connectionId);
        this.webRecordingConnectionManager.close(oldConnection);
        this.emitUpdateRecordingConnectionEventToView();
        if (oldConnection != null && oldConnection.isActive()) {
            this.recordingSession.setRecordingStatus(WebRecordingStatus.DISCONNECTED);
            this.emitUpdateRecordingStatusEventToView();
        }
    }

    private void emitUpdateRecordingStatusEventToView() {
        this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewModelUpdateRecordingStatusEvent(this.recordingSession.getRecordingStatus()));
    }

    private void emitUpdateRecordingConnectionEventToView() {
        this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewModelUpdateRecordingConnectionsEvent(this.recordingSession.getRecordingConnections()));
    }

    private void handleWebRecordingConnectionOpenEvent(WebRecordingConnectionOpenedEvent event) {
        block11: {
            try {
                logger.info("WebRecordingConnectionOpenedEvent | sessionId = {}", (Object)event.getRecordingConnectionId());
                if (event.getDriverType() == null) {
                    WebRecordingConnection connection = new WebRecordingConnection(event.getRecordingConnectionId(), (IWebRecordingConnectionMetadata)new WebRecordingConnectionMetadata(null, event.getBrowserVersion(), event.getPageTitle(), WebRecorderEngine.RECORDER_PLUS, WebRecorderEngineType.EXTENSION, event.getEngineVersion(), event.getEngineExtensionId(), false, null));
                    this.recordingSession.addWebRecordingConnection((IWebRecordingConnection)connection);
                    return;
                }
                try {
                    DriverType driverType = DriverType.valueOf((String)event.getDriverType());
                    WebRecorderEngineType engineType = WebRecorderEngineType.valueOf((String)event.getEngineType());
                    String pageTitle = event.getPageTitle();
                    if (StringUtils.isBlank((CharSequence)pageTitle) || Strings.CI.equals(pageTitle, DEFAULT_STARTUP_TAB_NAME)) {
                        pageTitle = "%s (%s)".formatted(driverType.getDisplayName(), engineType.name().toLowerCase());
                    }
                    WebRecordingConnection connection = new WebRecordingConnection(event.getRecordingConnectionId(), (IWebRecordingConnectionMetadata)new WebRecordingConnectionMetadata(driverType, event.getBrowserVersion(), pageTitle, WebRecorderEngine.valueOf((String)event.getEngine()), engineType, event.getEngineVersion(), event.getEngineExtensionId(), new Semver(event.getEngineVersion()).isGreaterThanOrEqualTo(ENGINE_COMPATIBLE_VERSION), event.getSmartLocatorCaptureEnabled()));
                    String exclusionPattern = Optional.of(this.recordingSession).map(IWebRecordingSession::getTestDesignSetting).map(IWebTestDesignSetting::getExclusionPattern).orElse(null);
                    this.webRecordingConnectionManager.injectRecorderSetting((IWebRecordingConnection)connection, exclusionPattern);
                    if (connection.isExtensionEngine()) {
                        this.recordingSession.addWebRecordingConnection((IWebRecordingConnection)connection);
                        break block11;
                    }
                    if (WebRecordingStatus.STARTING.equals((Object)this.recordingSession.getRecordingStatus())) {
                        logger.info("WebRecordingConnectionOpenedEvent | start recording built-in engine | sessionId = {}", (Object)event.getRecordingConnectionId());
                        this.recordingSession.addWebRecordingConnection((IWebRecordingConnection)connection);
                        Win32Helper.switchFocusToBrowser((WebUIDriverType)WebUIDriverType.valueOf((String)driverType.name()));
                        this.webRecordingConnectionManager.startRecording((IWebRecordingConnection)connection);
                        this.recordingSession.setRecordingStatus(WebRecordingStatus.RECORDING);
                        break block11;
                    }
                    logger.error("Incorrect status of recording session to start recording with new browser | status = {}", (Object)this.recordingSession.getRecordingStatus());
                }
                catch (Exception e) {
                    logger.error("Exception when handling WebRecordingConnectionOpenedEvent", (Throwable)e);
                    if (WebRecorderEngineType.BUILT_IN.name().equals(event.getEngineType())) {
                        this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewShowErrorDialogEvent("Error occurred when starting new browser recording session. Please try again."));
                        this.recordingSession.setRecordingStatus(WebRecordingStatus.CONFIGURING);
                    }
                }
            }
            finally {
                this.emitUpdateRecordingStatusEventToView();
                this.emitUpdateRecordingConnectionEventToView();
            }
        }
    }

    private void subscribeWebDriverEvents() {
        this.compositeDisposable.add(this.webDriverConnectionEventBus.getObservableToSubscribe(WebDriverOpenConnectionExceptionEvent.class).subscribe(event -> this.handleWebDriverOpenConnectionExceptionEvent((WebDriverOpenConnectionExceptionEvent)event)));
    }

    private void handleWebDriverOpenConnectionExceptionEvent(WebDriverOpenConnectionExceptionEvent event) {
        String webDriverId = event.getWebDriverId();
        DriverType driverType = event.getDriverType();
        Throwable throwable = event.getThrowable();
        logger.error("Exception event received when create web driver | type = {}", (Object)driverType, (Object)throwable);
        IWebDriverConnection webDriverConnection = this.recordingSession.getWebDriverConnection(driverType);
        if (webDriverConnection != null && Strings.CS.equals(webDriverConnection.getWebDriverConnectionId(), webDriverId)) {
            this.recordingSession.removeWebDriverConnection(driverType);
        }
        this.recordingSession.setRecordingStatus(WebRecordingStatus.CONFIGURING);
        this.emitUpdateRecordingStatusEventToView();
        this.webViewUpdateEventBus.publishUpdateWebViewEvent((WebViewUpdateEvent)new WebViewShowErrorDialogEvent("%s%s%s".formatted("Cannot open %s browser. Please update the WebDriver and try again.".formatted(driverType.getDisplayName()), System.lineSeparator(), throwable.getMessage())));
    }
}

