/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.domain.manager;

import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.web.domain.manager.IWebCapturedObjectManager;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.katalon.recorder.web.domain.model.TakeScreenshotObjectInfo;
import com.katalon.recorder.web.infrastructure.IWebCapturedObjectService;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.webui.util.FileUtil;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class WebCapturedObjectManager
implements IWebCapturedObjectManager {
    private final IWebCapturedObjectService webCapturedObjectService;

    @Inject
    public WebCapturedObjectManager(IWebCapturedObjectService webTestObjectService) {
        this.webCapturedObjectService = webTestObjectService;
    }

    public List<IWebCapturedObject> fetchTestObjectFromTestCase(String testCaseId) throws Exception {
        return this.webCapturedObjectService.fetchTestObjectFromTestCase(testCaseId);
    }

    public List<TestObject> parseToTestObjects(List<IWebCapturedObject> capturedObjects) {
        return this.webCapturedObjectService.parseToTestObjects(capturedObjects);
    }

    public Boolean handleTakeScreenshotObjectInfo(IWebCapturedObject capturedObject, TakeScreenshotObjectInfo takeScreenshotObjectInfo) throws IOException {
        String path = takeScreenshotObjectInfo.getPath();
        String name = takeScreenshotObjectInfo.getName();
        String base64 = takeScreenshotObjectInfo.getBase64();
        if (StringUtils.isNotBlank((CharSequence)base64)) {
            File imageFolder = new File(path);
            imageFolder.mkdirs();
            Object screenshotPath = path;
            screenshotPath = ((String)screenshotPath).replaceAll("\\\\", "/");
            screenshotPath = ((String)screenshotPath).endsWith("/") ? (String)screenshotPath + name : (String)screenshotPath + "/" + name;
            if (!((String)screenshotPath).endsWith(".png")) {
                screenshotPath = (String)screenshotPath + ".png";
            }
            byte[] imageBytes = Base64.getDecoder().decode(base64);
            Throwable throwable = null;
            Object var10_11 = null;
            try (FileOutputStream fos = new FileOutputStream((String)screenshotPath);){
                fos.write(imageBytes);
                fos.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
            String relativePathToImage = FileUtil.getRelativePath((String)screenshotPath, (String)projectDir);
            capturedObject.addLocator(LocatorType.IMAGE, relativePathToImage);
            return true;
        }
        return false;
    }
}

