/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.domain.manager;

import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.core.constant.RecordingConnectionStatus;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionClosedException;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionMessageParsingException;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionNotFoundException;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionSendMessageException;
import com.katalon.recorder.web.domain.manager.IWebRecordingConnectionManager;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.katalon.recorder.web.domain.model.IWebRecorderSetting;
import com.katalon.recorder.web.domain.model.IWebRecordingConnection;
import com.katalon.recorder.web.infrastructure.IWebRecorderEngineService;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class WebRecordingConnectionManager
implements IWebRecordingConnectionManager {
    private static final Logger logger = LoggerFactory.getLogger(WebRecordingConnectionManager.class);
    private final IWebRecorderEngineService webRecorderEngineService;

    @Inject
    public WebRecordingConnectionManager(IWebRecorderEngineService webRecorderEngineService) {
        this.webRecorderEngineService = webRecorderEngineService;
    }

    public void openForConnection(IWebRecorderSetting webRecorderSetting) throws Exception {
        this.webRecorderEngineService.openForConnection(webRecorderSetting);
    }

    public void injectRecorderSetting(IWebRecordingConnection connection, String exclusionPattern) throws WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        if (connection == null) {
            logger.warn("injectRecorderSetting | connection is null");
            return;
        }
        this.webRecorderEngineService.injectRecorderSetting(connection.getRecordingConnectionId(), exclusionPattern);
    }

    public void startRecording(IWebRecordingConnection connection) throws WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        if (connection == null) {
            logger.warn("startRecording | connection is null");
            return;
        }
        this.webRecorderEngineService.startRecording(connection.getRecordingConnectionId());
        connection.setStatus(RecordingConnectionStatus.RECORDING);
    }

    public void pauseRecording(IWebRecordingConnection connection) throws WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        if (connection == null) {
            logger.warn("pauseRecording | connection is null");
            return;
        }
        this.webRecorderEngineService.stopRecording(connection.getRecordingConnectionId());
        connection.setStatus(RecordingConnectionStatus.PAUSED);
    }

    public void stopRecording(IWebRecordingConnection connection) throws WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        if (connection == null) {
            logger.warn("stopRecording | connection is null");
            return;
        }
        this.webRecorderEngineService.stopRecording(connection.getRecordingConnectionId());
        connection.setStatus(RecordingConnectionStatus.CONNECTED);
    }

    public void close(IWebRecordingConnection connection) {
        if (connection == null) {
            return;
        }
        this.webRecorderEngineService.close(connection.getRecordingConnectionId());
    }

    public void close(List<IWebRecordingConnection> connections) {
        connections.forEach(this::close);
    }

    public void closeForConnection() {
        this.webRecorderEngineService.closeForConnection();
    }

    public void verifyAndHighlightObject(IWebRecordingConnection connection, IWebCapturedObject capturedObject, LocatorType locatorType) throws WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        this.webRecorderEngineService.verifyAndHighlightObject(connection.getRecordingConnectionId(), capturedObject, locatorType);
    }

    public void takeScreenshot(IWebRecordingConnection connection, IWebCapturedObject capturedObject, LocatorType locatorType) throws WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        this.webRecorderEngineService.takeScreenshot(connection.getRecordingConnectionId(), capturedObject, locatorType);
    }

    public void updateRecorderEngineSetting(IWebRecordingConnection connection, boolean smartLocatorCaptureEnabledResult) throws WebRecordingConnectionClosedException, WebRecordingConnectionMessageParsingException, WebRecordingConnectionSendMessageException, WebRecordingConnectionNotFoundException {
        this.webRecorderEngineService.updateRecorderEngineSetting(connection.getRecordingConnectionId(), smartLocatorCaptureEnabledResult);
    }
}

