/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.infrastructure;

import com.katalon.capability.constant.DriverType;
import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.web.domain.event.IWebDriverConnectionEventBus;
import com.katalon.recorder.web.domain.event.WebDriverConnectionEvent;
import com.katalon.recorder.web.domain.event.WebDriverOpenConnectionExceptionEvent;
import com.katalon.recorder.web.domain.exception.ExtensionNotFoundException;
import com.katalon.recorder.web.domain.exception.LoadExtensionFileException;
import com.katalon.recorder.web.domain.exception.UnsupportedDriverTypeException;
import com.katalon.recorder.web.domain.exception.WebDriverCreationException;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionNotFoundException;
import com.katalon.recorder.web.domain.exception.WebRecordingRunStepsException;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.katalon.recorder.web.domain.model.IWebDriverConnection;
import com.katalon.recorder.web.domain.model.WebDriverConnection;
import com.katalon.recorder.web.infrastructure.IWebDriverService;
import com.katalon.recorder.web.infrastructure.event.IWebDriverRunnableEventBus;
import com.katalon.recorder.web.infrastructure.event.WebDriverRunnableCreationExceptionEvent;
import com.katalon.recorder.web.infrastructure.event.WebDriverRunnableEventBus;
import com.katalon.recorder.web.infrastructure.runnable.IWebDriverRunnable;
import com.katalon.recorder.web.infrastructure.runnable.WebDriverRunnable;
import com.katalon.recorder.web.infrastructure.util.WebElementUtils;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.execution.webservice.RecordingScriptGenerator;
import com.kms.katalon.objectspy.util.FileUtil;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class WebDriverService
implements IWebDriverService {
    private static final Logger logger = LoggerFactory.getLogger(WebDriverService.class);
    private final ConcurrentHashMap<String, IWebDriverRunnable> runningDrivers = new ConcurrentHashMap();
    private RecordingScriptGenerator generator;
    private final IWebDriverRunnableEventBus webDriverRunnableEventBus = WebDriverRunnableEventBus.getInstance();
    private final CompositeDisposable compositeDisposable = new CompositeDisposable();
    private final IWebDriverConnectionEventBus webDriverConnectionEventBus;

    @Inject
    public WebDriverService(IWebDriverConnectionEventBus webDriverConnectionEventBus) {
        this.webDriverConnectionEventBus = webDriverConnectionEventBus;
        this.subscribeWebDriverRunnableEvent();
    }

    private void subscribeWebDriverRunnableEvent() {
        this.compositeDisposable.add(this.webDriverRunnableEventBus.getObservableToSubscribe(WebDriverRunnableCreationExceptionEvent.class).subscribe(event -> {
            String webDriverId = event.getWebDriverId();
            Throwable throwable = event.getThrowable();
            IWebDriverRunnable removed = this.runningDrivers.remove(webDriverId);
            if (removed != null) {
                this.webDriverConnectionEventBus.publishEvent((WebDriverConnectionEvent)new WebDriverOpenConnectionExceptionEvent(webDriverId, removed.getDriverType(), throwable));
            }
        }));
    }

    public IWebDriverConnection startWebDriver(Integer recorderEnginePort, DriverType driverType, String profile, String customCapName, String startupUrl) throws ExtensionNotFoundException, LoadExtensionFileException, UnsupportedDriverTypeException, WebDriverCreationException {
        this.runningDrivers.values().forEach(IWebDriverRunnable::close);
        WebDriverRunnable webDriverRunnable = new WebDriverRunnable(recorderEnginePort, driverType, profile, customCapName, startupUrl);
        this.runningDrivers.put(webDriverRunnable.getWebDriverConnectionId(), webDriverRunnable);
        new Thread((Runnable)((Object)webDriverRunnable)).start();
        return new WebDriverConnection(webDriverRunnable.getWebDriverConnectionId(), webDriverRunnable.getDriverType(), webDriverRunnable.getProfile(), webDriverRunnable.getCustomCapabilityName(), webDriverRunnable.getStartupUrl());
    }

    public void close(String webDriverConnectionId) {
        IWebDriverRunnable removed = this.runningDrivers.remove(webDriverConnectionId);
        if (removed == null) {
            logger.warn("WebDriverRunnable not found | id = {}", (Object)webDriverConnectionId);
            return;
        }
        removed.close();
    }

    public void close() {
        try {
            this.runningDrivers.forEach((id, driver) -> {
                try {
                    driver.close();
                }
                catch (Exception e) {
                    logger.error("Error when closing web driver | id = {}", id, (Object)e);
                }
            });
            this.webDriverRunnableEventBus.close();
        }
        finally {
            this.runningDrivers.clear();
            logger.info("WebDriverService closed");
        }
    }

    public Integer verifyAndHighlightTestObject(String webDriverConnectionId, IWebCapturedObject capturedObject, LocatorType locatorType) throws WebRecordingConnectionNotFoundException {
        IWebDriverRunnable webDriverRunnable = this.runningDrivers.get(webDriverConnectionId);
        if (webDriverRunnable == null) {
            throw new WebRecordingConnectionNotFoundException("No WebDriver connection found");
        }
        return WebElementUtils.verifyAndHighlightElement(webDriverRunnable, capturedObject, locatorType);
    }

    public Integer takeScreenshot(String webDriverConnectionId, IWebCapturedObject capturedObject, LocatorType locatorType) throws WebRecordingConnectionNotFoundException {
        IWebDriverRunnable webDriverRunnable = this.runningDrivers.get(webDriverConnectionId);
        if (webDriverRunnable == null) {
            throw new WebRecordingConnectionNotFoundException("No WebDriver connection found");
        }
        String pathToImage = WebElementUtils.takeScreenShot(webDriverRunnable, capturedObject);
        if (StringUtils.isBlank((CharSequence)pathToImage)) {
            return 0;
        }
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        String relativePathToImage = FileUtil.getRelativePath((String)pathToImage, (String)projectDir);
        capturedObject.addLocator(LocatorType.IMAGE, relativePathToImage);
        return 1;
    }

    public WebDriver getWebDriver(String webDriverConnectionId) {
        IWebDriverRunnable webDriverRunnable = this.runningDrivers.get(webDriverConnectionId);
        if (webDriverRunnable == null) {
            return null;
        }
        return webDriverRunnable.getWebDriver(10);
    }

    public void runScript(String sessionId, WebUIDriverType driverType, WebDriver webDriver, List<TestObject> testObjects, List<VariableEntity> variables, ScriptNodeWrapper scriptNodeWrapper) throws WebRecordingRunStepsException {
        File recordSessionFolder = new File(ProjectController.getInstance().getTempDir(), "record/" + sessionId);
        recordSessionFolder.mkdirs();
        File capturedObjectsFile = new File(recordSessionFolder, "captured_objects.json");
        HashMap<String, TestObject> testObjectsCache = new HashMap<String, TestObject>();
        for (TestObject testObject : testObjects) {
            testObjectsCache.put(testObject.getObjectId(), testObject);
        }
        try {
            FileUtils.write((File)capturedObjectsFile, (CharSequence)JsonUtil.toJson(testObjectsCache), (String)Charset.defaultCharset().name());
        }
        catch (IOException e) {
            throw new WebRecordingRunStepsException("Cannot save captured objects into temporary file before running. Skip getting captured objects.", (Throwable)e);
        }
        this.generator = new RecordingScriptGenerator(capturedObjectsFile.getAbsolutePath());
        StringBuilder stringBuilder = new StringBuilder();
        new GroovyWrapperParser(stringBuilder).parseGroovyAstIntoScript(scriptNodeWrapper);
        try {
            this.generator.execute(stringBuilder.toString(), variables, webDriver, driverType, ProjectController.getInstance().getCurrentProject());
        }
        catch (Exception exception) {
            throw new WebRecordingRunStepsException("Cannot execute steps. " + exception.getMessage(), (Throwable)exception);
        }
    }

    public IWebDriverConnection getActiveWebDriverConnection(DriverType driverType) {
        for (IWebDriverRunnable runnable : this.runningDrivers.values()) {
            RemoteWebDriver driver;
            WebDriver webDriver;
            if (!runnable.getIsRunning() || runnable.getDriverType() != driverType || !((webDriver = runnable.getWebDriver()) instanceof RemoteWebDriver) || (driver = (RemoteWebDriver)webDriver).getSessionId() == null) continue;
            return new WebDriverConnection(runnable.getWebDriverConnectionId(), runnable.getDriverType(), runnable.getProfile(), runnable.getCustomCapabilityName(), runnable.getStartupUrl());
        }
        return null;
    }

    public void stopRunningSteps() {
        if (this.generator != null) {
            this.generator.stopLauncher();
            this.generator = null;
        }
    }
}

