/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.infrastructure;

import com.katalon.capability.constant.DriverType;
import com.katalon.recorder.web.constant.WebRecorderEngine;
import com.katalon.recorder.web.domain.model.IWebRecorderSetting;
import com.katalon.recorder.web.domain.model.WebRecorderSetting;
import com.katalon.recorder.web.infrastructure.IWebRecorderSettingRepository;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import jakarta.inject.Singleton;
import org.apache.commons.lang3.Strings;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class WebRecorderSettingRepository
implements IWebRecorderSettingRepository {
    private static final String WEBUI_RECORDER_QUALIFIER = "com.kms.katalon.composer.webui.recorder";
    private static final String WEBUI_OBJECT_SPY_QUALIFIER = "com.kms.katalon.composer.webui.objectspy";
    private static final String BETA_FEATURE_QUALIFIER = "com.kms.katalon.betaFeature";
    private static final String RECORDER_PLUS_OPTION_KEY = "betaFeature.recorderPlusOption";
    private static final String PIN_WINDOW_KEY = "recorder.pinWindow";
    private static final boolean PIN_WINDOW_DEFAULT = true;
    public static final String RECORDING_BROWSER_KEY = "recorder.defaultBrowser";
    private static final String RECORDING_BROWSER_DEFAULT = DriverType.CHROME_DRIVER.getDisplayName();
    public static final String RECORDING_PORT_KEY = "utilitiesAddon.instantBrowserPort";
    public static final int RECORDING_PORT_DEFAULT = 50000;
    public static final String DO_NOT_SHOW_AGAIN_KEY = "utilitiesAddon.instantBrowser.doNotShowAgain";
    private static final boolean DO_NOT_SHOW_AGAIN_DEFAULT = false;
    public static final String CHROME_PROFILE_KEY = "utilitiesAddon.chromeProfile";
    private final ScopedPreferenceStore recorderPreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.webui.recorder");
    private final ScopedPreferenceStore spyPreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.webui.objectspy");
    private final ScopedPreferenceStore betaFeaturePreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.betaFeature");

    public IWebRecorderSetting getWebRecorderSetting() {
        String recorderPlusOption = this.betaFeaturePreferenceStore.getString(RECORDER_PLUS_OPTION_KEY);
        WebRecorderEngine engine = Strings.CI.equals(Boolean.TRUE.toString(), recorderPlusOption) ? WebRecorderEngine.RECORDER_PLUS : WebRecorderEngine.RECORDER;
        boolean pinWindow = this.recorderPreferenceStore.contains(PIN_WINDOW_KEY) ? this.recorderPreferenceStore.getBoolean(PIN_WINDOW_KEY) : true;
        String defaultRecordingBrowser = this.recorderPreferenceStore.contains(RECORDING_BROWSER_KEY) ? this.recorderPreferenceStore.getString(RECORDING_BROWSER_KEY) : RECORDING_BROWSER_DEFAULT;
        int recordingPort = this.spyPreferenceStore.contains(RECORDING_PORT_KEY) ? this.spyPreferenceStore.getInt(RECORDING_PORT_KEY) : 50000;
        boolean doNotShowAgain = this.spyPreferenceStore.contains(DO_NOT_SHOW_AGAIN_KEY) ? this.spyPreferenceStore.getBoolean(DO_NOT_SHOW_AGAIN_KEY) : false;
        String chromeProfile = this.spyPreferenceStore.contains(CHROME_PROFILE_KEY) ? this.spyPreferenceStore.getString(CHROME_PROFILE_KEY) : null;
        return new WebRecorderSetting(engine, Boolean.valueOf(pinWindow), DriverType.fromDisplayName((String)defaultRecordingBrowser), Integer.valueOf(recordingPort), Boolean.valueOf(doNotShowAgain), chromeProfile);
    }
}

