/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.infrastructure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.recorder.web.domain.exception.WriteRecordingRequestException;
import com.katalon.recorder.web.domain.model.WebRecordingRequest;
import com.katalon.recorder.web.infrastructure.IWebRecordingRequestRepository;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class WebRecordingRequestRepository
implements IWebRecordingRequestRepository {
    private static final Logger logger = LoggerFactory.getLogger(WebRecordingRequestRepository.class);

    public void writeRecordingRequest(String filePath, WebRecordingRequest recordingRequest) throws WriteRecordingRequestException {
        try {
            File file = new File(filePath);
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new WriteRecordingRequestException("Failed to create parent directory for recordingRequest setting file | filePath: %s".formatted(filePath));
            }
            if (!file.exists() && !file.createNewFile()) {
                throw new WriteRecordingRequestException("Failed to create recordingRequest setting file | filePath: %s".formatted(filePath));
            }
            ObjectMapper mapper = new ObjectMapper();
            String data = mapper.writeValueAsString((Object)recordingRequest);
            FileUtils.writeStringToFile((File)file, (String)data, (String)Charset.defaultCharset().name());
        }
        catch (IOException e) {
            throw new WriteRecordingRequestException("Exception while writeRecordingRequest | filePath: %s".formatted(filePath), (Throwable)e);
        }
    }

    public WebRecordingRequest readRecordingRequest(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists()) {
                String fileData = FileUtils.readFileToString((File)file, (String)Charset.defaultCharset().name());
                ObjectMapper mapper = new ObjectMapper();
                return (WebRecordingRequest)mapper.readValue(fileData, WebRecordingRequest.class);
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Exception while readRecordingRequest | filePath = {}", (Object)filePath, (Object)e);
            return null;
        }
    }
}

