/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.infrastructure.runnable;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.capability.constant.DriverType;
import com.katalon.recorder.core.constant.WebRecorderEngineType;
import com.katalon.recorder.web.constant.WebRecorderEngine;
import com.katalon.recorder.web.domain.exception.ExtensionNotFoundException;
import com.katalon.recorder.web.domain.exception.LoadExtensionFileException;
import com.katalon.recorder.web.domain.exception.UnsupportedDriverTypeException;
import com.katalon.recorder.web.domain.exception.WebDriverCreationException;
import com.katalon.recorder.web.infrastructure.event.WebDriverRunnableCreationExceptionEvent;
import com.katalon.recorder.web.infrastructure.event.WebDriverRunnableEvent;
import com.katalon.recorder.web.infrastructure.event.WebDriverRunnableEventBus;
import com.katalon.recorder.web.infrastructure.runnable.IWebDriverRunnable;
import com.kms.katalon.composer.webui.recorder.core.RecordSession;
import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.configuration.core.interfaces.IExecutionSetting;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.driver.IDriverType;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import com.kms.katalon.core.webui.util.WebDriverProxyUtil;
import com.kms.katalon.execution.configuration.contributor.CustomRunConfigurationContributor;
import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.execution.webui.util.WebUIExecutionUtil;
import com.kms.katalon.objectspy.core.InspectSession;
import com.kms.katalon.objectspy.preferences.ObjectSpyPreferences;
import com.kms.katalon.objectspy.util.FileUtil;
import com.kms.katalon.objectspy.websocket.AddonHotKeyConfig;
import com.kms.katalon.objectspy.websocket.AddonHotKeyData;
import com.kms.katalon.preferences.util.RecorderPlusSettingUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.webextension.ExtensionData;
import org.openqa.selenium.bidi.webextension.ExtensionPath;
import org.openqa.selenium.bidi.webextension.InstallExtensionParameters;
import org.openqa.selenium.bidi.webextension.WebExtension;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverRunnable
implements IWebDriverRunnable {
    private static final Logger logger = LoggerFactory.getLogger(WebDriverRunnable.class);
    protected static final String DEFAULT_PROTOCOL = "http";
    protected static final int STATUS_CHECKING_INTERVAL = 1000;
    protected static final String CHROME_PROPERTY_USER_DATA_DIR = "user-data-dir=";
    protected static final String CHROME_PROPERTY_PROFILE_DIR = "profile-directory=";
    protected static final String CHROME_RECORDER_PLUS_EXTENSION_PATH = File.separator + "Chrome" + File.separator + "Recorder Plus";
    protected static final String CHROME_RECORDER_EXTENSION_PATH = File.separator + "Chrome" + File.separator + "Recorder" + File.separator + "KR";
    protected static final String CHROME_SMART_WAIT_EXTENSION_RELATIVE_PATH = File.separator + "Chrome" + File.separator + "Smart Wait";
    protected static final String VARIABLE_INIT_FILE_FOR_CHROME = "chrome_variables_init.js";
    protected static final String VARIABLE_INIT_EXPRESSION_FOR_CHROME = "engineType = ''{0}''\r\nengine = ''{1}''\r\nkatalonServerPort = ''{2}''\r\nkatalonOnOffStatus = true\r\nspy_captureObjectHotKey = {3};\r\nspy_loadDomMapHotKey = {4};\r\n";
    protected static final String LOAD_EXTENSION_CHROME_PREFIX = "load-extension=";
    protected static final String EDGE_CHROMIUM_RECORDER_EXTENSION_PATH = File.separator + "Edge Chromium" + File.separator + "Recorder" + File.separator + "KR";
    protected static final String EDGE_CHROMIUM_SMART_WAIT_EXTENSION_RELATIVE_PATH = File.separator + "Edge Chromium" + File.separator + "Smart Wait";
    protected final String webDriverConnectionId;
    protected final AtomicBoolean isRunning;
    protected final Integer recorderEnginePort;
    protected final DriverType driverType;
    protected final String profile;
    protected final String customCapabilityName;
    protected final String startupUrl;
    private final AtomicReference<IDriverConnector> driverConnector;
    private final AtomicReference<Capabilities> capabilities;
    protected final AtomicReference<WebDriver> webDriver;

    public WebDriverRunnable(Integer recorderEnginePort, DriverType driverType, String profile, String customCapabilityName, String startupUrl) throws UnsupportedDriverTypeException, LoadExtensionFileException, ExtensionNotFoundException, WebDriverCreationException {
        if (driverType != DriverType.CHROME_DRIVER && driverType != DriverType.EDGE_CHROMIUM_DRIVER) {
            throw new UnsupportedDriverTypeException("%s is not supported.".formatted(driverType.getDisplayName()));
        }
        this.webDriverConnectionId = UUID.randomUUID().toString();
        this.recorderEnginePort = recorderEnginePort;
        this.driverType = driverType;
        this.profile = profile;
        this.customCapabilityName = customCapabilityName;
        this.startupUrl = startupUrl;
        this.webDriver = new AtomicReference();
        this.isRunning = new AtomicBoolean(true);
        this.driverConnector = new AtomicReference();
        this.capabilities = new AtomicReference();
        try {
            this.driverConnector.set(this.setupDriverConnector());
        }
        catch (ExecutionException | IOException e) {
            throw new WebDriverCreationException("Exception when setting up driver connector", e);
        }
        try {
            this.capabilities.set(this.setupCapability());
        }
        catch (IOException e) {
            throw new LoadExtensionFileException("Cannot load extension file", (Throwable)e);
        }
        logger.info("WebDriverRunnable initialized | driverType = {}, profile = {}, customCapabilityName = {}, startupUrl = {}", new Object[]{driverType, profile, customCapabilityName, startupUrl});
    }

    public void run() {
        try {
            this.webDriver.set(this.createWebDriver());
        }
        catch (Exception e) {
            logger.error("Exception when creating WebDriver | id = {}", (Object)this.webDriverConnectionId, (Object)e);
            WebDriverRunnableEventBus.getInstance().publishEvent((WebDriverRunnableEvent)new WebDriverRunnableCreationExceptionEvent(this.webDriverConnectionId, (Throwable)e));
            this.close();
            return;
        }
        try {
            try {
                this.navigateToUrl();
                this.startCheckingLoop();
            }
            catch (InterruptedException e) {
                logger.warn("WebDriverRunnable interrupted | id = {}", (Object)this.webDriverConnectionId, (Object)e);
                Thread.currentThread().interrupt();
                this.close();
            }
        }
        finally {
            this.close();
        }
    }

    protected IDriverConnector setupDriverConnector() throws IOException, ExecutionException {
        if (StringUtils.isEmpty((CharSequence)this.customCapabilityName)) {
            return WebUIExecutionUtil.getBrowserDriverConnector((WebUIDriverType)this.getWebUIDriverType(), (String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        }
        CustomRunConfigurationContributor customRunConfigurationContributor = new CustomRunConfigurationContributor(this.customCapabilityName);
        return this.getBrowser(customRunConfigurationContributor);
    }

    private IDriverConnector getBrowser(CustomRunConfigurationContributor customRunConfigContributor) throws IOException, ExecutionException {
        IRunConfiguration runConfiguration = customRunConfigContributor.getRunConfiguration(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        return Optional.ofNullable(runConfiguration).map(IRunConfiguration::getDriverConnectors).map(driverConnectors -> (IDriverConnector)driverConnectors.get("WebUI")).orElse(null);
    }

    protected Capabilities setupCapability() throws IOException, ExtensionNotFoundException {
        DefaultExecutionSetting executionSetting = new DefaultExecutionSetting();
        executionSetting.setTimeout(ExecutionUtil.getDefaultImplicitTimeout());
        HashMap<String, IDriverConnector> driverConnectors = new HashMap<String, IDriverConnector>(1);
        driverConnectors.put("WebUI", this.driverConnector.get());
        RunConfiguration.setExecutionSetting((Map)ExecutionUtil.getExecutionProperties((IExecutionSetting)executionSetting, driverConnectors, null));
        return this.createDriverOptions(this.getWebUIDriverType());
    }

    private Capabilities createDriverOptions(WebUIDriverType driverType) throws IOException, ExtensionNotFoundException {
        MutableCapabilities capabilities = WebDriverPropertyUtil.toDesireCapabilities((Map)RunConfiguration.getDriverPreferencesProperties((String)"WebUI"), (WebUIDriverType)driverType);
        switch (driverType) {
            case CHROME_DRIVER: {
                ChromeOptions options = WebDriverPropertyUtil.generateDefaultChromeOptions().merge((Capabilities)capabilities);
                if (this.profile == null) {
                    options.setCapability("webSocketUrl", true);
                    options.addArguments(new String[]{"--remote-debugging-pipe", "--enable-unsafe-extension-debugging"});
                } else {
                    options.setCapability("webSocketUrl", false);
                }
                return this.profile != null ? this.createChromeDriverOptionsWithProfile(options) : this.createChromeDriverOptions(options, CHROME_RECORDER_PLUS_EXTENSION_PATH, CHROME_RECORDER_EXTENSION_PATH, CHROME_SMART_WAIT_EXTENSION_RELATIVE_PATH);
            }
            case FIREFOX_DRIVER: {
                ProxyInformation proxyInfo = RunConfiguration.getProxyInformation();
                if (proxyInfo != null && proxyInfo.isApplyToDesiredCapabilities()) {
                    capabilities.setCapability("proxy", (Object)WebDriverRunnable.getDefaultProxy());
                }
                capabilities.setCapability("webSocketUrl", false);
                return capabilities;
            }
            case EDGE_CHROMIUM_DRIVER: {
                capabilities.setCapability("webSocketUrl", false);
                return this.createChromeDriverOptions(new EdgeOptions().merge((Capabilities)capabilities), CHROME_RECORDER_PLUS_EXTENSION_PATH, EDGE_CHROMIUM_RECORDER_EXTENSION_PATH, EDGE_CHROMIUM_SMART_WAIT_EXTENSION_RELATIVE_PATH);
            }
        }
        return capabilities;
    }

    private ChromeOptions createChromeDriverOptionsWithProfile(ChromeOptions options) {
        ProxyInformation proxyInformation = RunConfiguration.getProxyInformation();
        if (proxyInformation != null && proxyInformation.isApplyToDesiredCapabilities() && ProxyOption.valueOf((String)proxyInformation.getProxyOption()) == ProxyOption.MANUAL_CONFIG) {
            if (WebDriverProxyUtil.isManualSocks((ProxyInformation)proxyInformation)) {
                options.addArguments(new String[]{"--proxy-server=socks5://" + WebDriverProxyUtil.getProxyString((ProxyInformation)proxyInformation)});
            } else {
                options.setProxy(WebDriverRunnable.getDefaultProxy());
            }
        }
        File file = new File(this.profile);
        String name = file.getName();
        String dir = file.getParent();
        String userDataDir = CHROME_PROPERTY_USER_DATA_DIR + dir;
        String profile = CHROME_PROPERTY_PROFILE_DIR + name;
        options.addArguments(new String[]{userDataDir, profile});
        return options;
    }

    private static Proxy getDefaultProxy() {
        ProxyInformation proxyInformation = RunConfiguration.getProxyInformation();
        return WebDriverProxyUtil.getSeleniumProxy((ProxyInformation)(proxyInformation == null ? new ProxyInformation() : proxyInformation));
    }

    protected WebDriver createWebDriver() throws Exception {
        Thread.sleep(5L);
        WebUIDriverType webUIDriverType = this.getWebUIDriverType();
        WebDriver webDriver = DriverFactory.openWebDriver((IDriverType)webUIDriverType, (Object)this.capabilities.get());
        this.loadUnpackedExtensionsViaBidi(webUIDriverType, webDriver);
        return webDriver;
    }

    private void loadUnpackedExtensionsViaBidi(WebUIDriverType webUiDriverType, WebDriver driver) throws IOException {
        if (WebUIDriverType.CHROME_DRIVER == webUiDriverType && this.profile == null) {
            try {
                HasBiDi bidiDriver = (HasBiDi)driver;
                bidiDriver.getBiDi();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Please enable Bidi for loading unpacked extensions in Chrome");
            }
            WebExtension webExtension = new WebExtension(driver);
            if (RecorderPlusSettingUtil.isEnabled()) {
                File recorderPlusExtensionFolder = this.getRecorderPlusExtensionFile(CHROME_RECORDER_PLUS_EXTENSION_PATH);
                webExtension.install(new InstallExtensionParameters((ExtensionData)new ExtensionPath(recorderPlusExtensionFolder.getCanonicalPath())));
            } else {
                File recorderExtensionFolder = this.getRecorderExtensionFile(CHROME_RECORDER_EXTENSION_PATH);
                webExtension.install(new InstallExtensionParameters((ExtensionData)new ExtensionPath(recorderExtensionFolder.getCanonicalPath())));
            }
            if (this.shouldInstallSmartWait()) {
                File smartWaitExtensionFile = this.getSmartWaitExtensionFile(CHROME_SMART_WAIT_EXTENSION_RELATIVE_PATH);
                webExtension.install(new InstallExtensionParameters((ExtensionData)new ExtensionPath(smartWaitExtensionFile.getCanonicalPath())));
            }
        }
    }

    private WebUIDriverType getWebUIDriverType() {
        return WebUIDriverType.valueOf((String)this.driverType.name());
    }

    protected <T extends ChromiumOptions<T>> T createChromeDriverOptions(T options, String recorderPlusExtensionPath, String recorderExtensionPath, String smartWaitExtensionPath) throws IOException, ExtensionNotFoundException {
        this.loadProxyInformation(options);
        this.loadChromeExtensions(options, recorderPlusExtensionPath, recorderExtensionPath, smartWaitExtensionPath);
        return options;
    }

    private void loadProxyInformation(ChromiumOptions<?> options) {
        ProxyInformation proxyInformation = RunConfiguration.getProxyInformation();
        if (proxyInformation.isApplyToDesiredCapabilities() && ProxyOption.valueOf((String)proxyInformation.getProxyOption()) == ProxyOption.MANUAL_CONFIG) {
            if (WebDriverProxyUtil.isManualSocks((ProxyInformation)proxyInformation)) {
                options.addArguments(new String[]{"--proxy-server=socks5://" + WebDriverProxyUtil.getProxyString((ProxyInformation)proxyInformation)});
            } else {
                options.setProxy(WebDriverRunnable.getDefaultProxy());
            }
        }
    }

    private void loadChromeExtensions(ChromiumOptions<?> options, String recorderPlusExtensionPath, String recorderExtensionPath, String smartWaitExtensionPath) throws ExtensionNotFoundException, IOException {
        File recorderPlusExtensionFolder = this.getRecorderPlusExtensionFile(recorderPlusExtensionPath);
        if (recorderPlusExtensionFolder == null || !recorderPlusExtensionFolder.isDirectory() || !recorderPlusExtensionFolder.exists()) {
            String path = recorderPlusExtensionFolder == null ? recorderPlusExtensionPath : recorderPlusExtensionFolder.getPath();
            throw new ExtensionNotFoundException("Extension Recorder Plus not found | path = %s".formatted(path));
        }
        File chromeRecorderExtensionFolder = this.getRecorderExtensionFile(recorderExtensionPath);
        if (chromeRecorderExtensionFolder == null || !chromeRecorderExtensionFolder.isDirectory() || !chromeRecorderExtensionFolder.exists()) {
            String path = chromeRecorderExtensionFolder == null ? recorderExtensionPath : chromeRecorderExtensionFolder.getPath();
            throw new ExtensionNotFoundException("Extension Recorder not found | path = %s".formatted(path));
        }
        File chromeSmartWaitExtensionFolder = this.getSmartWaitExtensionFile(smartWaitExtensionPath);
        if (chromeSmartWaitExtensionFolder == null || !chromeSmartWaitExtensionFolder.isDirectory() || !chromeSmartWaitExtensionFolder.exists()) {
            String path = chromeSmartWaitExtensionFolder == null ? smartWaitExtensionPath : chromeSmartWaitExtensionFolder.getPath();
            throw new ExtensionNotFoundException("Extension SmartWait not found | path = %s".formatted(path));
        }
        this.generateVariableInitFileForChrome(recorderPlusExtensionFolder);
        this.generateVariableInitFileForChrome(chromeRecorderExtensionFolder);
        Object extensions = LOAD_EXTENSION_CHROME_PREFIX;
        extensions = RecorderPlusSettingUtil.isEnabled() ? (String)extensions + recorderPlusExtensionFolder.getCanonicalPath() : (String)extensions + chromeRecorderExtensionFolder.getCanonicalPath();
        if (this.shouldInstallSmartWait()) {
            extensions = (String)extensions + "," + chromeSmartWaitExtensionFolder.getCanonicalPath();
        }
        options.addArguments(new String[]{extensions});
    }

    private void generateVariableInitFileForChrome(File chromeExtensionFolder) throws IOException {
        File variableInitJSFile = new File(chromeExtensionFolder.getAbsolutePath() + File.separator + VARIABLE_INIT_FILE_FOR_CHROME);
        AddonHotKeyData captureObjectHotKey = AddonHotKeyData.buildFrom((AddonHotKeyConfig)ObjectSpyPreferences.getCaptureObjectHotKey());
        AddonHotKeyData loadDomMapHotKey = AddonHotKeyData.buildFrom((AddonHotKeyConfig)ObjectSpyPreferences.getLoadDomMapHotKey());
        ObjectMapper objectMapper = new ObjectMapper();
        FileUtils.writeStringToFile((File)variableInitJSFile, (String)MessageFormat.format(VARIABLE_INIT_EXPRESSION_FOR_CHROME, WebRecorderEngineType.BUILT_IN.name(), WebRecorderEngine.RECORDER_PLUS.name(), String.valueOf(this.recorderEnginePort), objectMapper.writeValueAsString((Object)captureObjectHotKey), objectMapper.writeValueAsString((Object)loadDomMapHotKey)), (String)Charset.defaultCharset().name());
    }

    private File getSmartWaitExtensionFile(String browserBasedSmartWaitExtensionPath) throws IOException {
        File chromeExtension = null;
        File extensionFolder = FileUtil.getExtensionsDirectory((Bundle)FrameworkUtil.getBundle(InspectSession.class));
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            chromeExtension = new File(extensionFolder.getAbsolutePath() + browserBasedSmartWaitExtensionPath);
        }
        return chromeExtension;
    }

    private File getRecorderExtensionFile(String browserBasedRecorderExtensionPath) throws IOException {
        File chromeExtension = null;
        File extensionFolder = FileUtil.getExtensionsDirectory((Bundle)FrameworkUtil.getBundle(RecordSession.class));
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            chromeExtension = new File(extensionFolder.getAbsolutePath() + browserBasedRecorderExtensionPath);
        }
        return chromeExtension;
    }

    private File getRecorderPlusExtensionFile(String browserBasedRecorderPlusExtensionPath) throws IOException {
        File recorderPlusExtension = null;
        File extensionFolder = FileUtil.getExtensionsDirectory((Bundle)FrameworkUtil.getBundle(WebDriverRunnable.class));
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            recorderPlusExtension = new File(extensionFolder.getAbsolutePath() + browserBasedRecorderPlusExtensionPath);
        }
        return recorderPlusExtension;
    }

    protected void navigateToUrl() {
        if (StringUtils.isNotBlank((CharSequence)this.startupUrl)) {
            try {
                this.webDriver.get().navigate().to(PathUtil.getUrl((String)this.startupUrl, (String)DEFAULT_PROTOCOL));
            }
            catch (MalformedURLException | URISyntaxException e) {
                logger.warn("startupUrl is invalid | url = {}", (Object)this.startupUrl, (Object)e);
            }
        }
    }

    protected void startCheckingLoop() throws InterruptedException {
        while (this.isRunning.get()) {
            Thread.sleep(1000L);
            try {
                WebDriver driver = this.webDriver.get();
                if (driver == null || driver.getTitle() == null) {
                    this.isRunning.set(false);
                    break;
                }
                driver.getWindowHandle();
            }
            catch (NoSuchSessionException | NoSuchWindowException | UnreachableBrowserException throwable) {
                this.isRunning.set(false);
                break;
            }
            catch (WebDriverException exception) {
                if (!Strings.CS.startsWith((CharSequence)exception.getMessage(), (CharSequence)"chrome not reachable")) continue;
                this.isRunning.set(false);
                break;
            }
        }
    }

    public void close() {
        this.isRunning.set(false);
        try {
            RemoteWebDriver remoteWebDriver;
            WebDriver webDriver = this.webDriver.get();
            if (webDriver instanceof RemoteWebDriver && (remoteWebDriver = (RemoteWebDriver)webDriver).getSessionId() != null) {
                remoteWebDriver.quit();
            }
        }
        catch (WebDriverException e) {
            logger.warn("Exception when close WebDriverRunnable", (Throwable)e);
        }
    }

    public String getWebDriverConnectionId() {
        return this.webDriverConnectionId;
    }

    public boolean getIsRunning() {
        return this.isRunning.get();
    }

    public DriverType getDriverType() {
        return this.driverType;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getCustomCapabilityName() {
        return this.customCapabilityName;
    }

    public String getStartupUrl() {
        return this.startupUrl;
    }

    public WebDriver getWebDriver() {
        return this.webDriver.get();
    }

    public WebDriver getWebDriver(int waitTimeOutInSeconds) {
        long startTime = System.currentTimeMillis();
        long timeoutMillis = (long)waitTimeOutInSeconds * 1000L;
        while (System.currentTimeMillis() - startTime < timeoutMillis && this.webDriver.get() == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                return this.getWebDriver();
            }
        }
        return this.getWebDriver();
    }

    private boolean shouldInstallSmartWait() {
        boolean globalSmartWaitEnabled = Optional.ofNullable(RunConfiguration.getExecutionProperties().get("globalSmartWaitEnabled")).orElse(false);
        return globalSmartWaitEnabled;
    }
}

