/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.presentation;

import com.equo.chromium.swt.Browser;
import com.katalon.composer.core.webview.browserfunction.BrowserFunctionUtil;
import com.katalon.recorder.web.constant.WebViewInteractionEventType;
import com.katalon.recorder.web.domain.model.WebRecordingRequest;
import com.katalon.recorder.web.presentation.IWebConfigurationView;
import com.katalon.recorder.web.presentation.event.ConfigurationStartActiveBrowserEvent;
import com.katalon.recorder.web.presentation.event.ConfigurationStartCustomizedBrowserRecordingEvent;
import com.katalon.recorder.web.presentation.event.ConfigurationStartNewBrowserRecordingEvent;
import com.katalon.recorder.web.presentation.event.IWebViewInteractionEventBus;
import com.katalon.recorder.web.presentation.event.WebViewInteractionEmptyEvent;
import com.katalon.recorder.web.presentation.event.WebViewInteractionEvent;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class WebConfigurationView
implements IWebConfigurationView {
    private final AtomicReference<Browser> browser;
    private final IWebViewInteractionEventBus webViewInteractionEventBus;

    @Inject
    public WebConfigurationView(IWebViewInteractionEventBus webViewInteractionEventBus) {
        this.webViewInteractionEventBus = webViewInteractionEventBus;
        this.browser = new AtomicReference();
    }

    public void init(Browser browser) {
        this.browser.set(browser);
        this.registerBrowserFunctions();
    }

    public void updateCustomizedBrowsersDropdown(List<String> customizedBrowsers) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"webConfigurationViewFunc.callUpdateCustomizedBrowsersDropdown", (Object[])new Object[]{customizedBrowsers});
    }

    private void registerBrowserFunctions() {
        BrowserFunctionUtil.registerBrowserFunction((String)"configurationView.onCustomizedBrowserTabClicked", () -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new WebViewInteractionEmptyEvent(WebViewInteractionEventType.CONFIGURATION_CUSTOMIZED_BROWSER_TAB_CLICKED)));
        BrowserFunctionUtil.registerBrowserFunction((String)"configurationView.onEditCustomizedBrowsersClicked", () -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new WebViewInteractionEmptyEvent(WebViewInteractionEventType.CONFIGURATION_EDIT_CUSTOMIZED_BROWSER_CLICKED)));
        BrowserFunctionUtil.registerBrowserFunction((String)"configurationView.onAddCustomizedBrowsersClicked", () -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new WebViewInteractionEmptyEvent(WebViewInteractionEventType.CONFIGURATION_ADD_CUSTOMIZED_BROWSER_CLICKED)));
        BrowserFunctionUtil.registerBrowserFunction((String)"configurationView.onActiveBrowserTabClicked", () -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new WebViewInteractionEmptyEvent(WebViewInteractionEventType.CONFIGURATION_ACTIVE_BROWSER_TAB_CLICKED)));
        BrowserFunctionUtil.registerBrowserFunction((String)"configurationView.onStartRecordingWithNewBrowser", WebRecordingRequest.class, recordingRequest -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new ConfigurationStartNewBrowserRecordingEvent(recordingRequest)));
        BrowserFunctionUtil.registerBrowserFunction((String)"configurationView.onStartRecordingWithActiveBrowser", WebRecordingRequest.class, recordingRequest -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new ConfigurationStartActiveBrowserEvent(recordingRequest)));
        BrowserFunctionUtil.registerBrowserFunction((String)"configurationView.onStartRecordingWithCustomizedBrowser", WebRecordingRequest.class, recordingRequest -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new ConfigurationStartCustomizedBrowserRecordingEvent(recordingRequest)));
        BrowserFunctionUtil.registerBrowserFunction((String)"configurationView.onCancelConfigurationClicked", () -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new WebViewInteractionEmptyEvent(WebViewInteractionEventType.CONFIGURATION_CANCEL_RECORDING_CLICKED)));
    }
}

