/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.presentation.event;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.recorder.web.constant.WebViewInteractionEventType;
import com.katalon.recorder.web.presentation.event.IWebViewInteractionEventBus;
import com.katalon.recorder.web.presentation.event.WebViewInteractionEvent;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import jakarta.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class WebViewInteractionEventBus
implements IWebViewInteractionEventBus {
    private static final Logger logger = LoggerFactory.getLogger(WebViewInteractionEventBus.class);
    private final Subject<WebViewInteractionEvent> webViewInteractionEventSubject = PublishSubject.create();

    @Inject
    public WebViewInteractionEventBus() {
    }

    public void publishWebViewInteractionEvent(WebViewInteractionEvent event) {
        try {
            logger.info("Publishing WebViewInteractionEvent | event = {}", (Object)new ObjectMapper().writeValueAsString((Object)event));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.webViewInteractionEventSubject.onNext((Object)event);
    }

    public <T extends WebViewInteractionEvent> Observable<T> getWebViewInteractionObservableToSubscribe(Class<T> clazz) {
        return this.webViewInteractionEventSubject.filter(clazz::isInstance).cast(clazz);
    }

    public <T extends WebViewInteractionEvent> Observable<T> getWebViewInteractionObservableToSubscribe(Class<T> clazz, WebViewInteractionEventType type) {
        return this.webViewInteractionEventSubject.filter(clazz::isInstance).cast(clazz).filter(event -> event.getType() == type);
    }

    public <T extends WebViewInteractionEvent> Observable<T> getWebViewInteractionObservableToSubscribe(Class<T> clazz, Predicate<T> predicate) {
        return this.webViewInteractionEventSubject.filter(clazz::isInstance).cast(clazz).filter(predicate);
    }
}

