/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common;

import com.kms.katalon.core.webui.common.KeyElement;
import com.kms.katalon.core.webui.common.Result;
import com.kms.katalon.core.webui.common.Util;
import java.awt.Robot;
import java.util.ArrayList;

public class EKeyboard {
    private Robot robot;

    public EKeyboard() {
        try {
            this.setRobot(new Robot());
            this.getRobot().delay(1000);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private ArrayList<KeyElement> initKey(String str) {
        ArrayList<String> list = new ArrayList<String>();
        while (str.length() > 0) {
            String specialKey;
            if (str.charAt(0) != '/') {
                list.add(String.valueOf(str.charAt(0)));
                str = str.substring(1);
                continue;
            }
            if (str.indexOf(" ") == -1) {
                specialKey = str.substring(1);
                str = "";
            } else {
                specialKey = str.substring(1, str.indexOf(" "));
                str = str.substring(specialKey.length() + 2);
            }
            list.add(specialKey);
        }
        ArrayList<KeyElement> keys = new ArrayList();
        keys = Util.stringToKey(list);
        return keys;
    }

    public Result pressKeys(String strKeys) {
        return this.pressKeys(strKeys, false);
    }

    public Result pressKeys(String strKeys, boolean isSequential) {
        Result result = new Result();
        try {
            ArrayList<KeyElement> keys = this.initKey(strKeys);
            if (isSequential) {
                for (KeyElement ke : keys) {
                    if (ke.getCode() == 65535) continue;
                    if (!ke.getShiftKey().booleanValue()) {
                        this.getRobot().keyPress(ke.getCode());
                        this.getRobot().keyRelease(ke.getCode());
                        continue;
                    }
                    String s = "/Shift " + ke.getName();
                    this.pressKeys(s, false);
                }
            } else {
                int i = 0;
                while (i < keys.size()) {
                    this.getRobot().keyPress(keys.get(i).getCode());
                    ++i;
                }
                i = keys.size() - 1;
                while (i >= 0) {
                    this.getRobot().keyRelease(keys.get(i).getCode());
                    --i;
                }
            }
            result.setReturnValue(true);
        }
        catch (Exception ex) {
            result.setMessage(ex.getMessage());
            result.setReturnValue(false);
            result.setNeedReNewDriver(true);
        }
        return result;
    }

    public Robot getRobot() {
        return this.robot;
    }

    public void setRobot(Robot robot) {
        this.robot = robot;
    }
}

