/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.webui.driver.DriverConfigurationProvider;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.driver.IDriverBuilder;
import com.kms.katalon.core.webui.driver.IDriverConfigurationProvider;
import com.kms.katalon.core.webui.driver.bidi.BiDiDriverUtil;
import com.kms.katalon.selenium.driver.ISmartExtensionWebDriver;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;

public abstract class BaseDriverBuilder
implements IDriverBuilder {
    protected static final KeywordLogger logger = KeywordLogger.getInstance(DriverFactory.class);
    protected static final IDriverConfigurationProvider driverConfigProvider = new DriverConfigurationProvider(logger);
    protected Capabilities capabilities = new MutableCapabilities();
    protected boolean withSmartWait = false;
    protected boolean withSmartLocator = false;
    protected boolean withAccessibilityTree = false;
    protected boolean withFlutterAppTesting = false;
    protected boolean withCanvasTextExtraction = false;
    protected boolean withClosedShadowDOMTesting = false;

    @Override
    public IDriverBuilder capabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    @Override
    public IDriverBuilder withSmartWait(boolean value) {
        this.withSmartWait = value;
        return this;
    }

    @Override
    public IDriverBuilder withSmartLocator(boolean value) {
        this.withSmartLocator = value;
        return this;
    }

    @Override
    public IDriverBuilder withAccessibilityTree(boolean value) {
        this.withAccessibilityTree = value;
        return this;
    }

    @Override
    public IDriverBuilder withFlutterAppTesting(boolean value) {
        this.withFlutterAppTesting = value;
        return this;
    }

    @Override
    public IDriverBuilder withCanvasTextExtraction(boolean value) {
        this.withCanvasTextExtraction = value;
        return this;
    }

    @Override
    public IDriverBuilder withClosedShadowDOMTesting(boolean value) {
        this.withClosedShadowDOMTesting = value;
        return this;
    }

    protected WebDriver injectSmartExtensions(WebDriver driver) {
        boolean smartWaitInjected = false;
        boolean smartLocatorInjected = false;
        boolean flutterAppTestingInjected = false;
        boolean canvasTextExtractionInjected = false;
        boolean closedShadowDOMTestingInjected = false;
        if (this.withSmartLocator || this.withAccessibilityTree) {
            smartLocatorInjected = BiDiDriverUtil.injectSmartLocatorScript(driver);
        }
        if (this.withSmartWait) {
            smartWaitInjected = BiDiDriverUtil.injectSmartWaitScript(driver);
        }
        if (this.withFlutterAppTesting) {
            flutterAppTestingInjected = BiDiDriverUtil.injectFlutterAppTestingScript(driver);
        }
        if (this.withCanvasTextExtraction) {
            canvasTextExtractionInjected = BiDiDriverUtil.injectCanvasTextExtractionScript(driver);
        }
        if (this.withClosedShadowDOMTesting) {
            closedShadowDOMTestingInjected = BiDiDriverUtil.injectClosedShadowDOMTestingScript(driver);
        }
        this.applyInjectionStatus(driver, smartWaitInjected, smartLocatorInjected, flutterAppTestingInjected, canvasTextExtractionInjected, closedShadowDOMTestingInjected);
        return driver;
    }

    protected void applyInjectionStatus(WebDriver driver, boolean smartWaitInjected, boolean smartLocatorInjected, boolean flutterAppTestingInjected, boolean canvasTextExtractionInjected, boolean closedShadowDOMTestingInjected) {
        if (driver instanceof ISmartExtensionWebDriver) {
            ISmartExtensionWebDriver smartDriver = (ISmartExtensionWebDriver)driver;
            smartDriver.setInjectionStatus(smartWaitInjected, smartLocatorInjected, flutterAppTestingInjected, canvasTextExtractionInjected, closedShadowDOMTestingInjected);
        }
    }
}

