/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.model;

import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectXpath;
import com.kms.katalon.core.webui.common.CssLocatorBuilder;
import com.kms.katalon.core.webui.common.FindElementsResult;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import com.kms.katalon.core.webui.common.internal.ImageLocatorController;
import com.kms.katalon.core.webui.common.internal.SelfHealingController;
import com.kms.katalon.core.webui.constants.CoreWebuiMessageConstants;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.exception.WebElementNotFoundException;
import com.kms.katalon.core.webui.model.FindElementParams;
import com.kms.katalon.core.webui.model.SeleniumElementFinder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.DetachedShadowRootException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebUiElementFinder
implements SeleniumElementFinder<FindElementParams> {
    private final KeywordLogger logger = KeywordLogger.getInstance(WebUiElementFinder.class);

    @Override
    public WebElement findElement(FindElementParams params) throws Exception {
        WebDriver webDriver = params.getWebDriver();
        TestObject testObject = params.getTestObject();
        WebElement cachedWebElement = testObject.getCachedWebElement();
        if (cachedWebElement != null) {
            return cachedWebElement;
        }
        List<WebElement> elements = this.findElementsBySelectedMethod(webDriver, testObject).getElements();
        if (elements != null && elements.size() > 0) {
            WebElement foundElement = elements.get(0);
            return foundElement;
        }
        String locator = "";
        locator = testObject.getSelectorMethod() == SelectorMethod.SMART_LOCATOR && !WebUiCommonHelper.ableExecuteWithSmartLocator(webDriver) ? WebUiCommonHelper.getSelectorValue(testObject, SelectorMethod.XPATH) : WebUiCommonHelper.getSelectorValue(testObject);
        throw new WebElementNotFoundException(testObject.getObjectId(), locator);
    }

    @Override
    public List<WebElement> findElements(FindElementParams params) throws Exception {
        WebDriver webDriver = params.getWebDriver();
        TestObject testObject = params.getTestObject();
        List<WebElement> elements = this.findElementsBySelectedMethod(webDriver, testObject).getElements();
        return elements;
    }

    public FindElementsResult findElementsBySelectedMethod(WebDriver webDriver, TestObject testObject) throws Exception {
        return this.findElementsBySelectedMethod(webDriver, testObject, testObject.getSelectorMethod());
    }

    public FindElementsResult findElementsBySelectedMethod(WebDriver webDriver, TestObject testObject, SelectorMethod method) throws Exception {
        return this.findElementsBySelectedMethod(webDriver, testObject, method, false);
    }

    public FindElementsResult findElementsBySelectedMethod(WebDriver webDriver, TestObject testObject, SelectorMethod method, boolean useSmartXPath) throws Exception {
        if (this.isElementInsideShadowDOM(webDriver, testObject) && method != SelectorMethod.SMART_LOCATOR) {
            testObject.setSelectorMethod(SelectorMethod.CSS);
            return this.findElementsInsideShadowDOM(webDriver, testObject);
        }
        switch (method) {
            case BASIC: {
                return this.findElementByNormalMethods(webDriver, testObject, method);
            }
            case CSS: {
                return this.findElementByNormalMethods(webDriver, testObject, method);
            }
            case XPATH: {
                return useSmartXPath ? this.findWebElementsWithSmartXPath(webDriver, testObject) : this.findElementByNormalMethods(webDriver, testObject, method);
            }
            case IMAGE: {
                return this.findElementsByImage(webDriver, testObject);
            }
            case SMART_LOCATOR: {
                if (WebUiCommonHelper.ableExecuteWithSmartLocator(webDriver)) {
                    return this.findElementBySmartLocator(webDriver, testObject);
                }
                return this.findElementByNormalMethods(webDriver, testObject, SelectorMethod.XPATH);
            }
        }
        return this.findElementByNormalMethods(webDriver, testObject, SelectorMethod.XPATH);
    }

    private boolean isElementInsideShadowDOM(WebDriver webDriver, TestObject testObject) {
        return testObject.getParentObject() != null && testObject.isParentObjectShadowRoot();
    }

    private FindElementsResult findElementsInsideShadowDOM(WebDriver webDriver, TestObject testObject) throws Exception {
        List<WebElement> foundElements;
        String cssLocator;
        block15: {
            cssLocator = CssLocatorBuilder.buildCssSelectorLocator(testObject);
            foundElements = Collections.emptyList();
            if (!this.isElementInsideShadowDOM(webDriver, testObject)) {
                return FindElementsResult.from(cssLocator, SelectorMethod.CSS);
            }
            boolean isSwitchToParentFrame = false;
            TestObject parentObject = testObject.getParentObject();
            WebElement shadowRootElement = null;
            if (cssLocator == null) {
                throw new StepFailedException(MessageFormat.format(StringConstants.KW_EXC_WEB_ELEMENT_W_ID_DOES_NOT_HAVE_SATISFY_PROP, testObject.getObjectId()));
            }
            this.logger.logDebug(MessageFormat.format(CoreWebuiMessageConstants.MSG_INFO_WEB_ELEMENT_HAVE_PARENT_SHADOW_ROOT, testObject.getObjectId(), testObject.getParentObject().getObjectId()));
            try {
                isSwitchToParentFrame = WebUiCommonHelper.switchToParentFrame(webDriver, parentObject);
                FindElementParams findParentParams = new FindElementParams(webDriver, parentObject);
                shadowRootElement = this.findElement(findParentParams);
            }
            catch (WebElementNotFoundException webElementNotFoundException) {
                return FindElementsResult.from(cssLocator, SelectorMethod.CSS);
            }
            if (shadowRootElement == null) {
                return FindElementsResult.from(cssLocator, SelectorMethod.CSS);
            }
            try {
                try {
                    foundElements = this.doFindElementsInsideShadowDom(testObject, webDriver, cssLocator, shadowRootElement);
                    if (foundElements == null || foundElements.isEmpty()) {
                        throw new DetachedShadowRootException(MessageFormat.format(StringConstants.KW_LOG_INFO_CANNOT_FIND_WEB_ELEMENT_BY_LOCATOR, cssLocator));
                    }
                    if (isSwitchToParentFrame) {
                        WebUiCommonHelper.switchToDefaultContent();
                    }
                }
                catch (WebElementNotFoundException webElementNotFoundException) {
                    if (isSwitchToParentFrame) {
                        WebUiCommonHelper.switchToDefaultContent();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (isSwitchToParentFrame) {
                    WebUiCommonHelper.switchToDefaultContent();
                }
                throw throwable;
            }
            if (isSwitchToParentFrame) {
                WebUiCommonHelper.switchToDefaultContent();
            }
        }
        return FindElementsResult.from(foundElements, cssLocator, SelectorMethod.CSS, "");
    }

    private List<WebElement> doFindElementsInsideShadowDom(TestObject testObject, WebDriver webDriver, String cssLocator, WebElement shadowRootElement) throws WebElementNotFoundException {
        String filteredCssSelector = StringUtils.defaultString((String)cssLocator).replace("'", "\\'");
        List webElements = (List)((JavascriptExecutor)webDriver).executeScript("return arguments[0].shadowRoot.querySelectorAll('" + filteredCssSelector + "');", new Object[]{shadowRootElement});
        if (webElements != null && webElements.size() > 0) {
            this.logger.logDebug(MessageFormat.format("Found {0} web elements with id: ''{1}'' located by ''{2}''", webElements.size(), testObject.getObjectId(), cssLocator));
            return webElements;
        }
        throw new WebElementNotFoundException(testObject.getObjectId(), cssLocator);
    }

    private FindElementsResult findElementByNormalMethods(WebDriver webDriver, TestObject testObject, SelectorMethod locatorMethod) throws Exception {
        By defaultLocator = WebUiCommonHelper.buildLocator(testObject, locatorMethod);
        if (defaultLocator == null) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_EXC_WEB_ELEMENT_W_ID_DOES_NOT_HAVE_SATISFY_PROP, testObject.getObjectId()));
        }
        List foundElements = Collections.emptyList();
        foundElements = webDriver.findElements(defaultLocator);
        if (foundElements != null && !foundElements.isEmpty()) {
            this.logger.logDebug(MessageFormat.format("Found {0} web elements with id: ''{1}'' located by ''{2}''", foundElements.size(), testObject.getObjectId(), defaultLocator.toString()));
        }
        if (foundElements == null || foundElements.isEmpty()) {
            throw new WebElementNotFoundException(testObject.getObjectId(), defaultLocator);
        }
        return FindElementsResult.from(foundElements, WebUiCommonHelper.getSelectorValue(testObject, locatorMethod), locatorMethod);
    }

    private FindElementsResult findWebElementsWithSmartXPath(WebDriver webDriver, TestObject testObject) {
        if (this.isElementInsideShadowDOM(webDriver, testObject)) {
            return FindElementsResult.from(SelectorMethod.XPATH);
        }
        SelfHealingController.setLogger(this.logger);
        List allXPaths = testObject.getXpaths();
        TestObjectXpath selectedXPath = null;
        List foundElements = null;
        String screenshotPath = "";
        int i = 0;
        while (i < allXPaths.size()) {
            selectedXPath = (TestObjectXpath)allXPaths.get(i);
            String xpathValue = selectedXPath.getValue();
            if (!StringUtils.isBlank((CharSequence)xpathValue)) {
                By bySelectedXPath = By.xpath((String)selectedXPath.getValue());
                try {
                    foundElements = webDriver.findElements(bySelectedXPath);
                }
                catch (NoSuchElementException noSuchElementException) {}
                if (foundElements != null && !foundElements.isEmpty()) {
                    SelfHealingController.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_FOUND_WEB_ELEMENT_WITH_THIS_SMART_XPATH, selectedXPath.getValue()));
                    String screenshotName = selectedXPath.getName().split(":")[1];
                    screenshotPath = SelfHealingController.takeScreenShot(webDriver, (WebElement)foundElements.get(0), testObject, screenshotName);
                    break;
                }
                SelfHealingController.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_COULD_NOT_FIND_WEB_ELEMENT_WITH_THIS_SMART_XPATH, xpathValue));
            }
            ++i;
        }
        if (selectedXPath == null) {
            SelfHealingController.logInfo(StringConstants.KW_LOG_INFO_COULD_NOT_FIND_ANY_WEB_ELEMENT_WITH_SMART_XPATHS);
            return FindElementsResult.from(SelectorMethod.XPATH);
        }
        return FindElementsResult.from(foundElements, selectedXPath.getValue(), SelectorMethod.XPATH, screenshotPath);
    }

    private FindElementsResult findElementsByImage(WebDriver webDriver, TestObject testObject) {
        String screenshot = (String)testObject.getSelectorCollection().get(SelectorMethod.IMAGE);
        if (StringUtils.isBlank((CharSequence)screenshot)) {
            screenshot = testObject.getProperties().stream().filter(prop -> prop.getName().equals("screenshot")).findAny().map(screenshotProp -> screenshotProp.getValue()).orElse("");
        }
        if (StringUtils.isBlank((CharSequence)screenshot)) {
            return FindElementsResult.from(SelectorMethod.IMAGE);
        }
        List<WebElement> foundElements = ImageLocatorController.findElementByScreenShot(webDriver, screenshot, Integer.MAX_VALUE);
        return FindElementsResult.from(foundElements, screenshot, SelectorMethod.IMAGE);
    }

    private FindElementsResult findElementBySmartLocator(WebDriver webDriver, TestObject testObject) {
        List<WebElement> foundElements = Collections.emptyList();
        String smartLocator = "";
        smartLocator = (String)testObject.getSmartSelectorCollection().get(SelectorMethod.SMART_LOCATOR);
        if (StringUtils.isBlank((CharSequence)smartLocator)) {
            return FindElementsResult.from(SelectorMethod.SMART_LOCATOR);
        }
        JavascriptExecutor js = (JavascriptExecutor)webDriver;
        foundElements = new ArrayList();
        String jsLocator = String.format("return katalonSmartLocator.find_element_by_smart_locator(`%s`)", smartLocator);
        WebElement element = (WebElement)js.executeScript(jsLocator, new Object[0]);
        if (element != null) {
            foundElements.add(element);
        }
        if (foundElements != null && !foundElements.isEmpty()) {
            this.logger.logDebug(MessageFormat.format("Found {0} web elements with id: ''{1}'' located by ''{2}''", foundElements.size(), testObject.getObjectId(), smartLocator));
            return FindElementsResult.from(foundElements, smartLocator, SelectorMethod.SMART_LOCATOR);
        }
        FindElementsResult result = FindElementsResult.from(foundElements, smartLocator, SelectorMethod.SMART_LOCATOR);
        return result;
    }
}

