/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.model;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.keyword.internal.KeywordExecutionContext;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testobject.BrokenTestObject;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.webui.common.FindElementsResult;
import com.kms.katalon.core.webui.common.WebUICommonScripts;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import com.kms.katalon.core.webui.common.internal.SelfHealingController;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.model.FindElementParams;
import com.kms.katalon.core.webui.model.SeleniumElementFinder;
import com.kms.katalon.core.webui.model.WebUiElementFinder;
import com.kms.katalon.core.webui.model.WebUiLocatorProvider;
import com.kms.katalon.core.webui.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebUiElementFinderWithSelfHealing
implements SeleniumElementFinder<FindElementParams> {
    private final KeywordLogger logger = KeywordLogger.getInstance(WebUiElementFinderWithSelfHealing.class);
    private WebUiElementFinder basicElementFinder = new WebUiElementFinder();

    @Override
    public WebElement findElement(FindElementParams params) throws Exception {
        List<WebElement> foundElements = this.findElements(params);
        return foundElements != null && !foundElements.isEmpty() ? foundElements.get(0) : null;
    }

    @Override
    public List<WebElement> findElements(FindElementParams params) throws Exception {
        SelfHealingController.setLogger(this.logger);
        WebDriver webDriver = params.getWebDriver();
        TestObject testObject = params.getTestObject();
        try {
            boolean isWebPlatform = KeywordExecutionContext.isRunningWebUI();
            String runningKeyword = KeywordExecutionContext.getRunningKeyword();
            List excludeKeywords = RunConfiguration.getExcludedWebUIKeywordsFromSelfHealing();
            if (!isWebPlatform || excludeKeywords.contains(runningKeyword)) {
                return Collections.emptyList();
            }
            SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_DEFAULT_LOCATOR_FAILED_TRY_SELF_HEALING, testObject.getObjectId()));
            if (this.isInShadowDOM(testObject)) {
                return this.findElementsInShadowDOM(webDriver, testObject);
            }
            return this.performSelfHealing(webDriver, testObject);
        }
        catch (Exception exception) {
            SelfHealingController.logWarning(exception.getMessage(), exception);
            return Collections.emptyList();
        }
    }

    private List<WebElement> performSelfHealing(WebDriver webDriver, TestObject testObject) throws Exception {
        this.prepareSelfHealingDataFile();
        List<WebElement> elementsFromCandidates = this.tryHealingWithCandidates(webDriver, testObject);
        if (elementsFromCandidates != null && !elementsFromCandidates.isEmpty()) {
            return elementsFromCandidates;
        }
        return this.tryHealingWithAlternativeLocators(webDriver, testObject);
    }

    private void prepareSelfHealingDataFile() {
        String dataFileAtReportFolder = SelfHealingController.getSelfHealingDataFilePath(RunConfiguration.getReportFolder());
        SelfHealingController.prepareDataFile(dataFileAtReportFolder);
    }

    private List<WebElement> tryHealingWithCandidates(WebDriver webDriver, TestObject testObject) throws Exception {
        Set<BrokenTestObject> healingCandidates = SelfHealingController.findBrokenTestObjects(testObject);
        if (healingCandidates == null || healingCandidates.isEmpty()) {
            return null;
        }
        for (BrokenTestObject healingCandidate : healingCandidates) {
            List<WebElement> foundElements = this.tryHealingCandidate(webDriver, testObject, healingCandidate);
            if (foundElements == null || foundElements.isEmpty()) continue;
            return foundElements;
        }
        return null;
    }

    private List<WebElement> tryHealingCandidate(WebDriver webDriver, TestObject testObject, BrokenTestObject healingCandidate) throws Exception {
        TestObject healedTestObject = SelfHealingController.healTestObject(testObject, healingCandidate);
        if (!this.isValidHealedLocator(healedTestObject, testObject)) {
            return null;
        }
        FindElementParams findHealedObjectParams = new FindElementParams(webDriver, healedTestObject);
        List<WebElement> foundElements = this.basicElementFinder.findElements(findHealedObjectParams);
        if (foundElements != null && !foundElements.isEmpty()) {
            FindElementsResult findResultForReport = this.createFindResultWithScreenshot(foundElements, healedTestObject, healingCandidate);
            this.registerBrokenTestObjectAndLog(findResultForReport, testObject, webDriver);
            return foundElements;
        }
        return null;
    }

    private boolean isValidHealedLocator(TestObject healedTestObject, TestObject originalTestObject) {
        SelectorMethod healedMethod = healedTestObject.getSelectorMethod();
        String healedLocator = (String)healedTestObject.getSelectorCollection().get(healedMethod);
        if (StringUtils.isBlank((CharSequence)healedLocator)) {
            this.logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_DEBUG_HEALING_CANDIDATE_EMPTY_LOCATOR, originalTestObject.getObjectId()));
            return false;
        }
        return true;
    }

    private FindElementsResult createFindResultWithScreenshot(List<WebElement> foundElements, TestObject healedTestObject, BrokenTestObject healingCandidate) {
        FindElementsResult findResultForReport = FindElementsResult.from(foundElements, healedTestObject);
        String screenshotPath = SelfHealingController.getScreenshotAbsolutePath(healingCandidate.getPathToScreenshot());
        findResultForReport.setScreenshot(screenshotPath);
        return findResultForReport;
    }

    private List<WebElement> tryHealingWithAlternativeLocators(WebDriver webDriver, TestObject testObject) {
        SelectorMethod elementMethod = testObject.getSelectorMethod();
        WebUiLocatorProvider locatorProvider = new WebUiLocatorProvider();
        while (locatorProvider.hasNext()) {
            List<WebElement> foundElements;
            SelectorMethod currentMethod = locatorProvider.getNextLocator();
            if (!this.shouldTryLocatorMethod(currentMethod, elementMethod) || (foundElements = this.tryAlternativeLocatorMethod(webDriver, testObject, currentMethod, elementMethod)) == null || foundElements.isEmpty()) continue;
            return foundElements;
        }
        return Collections.emptyList();
    }

    private boolean shouldTryLocatorMethod(SelectorMethod currentMethod, SelectorMethod elementMethod) {
        return currentMethod != elementMethod || currentMethod == SelectorMethod.XPATH;
    }

    private List<WebElement> tryAlternativeLocatorMethod(WebDriver webDriver, TestObject testObject, SelectorMethod currentMethod, SelectorMethod elementMethod) {
        block4: {
            String locatorValue = (String)testObject.getSelectorCollection().get(currentMethod);
            if (!StringUtils.isBlank((CharSequence)locatorValue)) break block4;
            this.logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_DEBUG_SKIPPING_METHOD_EMPTY_LOCATOR, currentMethod.name(), testObject.getObjectId()));
            return null;
        }
        try {
            FindElementsResult findResult = this.findElementsWithMethod(webDriver, testObject, currentMethod, elementMethod);
            if (findResult != null && !findResult.isEmpty()) {
                this.registerBrokenTestObjectAndLog(findResult, testObject, webDriver);
                return findResult.getElements();
            }
        }
        catch (Exception exception) {
            SelfHealingController.logWarning(exception.getMessage(), exception);
        }
        return null;
    }

    private FindElementsResult findElementsWithMethod(WebDriver webDriver, TestObject testObject, SelectorMethod currentMethod, SelectorMethod elementMethod) throws Exception {
        boolean hasFindWithDefaultXPath;
        FindElementsResult findResult = null;
        boolean bl = hasFindWithDefaultXPath = elementMethod == SelectorMethod.XPATH;
        if (currentMethod == SelectorMethod.XPATH && !hasFindWithDefaultXPath) {
            findResult = this.basicElementFinder.findElementsBySelectedMethod(webDriver, testObject, currentMethod, false);
        }
        if (findResult == null || findResult.isEmpty()) {
            findResult = this.basicElementFinder.findElementsBySelectedMethod(webDriver, testObject, currentMethod, true);
        }
        return findResult;
    }

    private boolean isInShadowDOM(TestObject testObject) {
        return testObject.getParentObject() != null && testObject.isParentObjectShadowRoot();
    }

    private List<WebElement> findElementsInShadowDOM(WebDriver webDriver, TestObject testObject) throws Exception {
        FindElementsResult findElementsResult;
        Object result;
        try {
            result = this.basicElementFinder.findElementsBySelectedMethod(webDriver, testObject);
            if (result != null && !((FindElementsResult)result).isEmpty()) {
                return ((FindElementsResult)result).getElements();
            }
        }
        catch (Exception e) {
            this.logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_DEBUG_SHADOW_DOM_FIND_FAILED, testObject.getObjectId(), e.getMessage()));
        }
        result = this.findElementsWithParentHealing(webDriver, testObject);
        if (result != null && !result.isEmpty()) {
            return result;
        }
        WebUiLocatorProvider locatorProvider = new WebUiLocatorProvider();
        if (WebUiCommonHelper.ableExecuteWithSmartLocator(webDriver) && locatorProvider.isLocatorEnabled(SelectorMethod.SMART_LOCATOR) && (findElementsResult = this.basicElementFinder.findElementsBySelectedMethod(webDriver, testObject, SelectorMethod.SMART_LOCATOR, false)) != null && !findElementsResult.isEmpty()) {
            this.registerBrokenTestObjectAndLog(findElementsResult, testObject, webDriver);
            return findElementsResult.getElements();
        }
        return Collections.emptyList();
    }

    private List<WebElement> findElementsWithParentHealing(WebDriver webDriver, TestObject testObject) throws Exception {
        TestObject parentObject = testObject.getParentObject();
        if (parentObject == null) {
            return Collections.emptyList();
        }
        SelectorMethod parentMethod = parentObject.getSelectorMethod();
        String parentLocator = (String)parentObject.getSelectorCollection().get(parentMethod);
        if (StringUtils.isBlank((CharSequence)parentLocator)) {
            this.logger.logDebug(StringConstants.KW_LOG_DEBUG_PARENT_EMPTY_LOCATOR_CANNOT_HEAL);
            return Collections.emptyList();
        }
        this.logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_DEBUG_APPLYING_SELF_HEALING_TO_SHADOW_PARENT, parentObject.getObjectId()));
        List<WebElement> healedParentElements = this.performSelfHealing(webDriver, parentObject);
        if (healedParentElements != null && !healedParentElements.isEmpty()) {
            WebElement healedParentElement = healedParentElements.get(0);
            TestObject testObjectWithHealedParent = this.createTestObjectWithHealedParent(testObject, healedParentElement);
            try {
                FindElementsResult childResult = this.basicElementFinder.findElementsBySelectedMethod(webDriver, testObjectWithHealedParent);
                if (childResult != null && !childResult.isEmpty()) {
                    this.registerBrokenTestObjectAndLog(childResult, testObject, webDriver);
                    return childResult.getElements();
                }
            }
            catch (Exception e) {
                this.logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_DEBUG_SHADOW_DOM_CHILD_FIND_FAILED, e.getMessage()));
            }
        }
        this.logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_DEBUG_FAILED_TO_HEAL_SHADOW_PARENT, parentObject.getObjectId()));
        return Collections.emptyList();
    }

    private TestObject createTestObjectWithHealedParent(TestObject testObject, WebElement healedParentElement) {
        TestObject parentObject = testObject.getParentObject();
        if (parentObject != null) {
            parentObject.setCachedWebElement(healedParentElement);
        }
        return testObject;
    }

    private BrokenTestObject registerBrokenTestObjectAndLog(FindElementsResult findResult, TestObject originalTestObject, WebDriver webDriver) {
        BrokenTestObject healedTestObject = WebUiElementFinderWithSelfHealing.registerBrokenTestObject(findResult, originalTestObject, webDriver);
        SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_PROPOSE_ALTERNATE_LOCATOR, originalTestObject.getObjectId(), healedTestObject.getProposedLocator()));
        return healedTestObject;
    }

    public static BrokenTestObject registerBrokenTestObject(FindElementsResult findResult, TestObject brokenTestObject, WebDriver webDriver) {
        BrokenTestObject healedTestObject = WebUiElementFinderWithSelfHealing.registerBrokenTestObject(findResult, brokenTestObject, RunConfiguration.getReportFolder(), webDriver);
        WebUiElementFinderWithSelfHealing.registerBrokenTestObject(findResult, brokenTestObject, SelfHealingController.getSelfHealingFolderPath(), webDriver);
        KeywordExecutionContext.setHasHealedSomeObjects((boolean)true);
        return healedTestObject;
    }

    public static BrokenTestObject registerBrokenTestObject(FindElementsResult findResult, TestObject brokenTestObject, String dataFolder, WebDriver webDriver) {
        String projectDir;
        List<WebElement> foundElements = findResult.getElements();
        WebElement foundElement = foundElements.get(0);
        SelectorMethod recoveryMethod = findResult.getLocatorMethod();
        SelectorMethod proposedMethod = recoveryMethod == SelectorMethod.IMAGE ? SelectorMethod.XPATH : recoveryMethod;
        String proposedLocator = recoveryMethod == SelectorMethod.IMAGE ? WebUiElementFinderWithSelfHealing.generateNewXPath(foundElement, webDriver) : findResult.getLocator();
        String elementScreenshot = findResult.getScreenshot();
        if (StringUtils.isBlank((CharSequence)elementScreenshot)) {
            elementScreenshot = SelfHealingController.takeScreenShot(webDriver, foundElement, brokenTestObject, recoveryMethod.name());
            findResult.setScreenshot(elementScreenshot);
        }
        if (StringUtils.isNotBlank((CharSequence)elementScreenshot)) {
            try {
                String screenshotRelativePath = SelfHealingController.getRelativePathToSelfHealindDir(elementScreenshot);
                String destScreenshotPath = FilenameUtils.concat((String)dataFolder, (String)screenshotRelativePath);
                File destScreenshot = new File(destScreenshotPath);
                if (!destScreenshot.exists()) {
                    FileUtils.copyFile((File)new File(elementScreenshot), (File)destScreenshot);
                }
                elementScreenshot = destScreenshotPath;
            }
            catch (IOException exception) {
                SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_COULD_NOT_SAVE_SCREENSHOT, dataFolder, exception.getMessage()), exception);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)elementScreenshot) && FileUtil.isInBaseFolder(elementScreenshot, projectDir = RunConfiguration.getProjectDir())) {
            elementScreenshot = FileUtil.getRelativePath(elementScreenshot, projectDir);
        }
        return SelfHealingController.registerBrokenTestObject(brokenTestObject, proposedLocator, proposedMethod, recoveryMethod, elementScreenshot, dataFolder);
    }

    public static String generateNewXPath(WebElement element, WebDriver webDriver) {
        Map<String, List<String>> generatedXPaths = WebUICommonScripts.generateXPaths(webDriver, element);
        List xpathsPriority = RunConfiguration.getXPathsPriority();
        for (Pair xpath : xpathsPriority) {
            if (!generatedXPaths.containsKey(xpath.getLeft()) || generatedXPaths.get(xpath.getLeft()).isEmpty()) continue;
            return generatedXPaths.get(xpath.getLeft()).get(0);
        }
        return WebUICommonScripts.generateXPath(webDriver, element);
    }
}

