/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.mobile.core.models;

import com.katalon.mobile.core.enums.MobileDevicePlatform;
import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.ICapturedObjectAttribute;
import com.katalon.recorder.core.domain.model.ICapturedObjectXPath;
import com.katalon.recorder.core.domain.model.WebViewLocator;
import com.katalon.recorder.mobile.core.models.IMobileCapturedObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class MobileCapturedObject
implements IMobileCapturedObject {
    public static final Set<String> STABLE_ATTRIBUTES;
    private static List<String> IGNORED_ATTRIBUTES;
    private String id;
    private String name;
    private String description;
    private ICapturedObject parent;
    private LocatorType locatorType;
    private Map<LocatorType, String> locatorCollection = new HashMap<LocatorType, String>();
    private List<ICapturedObjectAttribute> attributes = new ArrayList<ICapturedObjectAttribute>();
    private List<ICapturedObjectXPath> xpaths = new ArrayList<ICapturedObjectXPath>();
    private MobileDevicePlatform devicePlatform;

    static {
        IGNORED_ATTRIBUTES = Arrays.asList("x", "y", "width", "height", "bounds", "enabled");
        HashSet<String> stable = new HashSet<String>();
        stable.add("resource-id");
        stable.add("content-desc");
        stable.add("class");
        stable.add("text");
        stable.add("name");
        stable.add("label");
        stable.add("value");
        stable.add("type");
        STABLE_ATTRIBUTES = Collections.unmodifiableSet(stable);
    }

    public void addLocator(LocatorType locatorType, String locator) {
        this.locatorCollection.put(locatorType, locator);
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public MobileDevicePlatform getDevicePlatform() {
        return this.devicePlatform;
    }

    public Integer getHashValue() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        Map sortedAttributes = this.getAttributes().stream().sorted(Comparator.comparing(ICapturedObjectAttribute::getName)).collect(Collectors.toMap(ICapturedObjectAttribute::getName, ICapturedObjectAttribute::getValue, (v1, v2) -> v1, LinkedHashMap::new));
        for (Map.Entry attribute : sortedAttributes.entrySet()) {
            String key = (String)attribute.getKey();
            String val = (String)attribute.getValue();
            if (IGNORED_ATTRIBUTES.contains(key) || !StringUtils.isNotBlank((CharSequence)val)) continue;
            hashCodeBuilder.append((Object)val);
        }
        hashCodeBuilder.append((Object)this.getLocatorType().toString());
        return hashCodeBuilder.toHashCode();
    }

    public String getId() {
        return this.id;
    }

    public Map<LocatorType, String> getLocators() {
        return this.locatorCollection;
    }

    public List<WebViewLocator> getWebViewLocators() {
        return this.locatorCollection.entrySet().stream().map(e -> new WebViewLocator((LocatorType)e.getKey(), (String)e.getValue())).toList();
    }

    public LocatorType getLocatorType() {
        return this.locatorType;
    }

    public String getName() {
        return this.name;
    }

    public ICapturedObject getParent() {
        return this.parent;
    }

    public List<ICapturedObjectAttribute> getAttributes() {
        return this.attributes;
    }

    public List<ICapturedObjectXPath> getXPaths() {
        return this.xpaths;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setDevicePlatform(MobileDevicePlatform devicePlatform) {
        this.devicePlatform = devicePlatform;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLocators(Map<LocatorType, String> locators) {
        this.locatorCollection.clear();
        if (locators != null && locators.size() > 0) {
            this.locatorCollection.putAll(locators);
        }
    }

    public void setLocatorType(LocatorType locatorType) {
        this.locatorType = locatorType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(ICapturedObject parent) {
        this.parent = parent;
    }

    public void setAttributes(List<ICapturedObjectAttribute> attributes) {
        this.attributes.clear();
        if (attributes != null && attributes.size() > 0) {
            this.attributes.addAll(attributes);
        }
    }

    public void setXPaths(List<ICapturedObjectXPath> xPaths) {
        this.xpaths.clear();
        if (xPaths != null && xPaths.size() > 0) {
            this.xpaths.addAll(xPaths);
        }
    }

    public void addXPath(ICapturedObjectXPath xPath) {
        this.xpaths.add(xPath);
    }

    public List<ICapturedObject> getChildren() {
        return null;
    }

    public void setChildren(List<ICapturedObject> children) {
    }

    public void addChild(ICapturedObject child) {
    }

    public String getLocator(LocatorType type) {
        return this.locatorCollection.get(type);
    }

    public void addAttribute(ICapturedObjectAttribute attribute) {
        this.attributes.stream().filter(a -> a.getName().equals(attribute.getName())).findFirst().ifPresentOrElse(existing -> {
            existing.setValue(attribute.getValue());
            existing.setOperator(attribute.getOperator());
            existing.setEnabled(attribute.getEnabled());
        }, () -> this.attributes.add(attribute));
    }

    public Boolean hasChild() {
        return null;
    }
}

