/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.mobile.core.models;

import com.katalon.recorder.core.constant.RecordingConnectionStatus;
import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.IVariable;
import com.katalon.recorder.mobile.core.application.IMobileRecorderSession;
import com.katalon.recorder.mobile.core.interfaces.IMobileStartRecordingRequest;
import com.katalon.recorder.mobile.core.models.IMobileRecordingConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class MobileRecorderSession
implements IMobileRecorderSession {
    private IMobileStartRecordingRequest mobileRecordingRequest;
    private final ConcurrentHashMap<String, IMobileRecordingConnection> recordingConnections;
    private List<IStep> steps = new ArrayList<IStep>();
    private List<ICapturedObject> capturedObjects = new ArrayList<ICapturedObject>();
    private List<IVariable> variables = new ArrayList<IVariable>();
    private boolean pausing = false;

    public MobileRecorderSession() {
        this.recordingConnections = new ConcurrentHashMap();
    }

    @Override
    public List<IStep> getSteps() {
        return this.steps;
    }

    @Override
    public void setSteps(IStep[] steps) {
        if (steps == null) {
            this.steps = new ArrayList<IStep>();
            return;
        }
        this.steps = new ArrayList<IStep>(Arrays.asList(steps));
    }

    @Override
    public void addStep(IStep step) {
        if (step != null) {
            this.steps.add(step);
        }
    }

    public void updateStep(IStep step) {
        int index = this.steps.indexOf(step);
        if (index != -1) {
            this.steps.set(index, step);
        }
    }

    @Override
    public List<ICapturedObject> getObjects() {
        return this.capturedObjects;
    }

    @Override
    public void addObject(ICapturedObject capturedObject) {
        if (capturedObject != null) {
            this.capturedObjects.add(capturedObject);
        }
    }

    public void updateObject(ICapturedObject capturedObject) {
        int index = this.capturedObjects.indexOf(capturedObject);
        if (index != -1) {
            this.capturedObjects.set(index, capturedObject);
        }
    }

    public void deleteObject(ICapturedObject capturedObject) {
        this.capturedObjects.remove(capturedObject);
    }

    public void reorderObject(ICapturedObject capturedObject, int newIndex) {
        if (this.capturedObjects.remove(capturedObject)) {
            this.capturedObjects.add(newIndex, capturedObject);
        }
    }

    @Override
    public List<IVariable> getVariables() {
        return this.variables;
    }

    @Override
    public void addVariable(IVariable variable) {
        if (variable != null) {
            this.variables.add(variable);
        }
    }

    @Override
    public void setVariables(IVariable[] variables) {
        if (variables == null) {
            this.variables = new ArrayList<IVariable>();
            return;
        }
        this.variables = new ArrayList<IVariable>(Arrays.asList(variables));
    }

    @Override
    public void pauseRecording(String recordingConnectionId) {
        if (StringUtils.isNotEmpty((CharSequence)recordingConnectionId)) {
            this.pausing = true;
            IMobileRecordingConnection connection = this.recordingConnections.get(recordingConnectionId);
            if (connection != null) {
                connection.setStatus(RecordingConnectionStatus.PAUSED);
            }
        }
    }

    @Override
    public void resumeRecording(String recordingConnectionId) {
        if (StringUtils.isNotEmpty((CharSequence)recordingConnectionId)) {
            this.pausing = false;
            IMobileRecordingConnection connection = this.recordingConnections.get(recordingConnectionId);
            if (connection != null) {
                connection.setStatus(RecordingConnectionStatus.RECORDING);
            }
        }
    }

    @Override
    public boolean isRecordingPaused() {
        return this.pausing;
    }

    @Override
    public IMobileStartRecordingRequest getRecordingRequest() {
        return this.mobileRecordingRequest;
    }

    @Override
    public void setRecordingRequest(IMobileStartRecordingRequest recordingRequest) {
        this.mobileRecordingRequest = recordingRequest;
    }

    @Override
    public IMobileRecordingConnection getRecordingConnection(String recordingConnectionId) {
        return this.recordingConnections.get(recordingConnectionId);
    }

    @Override
    public List<IMobileRecordingConnection> getRecordingConnections() {
        return this.recordingConnections.values().stream().toList();
    }

    @Override
    public void addMobileRecordingConnection(IMobileRecordingConnection connection) {
        this.recordingConnections.put(connection.getRecordingConnectionId(), connection);
    }
}

