/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.codehaus.jdt.groovy.integration.LanguageSupportFactory;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.jdt.internal.codeassist.SelectionEngine;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.LambdaExpression;
import org.eclipse.jdt.internal.core.LambdaFactory;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.ResolvedBinaryField;
import org.eclipse.jdt.internal.core.ResolvedBinaryMethod;
import org.eclipse.jdt.internal.core.ResolvedBinaryType;
import org.eclipse.jdt.internal.core.ResolvedSourceField;
import org.eclipse.jdt.internal.core.ResolvedSourceMethod;
import org.eclipse.jdt.internal.core.ResolvedSourceType;
import org.eclipse.jdt.internal.core.util.DeduplicationUtil;
import org.eclipse.jdt.internal.core.util.HandleFactory;
import org.eclipse.jdt.internal.core.util.Util;

public class SelectionRequestor
implements ISelectionRequestor {
    protected NameLookup nameLookup;
    protected Openable openable;
    protected IJavaElement[] elements = JavaElement.NO_ELEMENTS;
    protected int elementIndex = -1;
    protected HandleFactory handleFactory = new HandleFactory();

    public SelectionRequestor(NameLookup nameLookup, Openable openable) {
        this.nameLookup = nameLookup;
        this.openable = openable;
    }

    private void acceptBinaryMethod(IType type, IMethod method, char[] uniqueKey, boolean isConstructor) {
        try {
            if (!isConstructor || ((JavaElement)((Object)method)).getClassFile().getBuffer() == null) {
                if (uniqueKey != null) {
                    method = new ResolvedBinaryMethod((JavaElement)method.getParent(), method.getElementName(), method.getParameterTypes(), new String(uniqueKey), method.getOccurrenceCount());
                }
                this.addElement(method);
                if (SelectionEngine.DEBUG) {
                    JavaModelManager.trace("SELECTION - accept method(" + method.toString() + ")");
                }
            } else {
                ISourceRange range = method.getSourceRange();
                if (range.getOffset() != -1 && range.getLength() != 0) {
                    if (uniqueKey != null) {
                        method = new ResolvedBinaryMethod((JavaElement)method.getParent(), method.getElementName(), method.getParameterTypes(), new String(uniqueKey), method.getOccurrenceCount());
                    }
                    this.addElement(method);
                    if (SelectionEngine.DEBUG) {
                        JavaModelManager.trace("SELECTION - accept method(" + method.toString() + ")");
                    }
                } else {
                    this.addElement(type);
                    if (SelectionEngine.DEBUG) {
                        JavaModelManager.trace("SELECTION - accept type(" + type.toString() + ")");
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    protected void acceptBinaryMethod(IType type, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, String[] parameterSignatures, char[][] typeParameterNames, char[][][] typeParameterBoundNames, char[] uniqueKey, boolean isConstructor) {
        IMethod method = type.getMethod(new String(selector), parameterSignatures);
        if (method.exists()) {
            IMethod[] methods;
            if (typeParameterNames != null && typeParameterNames.length != 0 && (methods = type.findMethods(method)) != null && methods.length > 1) {
                IMethod[] iMethodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod m = iMethodArray[n2];
                    if (this.areTypeParametersCompatible(m, typeParameterNames, typeParameterBoundNames)) {
                        this.acceptBinaryMethod(type, method, uniqueKey, isConstructor);
                    }
                    ++n2;
                }
                return;
            }
            this.acceptBinaryMethod(type, method, uniqueKey, isConstructor);
        }
    }

    @Override
    public void acceptModule(char[] moduleName, char[] uniqueKey, int start, int end) {
        IModuleDescription module = this.resolveModule(moduleName);
        this.addElement(module);
    }

    @Override
    public void acceptType(char[] packageName, char[] typeName, int modifiers, boolean isDeclaration, char[] uniqueKey, int start, int end) {
        int acceptFlags = 0;
        int kind = modifiers & 0x6200;
        switch (kind) {
            case 8192: 
            case 8704: {
                acceptFlags = 16;
                break;
            }
            case 16384: {
                acceptFlags = 8;
                break;
            }
            case 512: {
                acceptFlags = 4;
                break;
            }
            default: {
                acceptFlags = 0x1000002;
            }
        }
        IType type = null;
        if (isDeclaration) {
            type = this.resolveTypeByLocation(packageName, typeName, acceptFlags, start, end);
        } else {
            type = this.resolveType(packageName, typeName, acceptFlags);
            if (type != null) {
                String key = uniqueKey == null ? type.getKey() : new String(uniqueKey);
                type = type.isBinary() ? new ResolvedBinaryType((JavaElement)type.getParent(), type.getElementName(), key, type.getOccurrenceCount()) : new ResolvedSourceType((JavaElement)type.getParent(), type.getElementName(), key, type.getOccurrenceCount());
            }
        }
        if (type != null) {
            this.addElement(type);
            if (SelectionEngine.DEBUG) {
                JavaModelManager.trace("SELECTION - accept type(" + type.toString() + ")");
            }
        }
    }

    public void acceptType(IType type) {
        String key = type.getKey();
        type = type.isBinary() ? new ResolvedBinaryType((JavaElement)type.getParent(), type.getElementName(), key, type.getOccurrenceCount()) : new ResolvedSourceType((JavaElement)type.getParent(), type.getElementName(), key, type.getOccurrenceCount());
        this.addElement(type);
        if (SelectionEngine.DEBUG) {
            JavaModelManager.trace("SELECTION - accept type(" + type.toString() + ")");
        }
    }

    @Override
    public void acceptError(CategorizedProblem error) {
    }

    @Override
    public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, boolean isDeclaration, char[] uniqueKey, int start, int end) {
        if (isDeclaration) {
            IType type = this.resolveTypeByLocation(declaringTypePackageName, declaringTypeName, 0x100001E, start, end);
            if (type != null) {
                try {
                    IField[] comps;
                    IField[] fields = type.getFields();
                    if (type.isRecord() && (comps = type.getRecordComponents()).length > 0) {
                        IField[] f = fields;
                        fields = Arrays.copyOf(f, f.length + comps.length);
                        System.arraycopy(comps, 0, fields, f.length, comps.length);
                    }
                    IField[] iFieldArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IField field = iFieldArray[n2];
                        ISourceRange range = field.getNameRange();
                        if (range.getOffset() <= start && range.getOffset() + range.getLength() >= end && field.getElementName().equals(new String(name))) {
                            this.addElement(field);
                            if (SelectionEngine.DEBUG) {
                                JavaModelManager.trace("SELECTION - accept field(" + field.toString() + ")");
                            }
                            return;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    return;
                }
            }
        } else {
            IField field;
            IType type = this.resolveType(declaringTypePackageName, declaringTypeName, 0x100001E);
            if (type != null && (field = type.getField(new String(name))).exists()) {
                if (uniqueKey != null) {
                    field = field.isBinary() ? new ResolvedBinaryField((JavaElement)field.getParent(), field.getElementName(), new String(uniqueKey), field.getOccurrenceCount()) : new ResolvedSourceField((JavaElement)field.getParent(), field.getElementName(), new String(uniqueKey), field.getOccurrenceCount());
                }
                this.addElement(field);
                if (SelectionEngine.DEBUG) {
                    JavaModelManager.trace("SELECTION - accept field(" + field.toString() + ")");
                }
            }
        }
    }

    public void acceptLocalField(FieldBinding fieldBinding) {
        IType type;
        IField field;
        IJavaElement res;
        if (fieldBinding.declaringClass instanceof ParameterizedTypeBinding) {
            LocalTypeBinding localTypeBinding = (LocalTypeBinding)((ParameterizedTypeBinding)fieldBinding.declaringClass).genericType();
            res = this.findLocalElement(localTypeBinding.sourceStart());
        } else {
            SourceTypeBinding typeBinding = (SourceTypeBinding)fieldBinding.declaringClass;
            res = this.findLocalElement(typeBinding.sourceStart());
        }
        if (res != null && res.getElementType() == 7 && (field = (type = (IType)res).getField(new String(fieldBinding.name))).exists()) {
            char[] uniqueKey = fieldBinding.computeUniqueKey();
            field = field.isBinary() ? new ResolvedBinaryField((JavaElement)field.getParent(), field.getElementName(), new String(uniqueKey), field.getOccurrenceCount()) : new ResolvedSourceField((JavaElement)field.getParent(), field.getElementName(), new String(uniqueKey), field.getOccurrenceCount());
            this.addElement(field);
            if (SelectionEngine.DEBUG) {
                JavaModelManager.trace("SELECTION - accept field(" + field.toString() + ")");
            }
        }
    }

    public void acceptLocalMethod(MethodBinding methodBinding) {
        IJavaElement res = this.findLocalElement(methodBinding.original().sourceStart());
        if (res != null) {
            if (res.getElementType() == 9) {
                IMethod method = (IMethod)res;
                char[] uniqueKey = methodBinding.computeUniqueKey();
                res = method.isBinary() ? new ResolvedBinaryMethod((JavaElement)res.getParent(), method.getElementName(), method.getParameterTypes(), new String(uniqueKey), method.getOccurrenceCount()) : new ResolvedSourceMethod((JavaElement)res.getParent(), method.getElementName(), method.getParameterTypes(), new String(uniqueKey), method.getOccurrenceCount());
                this.addElement(res);
                if (SelectionEngine.DEBUG) {
                    JavaModelManager.trace("SELECTION - accept method(" + res.toString() + ")");
                }
            } else if (methodBinding.selector == TypeConstants.INIT && res.getElementType() == 7) {
                res = ((JavaElement)res).resolved((Binding)methodBinding.declaringClass);
                this.addElement(res);
                if (SelectionEngine.DEBUG) {
                    JavaModelManager.trace("SELECTION - accept type(" + res.toString() + ")");
                }
            }
        }
    }

    public void acceptLocalType(TypeBinding typeBinding) {
        IJavaElement res = null;
        if (typeBinding instanceof ParameterizedTypeBinding) {
            LocalTypeBinding localTypeBinding = (LocalTypeBinding)((ParameterizedTypeBinding)typeBinding).genericType();
            res = this.findLocalElement(localTypeBinding.sourceStart());
        } else if (typeBinding instanceof SourceTypeBinding) {
            res = this.findLocalElement(((SourceTypeBinding)typeBinding).sourceStart());
        }
        if (res != null && res.getElementType() == 7) {
            res = ((JavaElement)res).resolved((Binding)typeBinding);
            this.addElement(res);
            if (SelectionEngine.DEBUG) {
                JavaModelManager.trace("SELECTION - accept type(" + res.toString() + ")");
            }
        }
    }

    public void acceptLocalTypeParameter(TypeVariableBinding typeVariableBinding) {
        IType type;
        ITypeParameter typeParameter;
        IJavaElement res;
        if (typeVariableBinding.declaringElement instanceof ParameterizedTypeBinding) {
            LocalTypeBinding localTypeBinding = (LocalTypeBinding)((ParameterizedTypeBinding)typeVariableBinding.declaringElement).genericType();
            res = this.findLocalElement(localTypeBinding.sourceStart());
        } else {
            SourceTypeBinding typeBinding = (SourceTypeBinding)typeVariableBinding.declaringElement;
            res = this.findLocalElement(typeBinding.sourceStart());
        }
        if (res != null && res.getElementType() == 7 && (typeParameter = (type = (IType)res).getTypeParameter(new String(typeVariableBinding.sourceName))).exists()) {
            this.addElement(typeParameter);
            if (SelectionEngine.DEBUG) {
                JavaModelManager.trace("SELECTION - accept type parameter(" + typeParameter.toString() + ")");
            }
        }
    }

    public void acceptLocalMethodTypeParameter(TypeVariableBinding typeVariableBinding) {
        IMethod method;
        ITypeParameter typeParameter;
        MethodBinding methodBinding = (MethodBinding)typeVariableBinding.declaringElement;
        IJavaElement res = this.findLocalElement(methodBinding.sourceStart());
        if (res != null && res.getElementType() == 9 && (typeParameter = (method = (IMethod)res).getTypeParameter(new String(typeVariableBinding.sourceName))).exists()) {
            this.addElement(typeParameter);
            if (SelectionEngine.DEBUG) {
                JavaModelManager.trace("SELECTION - accept type parameter(" + typeParameter.toString() + ")");
            }
        }
    }

    public void acceptLocalVariable(LocalVariableBinding binding, ICompilationUnit unit) {
        IJavaElement parent;
        AbstractVariableDeclaration local = binding.declaration;
        if (binding.declaringScope.isLambdaSubscope() && unit instanceof org.eclipse.jdt.core.ICompilationUnit) {
            HashSet existingElements = new HashSet();
            knownScopes = new HashMap();
            parent = this.handleFactory.createElement((Scope)binding.declaringScope, local.sourceStart, (org.eclipse.jdt.core.ICompilationUnit)unit, existingElements, (HashMap)knownScopes);
        } else {
            ConstructorDeclaration cd;
            parent = binding.isParameter() && (knownScopes = binding.declaringScope.referenceContext()) instanceof ConstructorDeclaration && (cd = (ConstructorDeclaration)knownScopes).isCompactConstructor() ? this.findLocalElement(cd.sourceStart) : this.findLocalElement(local.sourceStart, binding.declaringScope.methodScope());
        }
        JavaElement localVar = null;
        if (parent != null) {
            String typeSig = null;
            typeSig = local.type == null || local.type.isTypeNameVar((Scope)binding.declaringScope) && binding.type != null && !binding.type.isAnonymousType() ? (local.initialization instanceof CastExpression ? Util.typeSignature(((CastExpression)local.initialization).type) : Signature.createTypeSignature(binding.type.signableName(), true)) : Util.typeSignature(local.type);
            localVar = new LocalVariable((JavaElement)parent, DeduplicationUtil.toString(local.name), local.declarationSourceStart, local.declarationSourceEnd, local.sourceStart, local.sourceEnd, typeSig, local.annotations, local.modifiers, local.getKind() == 5);
        }
        if (localVar != null) {
            this.addElement(localVar);
            if (SelectionEngine.DEBUG) {
                JavaModelManager.trace("SELECTION - accept local variable(" + localVar.toString() + ")");
            }
        }
    }

    public void acceptLambdaMethod(MethodBinding binding, ICompilationUnit unit) {
        if (binding.sourceLambda() != null) {
            HashSet existingElements = new HashSet();
            HashMap knownScopes = new HashMap();
            org.eclipse.jdt.internal.compiler.ast.LambdaExpression lambdaExpression = binding.sourceLambda();
            IJavaElement sourceMethod = this.handleFactory.createElement((Scope)lambdaExpression.getScope(), lambdaExpression.sourceStart, (org.eclipse.jdt.core.ICompilationUnit)unit, existingElements, knownScopes);
            this.addElement(sourceMethod);
        }
    }

    @Override
    public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, String enclosingDeclaringTypeSignature, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, String[] parameterSignatures, char[][] typeParameterNames, char[][][] typeParameterBoundNames, boolean isConstructor, boolean isDeclaration, char[] uniqueKey, int start, int end) {
        IJavaElement[] previousElement = this.elements;
        int previousElementIndex = this.elementIndex;
        this.elements = JavaElement.NO_ELEMENTS;
        this.elementIndex = -1;
        if (isDeclaration) {
            type = this.resolveTypeByLocation(declaringTypePackageName, declaringTypeName, 0x100001E, start, end);
            if (type != null) {
                this.acceptMethodDeclaration(type, selector, start, end);
            }
        } else {
            type = this.resolveType(declaringTypePackageName, declaringTypeName, 0x100001E);
            if (type != null) {
                if (type.isBinary()) {
                    IType declaringDeclaringType = type.getDeclaringType();
                    boolean isStatic = false;
                    try {
                        isStatic = Flags.isStatic(type.getFlags());
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                    if (declaringDeclaringType != null && isConstructor && !isStatic) {
                        int length = ((char[][])parameterPackageNames).length;
                        char[][] cArray = parameterPackageNames;
                        char[][] cArrayArray = new char[length + 1][];
                        parameterPackageNames = cArrayArray;
                        System.arraycopy(cArray, 0, cArrayArray, 1, length);
                        char[][] cArray2 = parameterTypeNames;
                        char[][] cArrayArray2 = new char[length + 1][];
                        parameterTypeNames = cArrayArray2;
                        System.arraycopy(cArray2, 0, cArrayArray2, 1, length);
                        String[] stringArray = parameterSignatures;
                        parameterSignatures = new String[length + 1];
                        System.arraycopy(stringArray, 0, parameterSignatures, 1, length);
                        parameterPackageNames[0] = declaringDeclaringType.getPackageFragment().getElementName().toCharArray();
                        parameterTypeNames[0] = declaringDeclaringType.getTypeQualifiedName().toCharArray();
                        parameterSignatures[0] = Signature.getTypeErasure(enclosingDeclaringTypeSignature);
                    }
                    this.acceptBinaryMethod(type, selector, (char[][])parameterPackageNames, (char[][])parameterTypeNames, parameterSignatures, typeParameterNames, typeParameterBoundNames, uniqueKey, isConstructor);
                } else {
                    this.acceptSourceMethod(type, selector, (char[][])parameterPackageNames, (char[][])parameterTypeNames, parameterSignatures, typeParameterNames, typeParameterBoundNames, uniqueKey);
                }
            }
        }
        if (previousElementIndex > -1) {
            int elementsLength = this.elementIndex + previousElementIndex + 2;
            if (elementsLength > this.elements.length) {
                this.elements = new IJavaElement[elementsLength * 2 + 1];
                System.arraycopy(this.elements, 0, this.elements, 0, this.elementIndex + 1);
            }
            System.arraycopy(previousElement, 0, this.elements, this.elementIndex + 1, previousElementIndex + 1);
            this.elementIndex += previousElementIndex + 1;
        }
    }

    @Override
    public void acceptPackage(char[] packageName) {
        IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(new String(packageName), false);
        if (pkgs != null) {
            IPackageFragment[] iPackageFragmentArray = pkgs;
            int n = pkgs.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment pkg = iPackageFragmentArray[n2];
                this.addElement(pkg);
                if (SelectionEngine.DEBUG) {
                    JavaModelManager.trace("SELECTION - accept package(" + pkg.toString() + ")");
                }
                ++n2;
            }
        }
    }

    protected void acceptSourceMethod(IType type, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, String[] parameterSignatures, char[][] typeParameterNames, char[][][] typeParameterBoundNames, char[] uniqueKey) {
        String name;
        block23: {
            name = new String(selector);
            IMethod[] methods = null;
            try {
                IField[] method;
                IMethod[] iMethodArray = methods = type.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    IField[] m = iMethodArray[n2];
                    if (m.getElementName().equals(name) && m.getParameterTypes().length == parameterTypeNames.length) {
                        method = m;
                        if (uniqueKey != null) {
                            method = new ResolvedSourceMethod((JavaElement)method.getParent(), method.getElementName(), method.getParameterTypes(), new String(uniqueKey), method.getOccurrenceCount());
                        }
                        this.addElement((IJavaElement)method);
                    }
                    ++n2;
                }
                if (CharOperation.prefixEquals((char[])"lambda$".toCharArray(), (char[])selector)) {
                    this.addElement(type.getMethod(name, parameterSignatures));
                }
                if (this.elementIndex >= 0 || uniqueKey == null || !LanguageSupportFactory.isInterestingProject(type.getJavaProject().getProject()) || !LanguageSupportFactory.isInterestingSourceFile(type.getCompilationUnit().getElementName()) || !name.matches("(?:get|set|is).*") || parameterTypeNames.length != (selector[0] == 's' ? 1 : 0)) break block23;
                String prop = Introspector.decapitalize(name.substring(selector[0] == 'i' ? 2 : 3));
                method = type.getFields();
                int n3 = method.length;
                n = 0;
                while (n < n3) {
                    IField field = method[n];
                    if (field.getElementName().equals(prop) && Flags.isPrivate(field.getFlags())) {
                        String key = String.valueOf(uniqueKey).replace(name + "(", prop + ")");
                        key = selector[0] == 's' ? key.substring(0, key.lastIndexOf(41)) : key.replace("))", ")");
                        ResolvedSourceField property = new ResolvedSourceField((JavaElement)((Object)type), prop, key);
                        property.setOccurrenceCount(1);
                        this.addElement(property);
                        break;
                    }
                    ++n;
                }
            }
            catch (JavaModelException e) {
                return;
            }
        }
        if (this.elementIndex == -1) {
            try {
                IField comp;
                if (type.isRecord() && (comp = type.getRecordComponent(name)) != null && !Flags.isStatic(comp.getFlags())) {
                    this.addElement(comp);
                    if (SelectionEngine.DEBUG) {
                        JavaModelManager.trace("SELECTION - accept field(" + comp.toString() + ")");
                    }
                }
            }
            catch (JavaModelException comp) {
                // empty catch block
            }
            if (this.elementIndex == -1) {
                this.addElement(type);
                if (SelectionEngine.DEBUG) {
                    JavaModelManager.trace("SELECTION - accept type(" + type.toString() + ")");
                }
            }
            return;
        }
        if (this.elementIndex == 0) {
            if (SelectionEngine.DEBUG) {
                JavaModelManager.trace("SELECTION - accept method(" + this.elements[0].toString() + ")");
            }
            return;
        }
        IJavaElement[] matches = this.elements;
        int matchesIndex = this.elementIndex;
        this.elements = JavaElement.NO_ELEMENTS;
        this.elementIndex = -1;
        int i = 0;
        while (i <= matchesIndex) {
            IMethod method = (IMethod)matches[i];
            String[] signatures = method.getParameterTypes();
            boolean match = true;
            int p = 0;
            while (p < signatures.length) {
                char[] simpleParameterName;
                String simpleName = Signature.getSimpleName(Signature.toString(Signature.getTypeErasure(signatures[p])));
                if (!simpleName.equals(new String(simpleParameterName = CharOperation.lastSegment((char[])parameterTypeNames[p], (char)'.')))) {
                    match = false;
                    break;
                }
                ++p;
            }
            if (match && !this.areTypeParametersCompatible(method, typeParameterNames, typeParameterBoundNames)) {
                match = false;
            }
            if (match) {
                this.addElement(method);
                if (SelectionEngine.DEBUG) {
                    JavaModelManager.trace("SELECTION - accept method(" + method.toString() + ")");
                }
            }
            ++i;
        }
    }

    protected void acceptMethodDeclaration(IType type, char[] selector, int start, int end) {
        String name = new String(selector);
        IMethod[] methods = null;
        try {
            IMethod[] iMethodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                ISourceRange range = method.getNameRange();
                if (range.getOffset() <= start && range.getOffset() + range.getLength() >= end && method.getElementName().equals(name)) {
                    this.addElement(method);
                    if (SelectionEngine.DEBUG) {
                        JavaModelManager.trace("SELECTION - accept method(" + this.elements[0].toString() + ")");
                    }
                    return;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            return;
        }
        this.addElement(type);
        if (SelectionEngine.DEBUG) {
            JavaModelManager.trace("SELECTION - accept type(" + type.toString() + ")");
        }
    }

    @Override
    public void acceptTypeParameter(char[] declaringTypePackageName, char[] declaringTypeName, char[] typeParameterName, boolean isDeclaration, int start, int end) {
        IType type = isDeclaration ? this.resolveTypeByLocation(declaringTypePackageName, declaringTypeName, 0x100001E, start, end) : this.resolveType(declaringTypePackageName, declaringTypeName, 0x100001E);
        if (type != null) {
            ITypeParameter typeParameter = type.getTypeParameter(new String(typeParameterName));
            if (typeParameter == null) {
                this.addElement(type);
                if (SelectionEngine.DEBUG) {
                    JavaModelManager.trace("SELECTION - accept type(" + type.toString() + ")");
                }
            } else {
                this.addElement(typeParameter);
                if (SelectionEngine.DEBUG) {
                    JavaModelManager.trace("SELECTION - accept type parameter(" + typeParameter.toString() + ")");
                }
            }
        }
    }

    @Override
    public void acceptMethodTypeParameter(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, int selectorStart, int selectorEnd, char[] typeParameterName, boolean isDeclaration, int start, int end) {
        IType type = this.resolveTypeByLocation(declaringTypePackageName, declaringTypeName, 0x100001E, selectorStart, selectorEnd);
        if (type != null) {
            IMethod method = null;
            String name = new String(selector);
            IMethod[] methods = null;
            try {
                methods = type.getMethods();
                int i = 0;
                while (i < methods.length) {
                    ISourceRange range = methods[i].getNameRange();
                    if (range.getOffset() >= selectorStart && range.getOffset() + range.getLength() <= selectorEnd && methods[i].getElementName().equals(name)) {
                        method = methods[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (JavaModelException i) {
                // empty catch block
            }
            if (method == null) {
                this.addElement(type);
                if (SelectionEngine.DEBUG) {
                    JavaModelManager.trace("SELECTION - accept type(" + type.toString() + ")");
                }
            } else {
                ITypeParameter typeParameter = method.getTypeParameter(new String(typeParameterName));
                if (typeParameter == null) {
                    this.addElement(method);
                    if (SelectionEngine.DEBUG) {
                        JavaModelManager.trace("SELECTION - accept method(" + method.toString() + ")");
                    }
                } else {
                    this.addElement(typeParameter);
                    if (SelectionEngine.DEBUG) {
                        JavaModelManager.trace("SELECTION - accept method type parameter(" + typeParameter.toString() + ")");
                    }
                }
            }
        }
    }

    protected void addElement(IJavaElement element) {
        int elementLength = this.elementIndex + 1;
        int i = 0;
        while (i < elementLength) {
            if (this.elements[i].equals(element)) {
                return;
            }
            ++i;
        }
        if (elementLength == this.elements.length) {
            this.elements = new IJavaElement[elementLength * 2 + 1];
            System.arraycopy(this.elements, 0, this.elements, 0, elementLength);
        }
        this.elements[++this.elementIndex] = element;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean areTypeParametersCompatible(IMethod method, char[][] typeParameterNames, char[][][] typeParameterBoundNames) {
        try {
            int length2;
            ITypeParameter[] typeParameters = method.getTypeParameters();
            int length1 = typeParameters == null ? 0 : typeParameters.length;
            int n = length2 = typeParameterNames == null ? 0 : typeParameterNames.length;
            if (length1 != length2) {
                return false;
            }
            int j = 0;
            block2: while (true) {
                int boundCount;
                if (j >= length1) {
                    return true;
                }
                ITypeParameter typeParameter = typeParameters[j];
                String typeParameterName = typeParameter.getElementName();
                if (!typeParameterName.equals(new String(typeParameterNames[j]))) {
                    return false;
                }
                String[] bounds = typeParameter.getBounds();
                int n2 = boundCount = typeParameterBoundNames[j] == null ? 0 : typeParameterBoundNames[j].length;
                if (bounds.length != boundCount) {
                    return false;
                }
                int k = 0;
                while (true) {
                    if (k >= boundCount) {
                        ++j;
                        continue block2;
                    }
                    String simpleName = Signature.getSimpleName(bounds[k]);
                    int index = simpleName.indexOf(60);
                    if (index != -1) {
                        simpleName = simpleName.substring(0, index);
                    }
                    if (!simpleName.equals(new String(typeParameterBoundNames[j][k]))) {
                        return false;
                    }
                    ++k;
                }
                break;
            }
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    protected IJavaElement findLocalElement(int pos) {
        IJavaElement res = null;
        if (this.openable instanceof org.eclipse.jdt.core.ICompilationUnit) {
            org.eclipse.jdt.core.ICompilationUnit cu = (org.eclipse.jdt.core.ICompilationUnit)((Object)this.openable);
            try {
                res = cu.getElementAt(pos);
            }
            catch (JavaModelException javaModelException) {}
        } else if (this.openable instanceof ClassFile) {
            ClassFile cf = (ClassFile)this.openable;
            try {
                res = cf.getElementAtConsideringSibling(pos);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return res;
    }

    protected IJavaElement findLocalElement(int pos, MethodScope scope) {
        if (scope != null && scope.isLambdaScope()) {
            IJavaElement parent = this.findLocalElement(pos, scope.enclosingMethodScope());
            org.eclipse.jdt.internal.compiler.ast.LambdaExpression expression = (org.eclipse.jdt.internal.compiler.ast.LambdaExpression)scope.originalReferenceContext();
            if (expression != null && expression.resolvedType != null && expression.resolvedType.isValidBinding()) {
                LambdaExpression lambdaElement = LambdaFactory.createLambdaExpression((JavaElement)parent, expression);
                return lambdaElement.getMethod();
            }
            return parent;
        }
        return this.findLocalElement(pos);
    }

    public IJavaElement findMethodFromBinding(MethodBinding method, String[] signatures, ReferenceBinding declaringClass) {
        IType foundType = this.resolveType(declaringClass.qualifiedPackageName(), declaringClass.qualifiedSourceName(), 0);
        if (foundType != null) {
            if (foundType instanceof BinaryType) {
                try {
                    return Util.findMethod(foundType, method.selector, signatures, method.isConstructor());
                }
                catch (JavaModelException e) {
                    return null;
                }
            }
            return foundType.getMethod(new String(method.selector), signatures);
        }
        return null;
    }

    public IJavaElement[] getElements() {
        int elementLength = this.elementIndex + 1;
        if (this.elements.length != elementLength) {
            this.elements = new IJavaElement[elementLength];
            System.arraycopy(this.elements, 0, this.elements, 0, elementLength);
        }
        return this.elements;
    }

    protected IModuleDescription resolveModule(char[] moduleName) {
        NameLookup.Answer answer = this.nameLookup.findModule(moduleName);
        if (answer != null) {
            return answer.module;
        }
        return null;
    }

    protected IType resolveType(char[] packageName, char[] typeName, int acceptFlags) {
        IJavaElement type = null;
        if (this.openable instanceof CompilationUnit && ((CompilationUnit)this.openable).isWorkingCopy()) {
            CompilationUnit wc = (CompilationUnit)this.openable;
            try {
                if ((packageName == null || packageName.length == 0) && wc.getPackageDeclarations().length == 0 || packageName != null && packageName.length != 0 && wc.getPackageDeclaration(new String(packageName)).exists()) {
                    char[][] compoundName = CharOperation.splitOn((char)'.', (char[])typeName);
                    if (compoundName.length > 0) {
                        type = wc.getType(new String(compoundName[0]));
                        int i = 1;
                        int length = compoundName.length;
                        while (i < length) {
                            type = type.getType(new String(compoundName[i]));
                            ++i;
                        }
                    }
                    if (type != null && !type.exists()) {
                        type = null;
                    }
                }
            }
            catch (JavaModelException compoundName) {
                // empty catch block
            }
        }
        if (type == null) {
            IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(packageName == null || packageName.length == 0 ? "" : new String(packageName), false);
            int i = 0;
            int length = pkgs == null ? 0 : pkgs.length;
            while (i < length) {
                type = this.nameLookup.findType(new String(typeName), pkgs[i], false, acceptFlags, false, true);
                if (type != null) break;
                ++i;
            }
            if (type == null) {
                String pName = "";
                if (packageName != null) {
                    pName = new String(packageName);
                }
                if (this.openable != null && this.openable.getParent().getElementName().equals(pName)) {
                    String tName = new String(typeName);
                    tName = tName.replace('.', '$');
                    IType[] allTypes = null;
                    try {
                        ArrayList list = this.openable.getChildrenOfType(7);
                        allTypes = new IType[list.size()];
                        list.toArray(allTypes);
                    }
                    catch (JavaModelException e) {
                        return null;
                    }
                    IType[] iTypeArray = allTypes;
                    int n = allTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType t = iTypeArray[n2];
                        if (t.getTypeQualifiedName().equals(tName)) {
                            return t;
                        }
                        ++n2;
                    }
                }
            }
        }
        return type;
    }

    protected IType resolveTypeByLocation(char[] packageName, char[] typeName, int acceptFlags, int start, int end) {
        IJavaElement type = null;
        if (this.openable instanceof CompilationUnit && this.openable.isOpen()) {
            CompilationUnit wc = (CompilationUnit)this.openable;
            try {
                if ((packageName == null || packageName.length == 0) && wc.getPackageDeclarations().length == 0 || packageName != null && packageName.length != 0 && wc.getPackageDeclaration(new String(packageName)).exists()) {
                    char[][] compoundName = CharOperation.splitOn((char)'.', (char[])typeName);
                    if (compoundName.length > 0) {
                        IType[] tTypes = wc.getTypes();
                        int i = 0;
                        int depth = 0;
                        while (i < tTypes.length) {
                            ISourceRange range = tTypes[i].getSourceRange();
                            if (range.getOffset() <= start && range.getOffset() + range.getLength() >= end && tTypes[i].getElementName().equals(new String(compoundName[depth]))) {
                                if (depth == compoundName.length - 1) {
                                    type = tTypes[i];
                                    break;
                                }
                                tTypes = tTypes[i].getTypes();
                                i = 0;
                                ++depth;
                                continue;
                            }
                            ++i;
                        }
                    }
                    if (type != null && !type.exists()) {
                        type = null;
                    }
                }
            }
            catch (JavaModelException compoundName) {
                // empty catch block
            }
        }
        if (type == null) {
            IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(packageName == null || packageName.length == 0 ? "" : new String(packageName), false);
            int i = 0;
            int length = pkgs == null ? 0 : pkgs.length;
            while (i < length) {
                type = this.nameLookup.findType(new String(typeName), pkgs[i], false, acceptFlags, false, true);
                if (type != null) break;
                ++i;
            }
            if (type == null) {
                String pName = "";
                if (packageName != null) {
                    pName = new String(packageName);
                }
                if (this.openable != null && this.openable.getParent().getElementName().equals(pName)) {
                    String tName = new String(typeName);
                    tName = tName.replace('.', '$');
                    IType[] allTypes = null;
                    try {
                        ArrayList list = this.openable.getChildrenOfType(7);
                        allTypes = new IType[list.size()];
                        list.toArray(allTypes);
                    }
                    catch (JavaModelException e) {
                        return null;
                    }
                    IType[] iTypeArray = allTypes;
                    int n = allTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType t = iTypeArray[n2];
                        if (t.getTypeQualifiedName().equals(tName)) {
                            return t;
                        }
                        ++n2;
                    }
                }
            }
        }
        return type;
    }
}

