/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;

public class StatusHelper {
    private static Class<?> JAVA_STATUS_CONTEXT;

    public static RefactoringStatus convertStatus(IStatus status) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            result.addEntry(child.getSeverity(), child.getMessage(), null, child.getPlugin(), child.getCode());
            ++n2;
        }
        return result;
    }

    public static RefactoringStatusContext createContext(IMember member) {
        Class<?> JavaStatusContext = StatusHelper.getJavaStatusContext();
        return (RefactoringStatusContext)ReflectionUtils.executePrivateMethod(JavaStatusContext, (String)"create", (Class[])new Class[]{IMember.class}, JavaStatusContext, (Object[])new Object[]{member});
    }

    public static RefactoringStatusContext createContext(ITypeRoot typeRoot, ISourceRange sourceRange) {
        Class<?> JavaStatusContext = StatusHelper.getJavaStatusContext();
        return (RefactoringStatusContext)ReflectionUtils.executePrivateMethod(JavaStatusContext, (String)"create", (Class[])new Class[]{ITypeRoot.class, ISourceRange.class}, JavaStatusContext, (Object[])new Object[]{typeRoot, sourceRange});
    }

    private static Class<?> getJavaStatusContext() {
        if (JAVA_STATUS_CONTEXT == null) {
            try {
                JAVA_STATUS_CONTEXT = Class.forName("org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext");
            }
            catch (ClassNotFoundException ignore) {
                try {
                    JAVA_STATUS_CONTEXT = Class.forName("org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext");
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return JAVA_STATUS_CONTEXT;
    }
}

