/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import groovyjarjarantlr.Token;
import java.util.Iterator;
import org.codehaus.groovy.antlr.GroovyTokenTypeBridge;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyDocumentScanner;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class SemicolonRemover
extends GroovyFormatter {
    private final MultiTextEdit edits;
    private final GroovyDocumentScanner scanner;

    public SemicolonRemover(ITextSelection sel, IDocument doc) {
        this(sel, doc, new MultiTextEdit());
    }

    public SemicolonRemover(ITextSelection sel, IDocument doc, MultiTextEdit edits) {
        super(sel, doc);
        this.edits = edits;
        this.scanner = new GroovyDocumentScanner(doc);
    }

    @Override
    public TextEdit format() {
        try {
            try {
                Iterator<Token> it = this.scanner.getTokens(this.selection).iterator();
                while (it.hasNext()) {
                    Token token = it.next();
                    if (token.getType() == GroovyTokenTypeBridge.LITERAL_enum) {
                        int block = 0;
                        while (it.hasNext()) {
                            token = it.next();
                            if (token.getType() == GroovyTokenTypeBridge.SEMI) {
                                if (block != 1) {
                                    this.checkOptionalSemicolon(token);
                                    continue;
                                }
                                Token t = token;
                                while ((t = this.scanner.getNextToken(t)) != null && (t.getType() == GroovyTokenTypeBridge.NLS || t.getType() == GroovyTokenTypeBridge.SL_COMMENT || t.getType() == GroovyTokenTypeBridge.ML_COMMENT)) {
                                }
                                if (t.getType() == GroovyTokenTypeBridge.IDENT) continue;
                                break;
                            }
                            if (token.getType() == GroovyTokenTypeBridge.LCURLY) {
                                ++block;
                                continue;
                            }
                            if (token.getType() == GroovyTokenTypeBridge.RCURLY && --block < 1) break;
                        }
                    }
                    this.checkOptionalSemicolon(token);
                }
            }
            catch (BadLocationException e) {
                GroovyCore.logException((String)"Cannot perform semicolon removal.", (Throwable)e);
                this.scanner.dispose();
            }
        }
        finally {
            this.scanner.dispose();
        }
        return this.edits;
    }

    private void checkOptionalSemicolon(Token token) throws BadLocationException {
        if (this.isOptionalSemicolon(token)) {
            this.edits.addChild((TextEdit)new DeleteEdit(this.scanner.getOffset(token), 1));
        }
    }

    private boolean isOptionalSemicolon(Token token) throws BadLocationException {
        if (token.getType() == GroovyTokenTypeBridge.SEMI && (token = this.scanner.getNextToken(token)) != null) {
            int type = token.getType();
            if (type == GroovyTokenTypeBridge.NLS) {
                while ((token = this.scanner.getNextToken(token)) != null && (type = token.getType()) == GroovyTokenTypeBridge.NLS) {
                }
                if (type != GroovyTokenTypeBridge.LPAREN && type != GroovyTokenTypeBridge.LCURLY && type != GroovyTokenTypeBridge.LBRACK) {
                    type = GroovyTokenTypeBridge.NLS;
                }
            }
            return type == GroovyTokenTypeBridge.RCURLY || type == GroovyTokenTypeBridge.SEMI || type == GroovyTokenTypeBridge.NLS || type == GroovyTokenTypeBridge.EOF;
        }
        return false;
    }
}

