/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testcloud.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.KatOneJwtToken;
import com.kms.katalon.session.core.model.Project;
import com.kms.katalon.testcloud.configuration.TestCloudRunConfiguration;
import com.kms.katalon.testcloud.core.model.APITestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudApplication;
import com.kms.katalon.testcloud.core.model.TestCloudApplicationRequest;
import com.kms.katalon.testcloud.core.model.TestCloudConfiguration;
import com.kms.katalon.testcloud.core.model.TestCloudDeviceRequest;
import com.kms.katalon.testcloud.core.model.TestCloudEntity;
import com.kms.katalon.testcloud.core.model.TestCloudEnvironment;
import com.kms.katalon.testcloud.core.model.TestCloudExecutionMode;
import com.kms.katalon.testcloud.core.model.TestCloudExecutionSessionResponse;
import com.kms.katalon.testcloud.core.model.TestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudMobileOS;
import com.kms.katalon.testcloud.core.model.TestCloudMobilePlatformName;
import com.kms.katalon.testcloud.core.model.TestCloudOS;
import com.kms.katalon.testcloud.core.model.TestCloudRemoteServerUrlRequest;
import com.kms.katalon.testcloud.core.model.TestCloudSessionType;
import com.kms.katalon.testcloud.core.model.TestCloudSessionTypeRequest;
import com.kms.katalon.testcloud.core.model.TestCloudSessionTypes;
import com.kms.katalon.testcloud.core.model.TestCloudTunnel;
import com.kms.katalon.testcloud.core.model.TestCloudUsage;
import com.kms.katalon.testcloud.core.model.exception.TestCloudAPIException;
import com.kms.katalon.testcloud.core.model.exception.TestCloudException;
import com.kms.katalon.testcloud.core.service.ITestCloudManager;
import com.kms.katalon.testcloud.core.service.ITestCloudService;
import com.kms.katalon.testcloud.driver.TestCloudDriverConnector;
import com.kms.katalon.testcloud.helper.SessionHelper;
import com.kms.katalon.testcloud.util.TestCloudModelParser;
import com.kms.katalon.testops.core.model.AnalyticsIntegrationSetting;
import com.kms.katalon.testops.core.model.TestOpsRequestOptions;
import com.kms.katalon.testops.core.model.TestOpsSession;
import com.kms.katalon.testops.core.model.exception.TestOpsException;
import com.kms.katalon.testops.core.services.ITestOpsManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class TestCloudManager
implements ITestCloudManager {
    private final Logger logger = LoggerFactory.getLogger(TestCloudManager.class);
    @Inject
    ITestCloudService testCloudService;
    @Inject
    ITestOpsManager testOpsManager;
    @Inject
    SessionHelper sessionHelper;
    ObjectMapper mapper = new ObjectMapper();
    private TestCloudSessionTypes testCloudSessionTypes;
    private TestCloudConfiguration[] configurations;

    public List<TestCloudMobileDevice> requestTestCloudDevices(TestCloudDeviceRequest request) {
        request.setOrganizationId(Long.toString(this.testOpsManager.getOrganizationIdOfActiveProject()));
        request.setProjectId(Long.toString(this.testOpsManager.getProjectId()));
        request.setKatOneToken(this.testOpsManager.getKatOneToken());
        try {
            return this.testCloudService.requestTestCloudDevices(this.testOpsManager.getTestCloudServerUrl(), request);
        }
        catch (JsonProcessingException | NetworkErrorException e) {
            this.logger.error(e.getMessage());
            return new ArrayList<TestCloudMobileDevice>();
        }
    }

    public List<TestCloudApplication> requestTestCloudApplications(TestCloudApplicationRequest request) {
        try {
            request.setOrganizationId(Long.toString(this.testOpsManager.getOrganizationIdOfActiveProject()));
            request.setProjectId(Long.toString(this.testOpsManager.getProjectId()));
            request.setKatOneToken(this.testOpsManager.getKatOneToken());
            return this.testCloudService.requestTestCloudApplications(this.testOpsManager.getTestCloudServerUrl(), request);
        }
        catch (MalformedContentException | NetworkErrorException e) {
            this.logger.error(e.getMessage());
            return new ArrayList<TestCloudApplication>();
        }
    }

    public IRunConfiguration buildRunConfiguration(TestCloudEntity entity, TestCloudSessionType type, TestCloudExecutionMode executionMode) throws TestCloudException {
        HashMap<String, String> katalonOptions;
        Project project = this.testOpsManager.getProject();
        if (project == null) {
            throw new TestCloudException("Failed to get project info");
        }
        Long organizationId = project.getOrganizationId();
        if (organizationId == null) {
            throw new TestCloudException("Failed to get organization info");
        }
        Long accountId = project.getAccountId();
        if (accountId == null) {
            throw new TestCloudException("Failed to get account info");
        }
        TestCloudRunConfiguration runConfiguration = null;
        try {
            runConfiguration = new TestCloudRunConfiguration(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        }
        catch (IOException e) {
            throw new TestCloudException((Throwable)e);
        }
        TestCloudDriverConnector testCloudDriverConnector = runConfiguration.getTestCloudDriverConnector();
        testCloudDriverConnector.setTestCloudEntity(entity);
        testCloudDriverConnector.setTestCloudSessionType(type);
        Map desiredCapabilities = testCloudDriverConnector.getAllConfigProperties();
        Map<String, Object> katalonOptionsCustomFromUser = this.getKatalonOptionCustomFromUser(desiredCapabilities);
        desiredCapabilities.putAll(entity.toDesireCapabilitiesMap());
        if (desiredCapabilities.containsKey("remoteWebDriverType")) {
            desiredCapabilities.remove("remoteWebDriverType");
        }
        if (desiredCapabilities.containsKey("remoteWebDriverUrl")) {
            desiredCapabilities.remove("remoteWebDriverUrl");
        }
        if (desiredCapabilities.containsKey("remoteMobileDriver")) {
            desiredCapabilities.remove("remoteMobileDriver");
        }
        if (entity instanceof TestCloudMobileDevice) {
            TestCloudMobileDevice testCloudMobileDevice = (TestCloudMobileDevice)entity;
            if (type.equals((Object)TestCloudSessionType.MOBILE_BROWSER)) {
                String browserName = testCloudMobileDevice.getPlatformName().equals((Object)TestCloudMobilePlatformName.ANDROID) ? "chrome" : "safari";
                desiredCapabilities.put("browserName", browserName);
                desiredCapabilities.put("browserVersion", "latest");
            }
        }
        if (Objects.isNull(katalonOptions = (HashMap<String, String>)desiredCapabilities.get("katalon:options"))) {
            katalonOptions = new HashMap<String, String>();
            desiredCapabilities.put("katalon:options", katalonOptions);
        }
        if (entity instanceof TestCloudMobileDevice) {
            katalonOptions.put("appiumVersion", "2.11.2");
        }
        if (((Boolean)katalonOptions.get("usingTunnel")).booleanValue()) {
            katalonOptions.put("tunnelId", "");
        }
        if (desiredCapabilities.get("appium:udid") != null) {
            katalonOptions.put("devicePool", "private_cloud");
        }
        katalonOptions.put("executionMode", executionMode.getMode());
        Map<String, HashMap<String, String>> katalonOptionsMerged = new HashMap();
        try {
            ObjectReader updater = this.mapper.readerForUpdating(katalonOptions);
            katalonOptionsMerged = (Map)updater.readValue(this.mapper.writeValueAsString(katalonOptionsCustomFromUser));
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Failed to merge user custom katalon:options", (Throwable)e);
            katalonOptionsMerged = katalonOptions;
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("organizationId", Long.toString(organizationId));
        metadata.put("projectId", Long.toString(project.getId()));
        metadata.put("accountId", Long.toString(accountId));
        metadata.put("channel", this.sessionHelper.getKatalonStudioChannel());
        katalonOptionsMerged.put("metadata", metadata);
        desiredCapabilities.put("katalon:options", katalonOptionsMerged);
        if (entity instanceof TestCloudMobileDevice) {
            TestCloudMobileDevice testCloudMobileDevice = (TestCloudMobileDevice)entity;
            if (testCloudMobileDevice.getPlatformName().equals((Object)TestCloudMobilePlatformName.ANDROID)) {
                testCloudDriverConnector.setMobileDriverType(MobileDriverType.ANDROID_DRIVER);
            } else {
                testCloudDriverConnector.setMobileDriverType(MobileDriverType.IOS_DRIVER);
            }
        }
        testCloudDriverConnector.setUserConfigProperties(desiredCapabilities);
        TestCloudRemoteServerUrlRequest request = new TestCloudRemoteServerUrlRequest();
        AuthenticationToken katOneToken = this.testOpsManager.getKatOneToken();
        KatOneJwtToken jwtToken = KatOneJwtToken.parseToken((String)katOneToken.getAccessToken());
        if (jwtToken.isExpiringSoon(30)) {
            try {
                this.testOpsManager.refreshToken();
            }
            catch (TestOpsException e) {
                this.logger.error("Failed to renew tokens", (Throwable)e);
            }
        }
        request.setKatOneToken(this.testOpsManager.getKatOneToken());
        request.setSupportNewTestCloudHub(this.isEnableSwitchToTestCloudHub());
        try {
            runConfiguration.setRemoteServerUrl(this.testCloudService.getTestCloudMobileRemoteServerUrl(this.testOpsManager.getTestCloudServerUrl(), request));
        }
        catch (URISyntaxException e) {
            throw new TestCloudException((Throwable)e);
        }
        if (type.equals((Object)TestCloudSessionType.MOBILE_NATIVE)) {
            runConfiguration.setRemoteWebDriverConnectorType(RemoteWebDriverConnector.RemoteWebDriverConnectorType.Appium);
        } else {
            runConfiguration.setRemoteWebDriverConnectorType(RemoteWebDriverConnector.RemoteWebDriverConnectorType.Selenium);
        }
        return runConfiguration;
    }

    private boolean isEnableSwitchToTestCloudHub() {
        try {
            return this.testOpsManager.getSetting().getIntegration().isEnableSwitchToTestCloudHub();
        }
        catch (TestOpsException e) {
            this.logger.warn("Failed to get isEnableSwitchToTestCloudHub", (Throwable)e);
            return false;
        }
    }

    private Map<String, Object> getKatalonOptionCustomFromUser(Map<String, Object> desiredCapabilities) {
        Map<String, Object> katalonOptionsCustomFromUser = new HashMap<String, Object>();
        if (desiredCapabilities.containsKey("katalon:options")) {
            Object objectKatalonOptions = desiredCapabilities.get("katalon:options");
            if (objectKatalonOptions instanceof Map) {
                katalonOptionsCustomFromUser = (Map)objectKatalonOptions;
            } else {
                this.logger.warn("Katalon options need to be a Dictionary type");
            }
        }
        return katalonOptionsCustomFromUser;
    }

    public TestCloudSessionTypes requestTestCloudSessionTypes() throws TestCloudException {
        return this.requestTestCloudSessionTypes(null);
    }

    public TestCloudSessionTypes requestTestCloudSessionTypes(TestOpsRequestOptions options) throws TestCloudException {
        TestCloudSessionTypeRequest request = new TestCloudSessionTypeRequest();
        if (options == null) {
            options = this.testOpsManager.getRequestOptions();
            options.setServerUrl(this.testOpsManager.getTestCloudServerUrl());
        }
        TestOpsSession toSession = options.getSession();
        AnalyticsIntegrationSetting integratedSetting = options.getIntegratedSetting();
        try {
            Long organizationId = this.determineSuitableOrganizationIdForTestCloud(toSession, integratedSetting);
            Long projectId = integratedSetting.getProject().getId();
            request.setOrganizationId(Long.toString(organizationId));
            request.setProjectId(Long.toString(projectId));
        }
        catch (NullPointerException nullPointerException) {
            throw new TestCloudException("Failed to get organization or project info");
        }
        request.setKatOneToken(toSession.getKatOneToken());
        try {
            this.testCloudSessionTypes = this.testCloudService.requestTestCloudSessionTypes(options.getServerUrl(), request);
        }
        catch (MalformedContentException | NetworkErrorException | TestCloudException | URISyntaxException e) {
            throw new TestCloudException(e);
        }
        return this.testCloudSessionTypes;
    }

    public boolean isMobileNativeSupported() throws TestCloudException {
        if (this.testCloudSessionTypes == null) {
            this.requestTestCloudSessionTypes();
        }
        return this.testCloudSessionTypes.isSupportedMobileNative();
    }

    public TestCloudApplication requestTestCloudApplication(TestCloudApplicationRequest request) throws TestCloudException {
        try {
            request.setOrganizationId(Long.toString(this.testOpsManager.getOrganizationIdOfActiveProject()));
            request.setProjectId(Long.toString(this.testOpsManager.getProjectId()));
            request.setKatOneToken(this.testOpsManager.getKatOneToken());
            return this.testCloudService.requestTestCloudApplication(this.testOpsManager.getTestCloudServerUrl(), request);
        }
        catch (MalformedContentException | NetworkErrorException e) {
            throw new TestCloudException(e);
        }
    }

    public boolean checkTestCloudLicense() throws TestCloudException {
        String serverUrl = this.testOpsManager.getTestCloudServerUrl();
        if (StringUtils.isBlank((CharSequence)serverUrl)) {
            return false;
        }
        TestCloudSessionTypes supportedSessionType = this.requestTestCloudSessionTypes();
        return supportedSessionType != null && CollectionUtils.isNotEmpty((Collection)supportedSessionType.getSupportedTestSessionTypes());
    }

    public TestCloudConfiguration[] getConfigurations() throws TestCloudAPIException {
        if (this.configurations == null || this.configurations.length <= 0) {
            try {
                AuthenticationToken katOneToken = this.testOpsManager.getKatOneToken();
                Long organizationId = this.determineSuitableOrganizationIdForTestCloud(null, null);
                Long projectId = this.testOpsManager.getProjectId();
                String serverUrl = this.testOpsManager.getTestCloudServerUrl();
                if (StringUtils.isEmpty((CharSequence)serverUrl)) {
                    throw new TestCloudAPIException("TestCloud server URL is null or empty.");
                }
                this.configurations = this.testCloudService.getConfigurations(serverUrl, katOneToken, organizationId, projectId);
            }
            catch (JsonProcessingException | NetworkErrorException e) {
                throw new TestCloudAPIException(e);
            }
        }
        return this.configurations;
    }

    public AuthenticationToken requestTestCloudToken() throws TestCloudAPIException {
        return this.testOpsManager.getKatOneToken();
    }

    public TestCloudEnvironment[] getEnvironments() throws TestCloudAPIException {
        try {
            AuthenticationToken katOneToken = this.testOpsManager.getKatOneToken();
            Long organizationId = this.determineSuitableOrganizationIdForTestCloud(null, null);
            Long projectId = this.testOpsManager.getProjectId();
            return this.testCloudService.getEnvironments(this.testOpsManager.getTestCloudServerUrl(), katOneToken, organizationId, projectId);
        }
        catch (JsonProcessingException | NetworkErrorException e) {
            throw new TestCloudAPIException(e);
        }
    }

    public APITestCloudMobileDevice[] getMobileDevices() throws TestCloudAPIException {
        try {
            AuthenticationToken katOneToken = this.testOpsManager.getKatOneToken();
            Long organizationId = this.testOpsManager.getOrganizationIdOfActiveProject();
            Long projectId = this.testOpsManager.getProjectId();
            return this.testCloudService.getAvailableMobileDevices(this.testOpsManager.getTestCloudServerUrl(), katOneToken, organizationId, projectId);
        }
        catch (JsonProcessingException | NetworkErrorException e) {
            throw new TestCloudAPIException(e);
        }
    }

    public List<TestCloudMobileOS> parseMobileDevicesForDialog(APITestCloudMobileDevice[] mobileDevices) {
        return TestCloudModelParser.parseArrayAPITestCloudMobileDevideToTestMobileDeviceList(mobileDevices);
    }

    public List<TestCloudOS> parseEnvironmentsToOSForDialog(TestCloudEnvironment[] environments) {
        return TestCloudModelParser.parseArrayAPITestCloudEnvironmentToTestCloudOSList(environments);
    }

    public int getOSTimeout(String os) throws TestCloudAPIException {
        return TestCloudModelParser.getOSTimeout(this.getConfigurations(), os);
    }

    public String getGATrialMessage() throws TestCloudAPIException {
        return TestCloudModelParser.getGATrialMessageNote(this.getConfigurations());
    }

    public TestCloudTunnel[] getTunnels() throws TestCloudAPIException {
        try {
            AuthenticationToken katOneToken = this.testOpsManager.getKatOneToken();
            Long organizationId = this.testOpsManager.getOrganizationIdOfActiveProject();
            Long projectId = this.testOpsManager.getProjectId();
            return this.testCloudService.getTunnels(this.testOpsManager.getTestCloudServerUrl(), katOneToken, organizationId, projectId);
        }
        catch (JsonProcessingException | NetworkErrorException | URISyntaxException e) {
            throw new TestCloudAPIException(e);
        }
    }

    public TestCloudUsage getUsage() throws TestCloudAPIException {
        AuthenticationToken katOneToken = this.testOpsManager.getKatOneToken();
        Long organizationId = this.testOpsManager.getOrganizationIdOfActiveProject();
        Long projectId = this.testOpsManager.getProjectId();
        try {
            return this.testCloudService.getUsage(katOneToken, organizationId, projectId);
        }
        catch (JsonProcessingException | NetworkErrorException | URISyntaxException e) {
            throw new TestCloudAPIException(e);
        }
    }

    public TestCloudExecutionSessionResponse getExecutionSession(String executionSessionId) throws TestCloudAPIException {
        AuthenticationToken katOneToken = this.testOpsManager.getKatOneToken();
        Long organizationId = this.testOpsManager.getOrganizationIdOfActiveProject();
        Long projectId = this.testOpsManager.getProjectId();
        try {
            return this.testCloudService.getExecutionSession(this.testOpsManager.getTestCloudServerUrl(), executionSessionId, katOneToken, organizationId, projectId);
        }
        catch (JsonProcessingException | NetworkErrorException | URISyntaxException e) {
            throw new TestCloudAPIException(e);
        }
    }

    private Long determineSuitableOrganizationIdForTestCloud(TestOpsSession testOpsSession, AnalyticsIntegrationSetting integrationSetting) {
        if (integrationSetting != null && integrationSetting.getProject() != null) {
            return integrationSetting.getProject().getOrganizationId();
        }
        Project project = this.testOpsManager.getProject();
        if (project != null) {
            return project.getOrganizationId();
        }
        if (testOpsSession != null && testOpsSession.getOrganization() != null) {
            return testOpsSession.getOrganization().getId();
        }
        if (this.testOpsManager.getOrganization() != null) {
            return this.testOpsManager.getOrganization().getId();
        }
        return null;
    }
}

