/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testcloud.util;

import com.kms.katalon.testcloud.core.model.APITestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudCapability;
import com.kms.katalon.testcloud.core.model.TestCloudConfiguration;
import com.kms.katalon.testcloud.core.model.TestCloudDesktopBrowser;
import com.kms.katalon.testcloud.core.model.TestCloudEnvironment;
import com.kms.katalon.testcloud.core.model.TestCloudMobileCapability;
import com.kms.katalon.testcloud.core.model.TestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudMobileOS;
import com.kms.katalon.testcloud.core.model.TestCloudMobileOSVersion;
import com.kms.katalon.testcloud.core.model.TestCloudMobilePlatformName;
import com.kms.katalon.testcloud.core.model.TestCloudOS;
import com.kms.katalon.testcloud.core.model.exception.TestCloudAPIException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class TestCloudModelParser {
    private static final int DEFAULT_CONNECT_TIMEOUT_IN_MINUTE = 2;

    public static TestCloudDesktopBrowser parseAPITestCloudEnvironmentToTestCloudBrowser(TestCloudEnvironment environment) {
        TestCloudDesktopBrowser result = new TestCloudDesktopBrowser();
        result.setId(environment.getId());
        result.setOs(environment.getOs());
        result.setBrowserName(environment.getBrowser());
        result.setBrowserVersion(environment.getBrowserVersion());
        result.setBrowserVersionType(environment.getBrowserVersionType());
        result.setOsDisplayName(environment.getOsDisplayName());
        result.setBrowserDisplayName(environment.getBrowserDisplayName());
        return result;
    }

    public static TestCloudMobileDevice parseAPITestCloudCapabilityToTestCloudMobileDevice(APITestCloudMobileDevice device, TestCloudMobileCapability mobile) {
        TestCloudMobileDevice result = new TestCloudMobileDevice();
        result.setId(mobile.getId());
        result.setMobileDeviceId(mobile.getDeviceId());
        result.setManufacturer(mobile.getManufacturer());
        result.setOs(mobile.getOs());
        result.setName(device.getName());
        result.setDisplayName(device.getDisplayName());
        result.setOsVersion(mobile.getVersion());
        TestCloudCapability testCloudCapability = new TestCloudCapability();
        testCloudCapability.setUdid(mobile.getUdid());
        testCloudCapability.setAvailability(mobile.getAvailability());
        result.setCapability(testCloudCapability);
        return result;
    }

    public static TestCloudMobileDevice parseAPITestCloudMobileDeviceToTestCloudMobileDevice(APITestCloudMobileDevice mobile, TestCloudMobileCapability mobileCaps, boolean isUsingTunnel, int timeout) throws TestCloudAPIException {
        TestCloudMobileDevice result = new TestCloudMobileDevice();
        result.setUsingTunnel(isUsingTunnel);
        result.setOs(mobile.getOs());
        result.setManufacturer(mobile.getManufacturer());
        result.setTablet(mobile.isTablet());
        result.setId(mobile.getId());
        result.setMobileDeviceId(mobileCaps.getDeviceId());
        result.setTimeout(timeout);
        result.setOsVersion(mobileCaps.getVersion());
        result.setName(mobileCaps.getDeviceName());
        return result;
    }

    public static List<TestCloudOS> parseArrayAPITestCloudEnvironmentToTestCloudOSList(TestCloudEnvironment[] environments) {
        ArrayList<TestCloudOS> osList = new ArrayList<TestCloudOS>();
        TestCloudEnvironment[] testCloudEnvironmentArray = environments;
        int n = environments.length;
        int n2 = 0;
        while (n2 < n) {
            TestCloudEnvironment environment = testCloudEnvironmentArray[n2];
            Optional<TestCloudOS> mappedOS = osList.stream().filter(e -> e.getOs().equalsIgnoreCase(environment.getOs())).findFirst();
            TestCloudDesktopBrowser desktopBrowser = TestCloudModelParser.parseAPITestCloudEnvironmentToTestCloudBrowser(environment);
            if (mappedOS.isPresent()) {
                mappedOS.get().addBrowser(desktopBrowser);
            } else {
                osList.add(new TestCloudOS(desktopBrowser));
            }
            ++n2;
        }
        return osList;
    }

    public static List<TestCloudMobileOS> parseArrayAPITestCloudMobileDevideToTestMobileDeviceList(APITestCloudMobileDevice[] environments) {
        ArrayList<TestCloudMobileOS> mobileDeviceList = new ArrayList<TestCloudMobileOS>();
        APITestCloudMobileDevice[] aPITestCloudMobileDeviceArray = environments;
        int n = environments.length;
        int n2 = 0;
        while (n2 < n) {
            APITestCloudMobileDevice environment = aPITestCloudMobileDeviceArray[n2];
            if (environment.getOs().equalsIgnoreCase(TestCloudMobilePlatformName.ANDROID.toString()) || environment.getOs().equalsIgnoreCase(TestCloudMobilePlatformName.IOS.toString())) {
                Optional<TestCloudMobileOS> mappedOS = mobileDeviceList.stream().filter(e -> e.getOs().equalsIgnoreCase(environment.getOs())).findFirst();
                if (mappedOS.isPresent()) {
                    osVersions = TestCloudModelParser.parseMobileCapabilitiesToMobileOSVersions(mappedOS.get().getOsVersions(), environment);
                    mappedOS.get().setOsVersions(osVersions);
                } else {
                    osVersions = TestCloudModelParser.parseMobileCapabilitiesToMobileOSVersions(null, environment);
                    mobileDeviceList.add(new TestCloudMobileOS(environment.getOs(), osVersions));
                }
            }
            ++n2;
        }
        return mobileDeviceList;
    }

    private static List<TestCloudMobileOSVersion> parseMobileCapabilitiesToMobileOSVersions(List<TestCloudMobileOSVersion> existingOsVersions, APITestCloudMobileDevice device) {
        ArrayList<TestCloudMobileOSVersion> updatedOsVersions = new ArrayList<TestCloudMobileOSVersion>();
        if (existingOsVersions != null) {
            updatedOsVersions.addAll(existingOsVersions);
        }
        for (TestCloudMobileCapability capability : device.getCapabilities()) {
            capability.setOs(device.getOs());
            capability.setManufacturer(device.getManufacturer());
            capability.setId(device.getId());
            Optional<TestCloudMobileOSVersion> mappedOSVersion = updatedOsVersions.stream().filter(e -> e.getOsVersion().equalsIgnoreCase(capability.getVersion())).findFirst();
            TestCloudMobileDevice deviceList = TestCloudModelParser.parseAPITestCloudCapabilityToTestCloudMobileDevice(device, capability);
            if (mappedOSVersion.isPresent()) {
                mappedOSVersion.get().addDeviceList(deviceList);
                continue;
            }
            updatedOsVersions.add(new TestCloudMobileOSVersion(deviceList));
            Collections.sort(updatedOsVersions, new Comparator<TestCloudMobileOSVersion>(){

                @Override
                public int compare(TestCloudMobileOSVersion os1, TestCloudMobileOSVersion os2) {
                    int major2;
                    String[] v1 = os1.getOsVersion().split("\\.");
                    String[] v2 = os2.getOsVersion().split("\\.");
                    int major1 = this.major(v1);
                    if (major1 == (major2 = this.major(v2))) {
                        int minorCompare = this.minor(v2).compareTo(this.minor(v1));
                        if (minorCompare == 0) {
                            return this.miniMinor(v2).compareTo(this.miniMinor(v1));
                        }
                        return minorCompare;
                    }
                    return major2 > major1 ? 1 : -1;
                }

                private int major(String[] version) {
                    return Integer.parseInt(version[0]);
                }

                private Integer minor(String[] version) {
                    return version.length > 1 ? Integer.parseInt(version[1]) : -1;
                }

                private Integer miniMinor(String[] version) {
                    return version.length > 2 ? Integer.parseInt(version[2]) : -1;
                }
            });
        }
        return updatedOsVersions;
    }

    public static int getOSTimeout(TestCloudConfiguration[] configurations, String os) throws TestCloudAPIException {
        if (configurations == null || configurations.length <= 0) {
            return 2;
        }
        String osTimeoutConfigName = os.concat("NodePreparationTime");
        TestCloudConfiguration[] testCloudConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            TestCloudConfiguration configuration = testCloudConfigurationArray[n2];
            if (configuration.getName().equalsIgnoreCase(osTimeoutConfigName)) {
                int timeout = Integer.valueOf(configuration.getValue());
                return timeout;
            }
            ++n2;
        }
        return 2;
    }

    public static String getGATrialMessageNote(TestCloudConfiguration[] configurations) {
        if (configurations == null || configurations.length <= 0) {
            return "";
        }
        String noteConfigName = "GATrialMessage";
        TestCloudConfiguration[] testCloudConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            TestCloudConfiguration configuration = testCloudConfigurationArray[n2];
            if (configuration.getName().equalsIgnoreCase(noteConfigName)) {
                String note = configuration.getValue();
                return note;
            }
            ++n2;
        }
        return "";
    }

    public static boolean getConfigTestCloudAutomationHub(TestCloudConfiguration[] configurations) {
        if (configurations == null || configurations.length <= 0) {
            return false;
        }
        String noteConfigName = "TurnOnTestCloudAutomationHub";
        TestCloudConfiguration[] testCloudConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            TestCloudConfiguration configuration = testCloudConfigurationArray[n2];
            if (configuration.getName().equalsIgnoreCase(noteConfigName)) {
                boolean note = Boolean.valueOf(configuration.getValue());
                return note;
            }
            ++n2;
        }
        return false;
    }
}

