/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.internal;

import com.equo.chromium.ChromiumBrowser;
import com.equo.chromium.CompatibleWithHost;
import com.equo.chromium.internal.Engine;
import com.equo.chromium.internal.ResourceExpander;
import com.equo.chromium.swt.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cef.OS;

public class CompatibleWithHostImpl
implements CompatibleWithHost {
    private String toolkitClass = "com.equo.chromium.internal.WindowlessCompatibility";

    @Override
    public CompatibleWithHost windowless() {
        return this;
    }

    private static String getJavaExecutablePath() {
        try {
            Optional optional;
            Class<?> processHandleClass = Class.forName("java.lang.ProcessHandle");
            Method currentMethod = processHandleClass.getMethod("current", new Class[0]);
            Object currentProcessHandle = currentMethod.invoke(null, new Object[0]);
            Method infoMethod = currentProcessHandle.getClass().getMethod("info", new Class[0]);
            infoMethod.setAccessible(true);
            Object processHandleInfo = infoMethod.invoke(currentProcessHandle, new Object[0]);
            Class<?> processHandleInfoClass = Class.forName("java.lang.ProcessHandle$Info");
            Method commandMethod = processHandleInfoClass.getMethod("command", new Class[0]);
            Object optionalCommand = commandMethod.invoke(processHandleInfo, new Object[0]);
            if (optionalCommand instanceof Optional && (optional = (Optional)optionalCommand).isPresent()) {
                String command = (String)optional.get();
                return command;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CompatibleWithHostImpl.getJavaExecutableFromJavaHome();
    }

    private static String getJavaExecutableFromJavaHome() {
        String javaHome = System.getProperty("java.home");
        String javaExec = String.valueOf(javaHome) + File.separator + "bin" + File.separator + "java";
        if (OS.isWindows()) {
            javaExec = String.valueOf(javaExec) + ".exe";
        }
        return javaExec;
    }

    private String getCp() {
        CodeSource codeSource = ChromiumBrowser.class.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            URL jarLocation = codeSource.getLocation();
            String locationPath = jarLocation.getPath().replaceAll("/$", "");
            return locationPath.endsWith("/bin") || locationPath.endsWith(".jar") ? jarLocation.getPath() : String.valueOf(jarLocation.getPath()) + "bin";
        }
        Log.debug("- The chromium jar location could not be determined. Error.");
        return null;
    }

    private boolean checkExecutionPermissions(Path path) {
        final AtomicBoolean result = new AtomicBoolean(true);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!CompatibleWithHostImpl.canExecute(file.toFile())) {
                        result.set(false);
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            Log.debug("- Permission check failed with error: " + e.getMessage());
            return false;
        }
        return result.get();
    }

    private static boolean canExecute(File newFile) {
        String[] executables = new String[]{"", "exe"};
        if (Arrays.asList(executables).contains(ResourceExpander.getExtension(newFile.getName()))) {
            if (!newFile.canExecute()) {
                Log.debug("- The file '" + newFile.getName() + "' does not have execution permissions.");
                return false;
            }
            Log.debug("- The file '" + newFile.getName() + "' has execution permissions.");
        }
        return true;
    }

    private static CompletableFuture<String> completeWithTimeout(long timeout, TimeUnit unit) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.schedule(() -> {
            if (!future.isDone()) {
                future.completeExceptionally(new Throwable("The check is terminated by timeout."));
            }
        }, timeout, unit);
        return future;
    }

    @Override
    public CompletableFuture<String> check() {
        CompletableFuture<String> result = CompatibleWithHostImpl.completeWithTimeout(10L, TimeUnit.SECONDS);
        String userHome = System.getProperty("user.home");
        File equoDir = null;
        if (userHome != null && !(equoDir = new File(userHome, ".equo")).exists()) {
            if (equoDir.mkdirs()) {
                Log.debug("- Created .equo directory.");
            } else {
                Log.debug("- Failed to create .equo directory.");
            }
        }
        Path libsPath = this.verifyRequiredLibraries(result);
        if (result.isDone()) {
            return result;
        }
        Log.debug(System.lineSeparator());
        Log.debug("--------- Check execution permissions ---------");
        this.checkExecutionPermissions(Paths.get(libsPath.toString(), "chromium-6613"));
        Log.debug("--------- Check execution permissions ---------" + System.lineSeparator());
        List<String> commandLine = this.generateCommandLine(libsPath);
        Log.debug("- CommandLine to execute: " + commandLine + System.lineSeparator());
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        this.addEnvVarsToFile();
        try {
            Process process = processBuilder.start();
            new Thread(() -> this.logOutputStream(process.getInputStream())).start();
            new Thread(() -> this.logOutputStream(process.getErrorStream())).start();
            new Thread(() -> {
                try {
                    int exitCode = process.waitFor();
                    Log.debug("- Process exit with code: " + exitCode);
                    result.complete("");
                }
                catch (InterruptedException e) {
                    Log.debug("- Failure during the process. " + e.getMessage());
                    result.completeExceptionally(e);
                }
            }).start();
        }
        catch (IOException e) {
            Log.debug("- Failure to execute the process with error: " + e.getMessage());
            result.completeExceptionally(e);
        }
        return result;
    }

    private void logOutputStream(InputStream outputStream) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(outputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Log.debug(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Log.debug("- Error reading command line's process output: " + e.getMessage());
        }
    }

    private void addEnvVarsToFile() {
        String[] envVars = new String[]{"LD_PRELOAD", "LD_LIBRARY_PATH", "GDK_BACKEND", "BREAKPAD_DUMP_LOCATION"};
        Log.debug("--------- Environment Variables ---------");
        String[] stringArray = envVars;
        int n = envVars.length;
        int n2 = 0;
        while (n2 < n) {
            String envVar = stringArray[n2];
            Log.debug(String.valueOf(envVar) + "=" + this.getVarOrEmpty(envVar));
            ++n2;
        }
        Log.debug("--------- Environment Variables ---------" + System.lineSeparator());
    }

    private String getVarOrEmpty(String name) {
        String envVar = System.getenv(name);
        return envVar != null ? envVar : "";
    }

    private Path verifyRequiredLibraries(CompletableFuture<String> result) {
        Path libsPath = null;
        try {
            Log.debug("--------- Verify required libraries  ---------");
            libsPath = Engine.findLibsPath();
            Log.debug("--------- End verify required libraries ---------");
        }
        catch (UnsatisfiedLinkError e) {
            Log.debug("- Error when verify required libraries : " + e.getMessage());
            result.completeExceptionally(e);
        }
        return libsPath;
    }

    private List<String> generateCommandLine(Path libsPath) {
        String classpath = this.getCp();
        Log.debug("- Classpath: " + classpath);
        String javaBin = CompatibleWithHostImpl.getJavaExecutablePath();
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.add("-Dchromium.debug=true");
        jvmArgs.add("-Dchromium.path=" + libsPath);
        if (OS.isMacintosh()) {
            jvmArgs.add("-XstartOnFirstThread");
        }
        String[] stringArray = Engine.getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propName = stringArray[n2];
            String propValue = System.getProperty(propName, "");
            if (!(propValue.isEmpty() || propName.startsWith("chromium.path") || propName.startsWith("chromium.debug") || propName.startsWith("chromium.force_windowless_swt"))) {
                jvmArgs.add("-D" + propName + "=" + propValue);
            }
            ++n2;
        }
        jvmArgs.add("-Dchromium.cef version=" + Engine.getPropertiesFromResource("chromium-6613/chromium.properties").get("version"));
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        command.addAll(jvmArgs);
        command.add("-cp");
        command.add(classpath);
        command.add(this.toolkitClass);
        return command;
    }
}

